/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Color;
import java.awt.SystemColor;
import se.datadosen.jalbum.Config;

public class JAlbumColor {
    public static final Color rubberBand = new Color(SystemColor.textHighlight.getRed(), SystemColor.textHighlight.getGreen(), SystemColor.textHighlight.getBlue(), 70);
    public static final Color albumHighlight = JAlbumColor.dilute(SystemColor.textHighlight, 20);
    public static final Color albumHover = JAlbumColor.dilute(SystemColor.textHighlight, 19);
    public static final Color albumButtonsBackground = JAlbumColor.dilute(SystemColor.textHighlight, 100);
    public static final Color border = new Color(165, 165, 165);

    private JAlbumColor() {
    }

    public static Color getColorFor(Config.LabelType lt) {
        switch (lt) {
            case title: {
                return Color.blue;
            }
            case keywords: {
                return new Color(0, 128, 0);
            }
        }
        return SystemColor.textText;
    }

    public static int grayLevel(Color c) {
        return (c.getRed() * 30 + c.getGreen() * 59 + c.getBlue() * 11) / 100;
    }

    public static Color darken(Color c, int percent) {
        int left = 100 - percent;
        return new Color(c.getRed() * left / 100, c.getGreen() * left / 100, c.getBlue() * left / 100, c.getAlpha());
    }

    public static Color blend(Color c1, Color c2) {
        return new Color((c1.getRed() + c2.getRed()) / 2, (c1.getGreen() + c2.getGreen()) / 2, (c1.getBlue() + c2.getBlue()) / 2, (c1.getAlpha() + c2.getAlpha()) / 2);
    }

    private static Color dilute(Color c, int distance) {
        int targetLevel = JAlbumColor.grayLevel(SystemColor.text);
        while (Math.abs(targetLevel - JAlbumColor.grayLevel(c)) > distance) {
            c = JAlbumColor.blend(c, SystemColor.text);
        }
        return c;
    }
}

