/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.jdesktop.swingworker.SwingWorker;
import se.datadosen.component.JProgressSpinner;
import se.datadosen.component.JSmartDialog;
import se.datadosen.component.JSmartTextArea;
import se.datadosen.component.JSmartTextField;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.tags.ElementException;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.Debug;

public class JEmbedDialog
extends JSmartDialog {
    Action copyToClipboardAction = new AbstractAction(Msg.get("ui.copyToClipboard")){

        public void actionPerformed(ActionEvent e) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(JEmbedDialog.this.codeArea.getText()), null);
        }
    };
    Action closeAction = new AbstractAction(Msg.get("close")){

        public void actionPerformed(ActionEvent e) {
            if (JEmbedDialog.this.codeWorker != null && !JEmbedDialog.this.codeWorker.isDone()) {
                JEmbedDialog.this.codeWorker.cancel(true);
            }
            JEmbedDialog.this.setVisible(false);
        }
    };
    Action updateAction = new AbstractAction(Msg.get("edit.update")){

        public void actionPerformed(ActionEvent e) {
            Config cfg = Config.getConfig();
            JEmbedDialog.this.spinner.workStarted();
            JEmbedDialog.this.updateAction.setEnabled(false);
            JEmbedDialog.this.codeWorker = new SwingWorker<String, Object>(){

                protected String doInBackground() throws Exception {
                    JEmbedDialog.this.window.ui2Engine();
                    AlbumBean engine = JEmbedDialog.this.window.getEngine();
                    BeanBinder.setProperties((Object)engine, JEmbedDialog.this);
                    return engine.makeEmbedCode();
                }

                protected void done() {
                    try {
                        JEmbedDialog.this.spinner.workDone();
                        JEmbedDialog.this.updateAction.setEnabled(true);
                        if (this.isCancelled()) {
                            return;
                        }
                        String code = (String)this.get();
                        JEmbedDialog.this.codeArea.setText(code);
                        JEmbedDialog.this.codeArea.selectAll();
                        JEmbedDialog.this.copyToClipboardAction.setEnabled(true);
                    }
                    catch (InterruptedException ex) {
                    }
                    catch (ExecutionException ex) {
                        try {
                            throw ex.getCause();
                        }
                        catch (ElementException elex) {
                            Debug.showStackTraceDialog(JEmbedDialog.this.window, ex.getCause());
                        }
                        catch (Throwable t) {
                            while (t.getCause() != null) {
                                t = t.getCause();
                            }
                            Debug.showErrorDialog(JEmbedDialog.this.window, t);
                        }
                    }
                }
            };
            JEmbedDialog.this.codeWorker.execute();
        }
    };
    JAlbumFrame window;
    JLabel embedInfo = new JLabel(Msg.get("ui.embedInfo"));
    JLabel albumWidthLabel = new JLabel(Msg.get("ui.albumWidth"));
    JTextField albumWidth = new JSmartTextField(4);
    JLabel albumHeightLabel = new JLabel(Msg.get("ui.albumHeight"));
    JTextField albumHeight = new JSmartTextField(4);
    JLabel embedCodeLabel = new JLabel(Msg.get("ui.embedCode"));
    JProgressSpinner spinner = new JProgressSpinner();
    JTextArea codeArea = new JSmartTextArea(8, 50);
    SwingWorker codeWorker;

    public JEmbedDialog(JAlbumFrame window) throws HeadlessException {
        super(window, Msg.get("ui.embedAlbum"), false);
        this.window = window;
        this.init();
    }

    private void init() {
        this.embedInfo.setIcon(Icons.getIcon("small.embed"));
        this.codeArea.setFocusTraversalKeys(0, null);
        this.codeArea.setFocusTraversalKeys(1, null);
        this.codeArea.setEditable(false);
        this.codeArea.setLineWrap(true);
        this.codeArea.setWrapStyleWord(true);
        this.setLayout(new RiverLayout());
        this.add("p", this.embedInfo);
        this.add("p", this.albumWidthLabel);
        this.add("", this.albumWidth);
        this.add("tab", this.albumHeightLabel);
        this.add("", this.albumHeight);
        this.add("tab", new JButton(this.updateAction));
        this.add("", this.spinner);
        this.add("p", this.embedCodeLabel);
        this.add("br hfill vfill", new JScrollPane(this.codeArea));
        this.registerActions(this.copyToClipboardAction, this.closeAction);
        this.pack();
        this.spinner.setHidden(true);
        AlbumBean engine = this.window.getEngine();
        BeanBinder.getProperties((Object)engine, this);
        this.copyToClipboardAction.setEnabled(false);
        this.updateAction.actionPerformed(null);
    }
}

