/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.sun.awt.AWTUtilities;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JWindow;
import se.datadosen.component.JProgressSpinner;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Frog;
import se.datadosen.jalbum.JAlbum;

class SplashScreen
extends JWindow {
    private final int AWARD_YOFFSET = 100;
    private BufferedImage splash;
    private Image background;
    private File customSplash;
    boolean firstPaint;
    private JProgressSpinner spinner;

    public SplashScreen() {
        super(new Frame());
        this.customSplash = new File(Config.getConfig().progDir, "res/splash.png");
        this.firstPaint = true;
        this.spinner = new JProgressSpinner(28);
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (!b) {
            this.spinner.setSpinning(false);
        }
    }

    private void init() throws Exception {
        block4: {
            if (!this.customSplash.exists()) {
                ImageIcon ii = new ImageIcon(this.getClass().getResource("images/splash.png"));
                this.splash = new BufferedImage(ii.getIconWidth(), ii.getIconHeight(), 2);
                Graphics g = this.splash.getGraphics();
                g.drawImage(ii.getImage(), 0, 0, this.splash.getWidth(), this.splash.getHeight(), null);
            }
            this.setSize(this.splash.getWidth(), this.splash.getHeight());
            Toolkit tk = Toolkit.getDefaultToolkit();
            Dimension screenSize = tk.getScreenSize();
            Dimension frameSize = this.getSize();
            this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
            try {
                AWTUtilities.setWindowOpaque((Window)this, (boolean)false);
            }
            catch (Throwable t) {
                if ("Mac OS X".equals(System.getProperty("os.name"))) break block4;
                Robot rbt = new Robot();
                this.background = rbt.createScreenCapture(this.getBounds());
                System.out.println("Creating background");
            }
        }
        if (!this.customSplash.exists()) {
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.isAltDown()) {
                        JAlbum.dumpThreads();
                    } else {
                        Frog dor = new Frog();
                        dor.ribbit();
                    }
                }
            });
        }
        this.add((Component)new JSplashPanel(), "Center");
        this.validate();
    }

    private class JSplashPanel
    extends JPanel {
        public JSplashPanel() {
            this.init();
        }

        public JSplashPanel(LayoutManager layout) {
            this.init();
        }

        private void init() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 14, 0));
            this.setOpaque(true);
            SplashScreen.this.spinner.setHidden(true);
            SplashScreen.this.spinner.setVisible(false);
            this.add((Component)SplashScreen.this.spinner, "South");
        }

        public void paintComponent(Graphics gg) {
            Graphics2D g = (Graphics2D)gg;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (SplashScreen.this.background != null) {
                g.drawImage(SplashScreen.this.background, 0, 0, null);
            }
            Composite oldComposite = g.getComposite();
            g.setComposite(AlphaComposite.Src);
            g.drawImage((Image)SplashScreen.this.splash, 0, 0, this);
            g.setComposite(oldComposite);
            if (!SplashScreen.this.customSplash.exists()) {
                if (!SplashScreen.this.firstPaint) {
                    g.setFont(new Font("SansSerif", 1, 11));
                    g.setColor(Color.white);
                    String versionText = "11.6.14";
                    g.drawString(versionText, 178, 58);
                } else {
                    SplashScreen.this.spinner.setHidden(false);
                    SplashScreen.this.spinner.setVisible(true);
                    SplashScreen.this.firstPaint = false;
                    this.repaint();
                }
            }
        }
    }
}

