/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.text.JTextComponent;
import se.datadosen.component.JColorSelector;
import se.datadosen.tags.AttributeTokenizer;
import se.datadosen.tags.ElementException;
import se.datadosen.util.Attributizer;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.Item;
import se.datadosen.util.JComponentHolder;
import se.datadosen.util.PersistentList;
import se.datadosen.util.annotations.Bound;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapBinder {
    private static Map<Class, ComponentBinder> componentBinders = new HashMap<Class, ComponentBinder>();

    public static Map<String, Object> getMap(JComponentHolder jComponentHolder) {
        return MapBinder.getMap(jComponentHolder, new HashMap<String, Object>());
    }

    public static Map<String, Object> getMap(JComponentHolder jComponentHolder, Map<String, Object> existing) {
        Map<String, Object> map = existing;
        try {
            Field[] fields;
            Class<?> guiClass = jComponentHolder.getClass();
            for (Field field : fields = BeanBinder.getFields(guiClass)) {
                Object comp;
                String name = field.getName();
                field.setAccessible(true);
                int mods = field.getModifiers();
                if (Modifier.isPrivate(mods) || Modifier.isProtected(mods) || (comp = field.get(jComponentHolder)) == null) continue;
                if (comp instanceof JComponentHolder) {
                    if (field.getName().startsWith("this$")) continue;
                    Map<String, Object> subMap = MapBinder.getMap((JComponentHolder)comp);
                    map.putAll(subMap);
                    continue;
                }
                if (componentBinders.containsKey(comp.getClass()) && (comp instanceof JComponent || field.getAnnotation(Bound.class) != null)) {
                    ComponentBinder mgr = componentBinders.get(comp.getClass());
                    map.put(name, mgr.getValue(comp));
                    continue;
                }
                if (comp instanceof JComponent) {
                    if (comp instanceof JTextComponent) {
                        JTextComponent tc = (JTextComponent)comp;
                        map.put(name, tc.getText());
                        continue;
                    }
                    if (comp instanceof JComboBox) {
                        JComboBox jc = (JComboBox)comp;
                        Object sel = jc.getSelectedItem();
                        if (sel == null) continue;
                        if (sel instanceof Item) {
                            sel = ((Item)sel).value.toString();
                        }
                        map.put(name, sel);
                        continue;
                    }
                    if (comp instanceof JCheckBox) {
                        JCheckBox cb = (JCheckBox)comp;
                        map.put(name, cb.isSelected());
                        continue;
                    }
                    if (comp instanceof JToggleButton) {
                        JToggleButton tb = (JToggleButton)comp;
                        map.put(name, tb.isSelected());
                        continue;
                    }
                    if (comp instanceof JColorSelector) {
                        JColorSelector cs = (JColorSelector)comp;
                        map.put(name, cs.getHTMLColor());
                        continue;
                    }
                    if (comp instanceof JSlider) {
                        JSlider js = (JSlider)comp;
                        map.put(name, js.getValue());
                        continue;
                    }
                    if (!(comp instanceof PersistentList)) continue;
                    StringBuilder buf = new StringBuilder();
                    for (String s : ((PersistentList)comp).getContent()) {
                        if (buf.length() > 0) {
                            buf.append('\t');
                        }
                        buf.append(s);
                    }
                    map.put(name, buf.toString());
                    continue;
                }
                if (comp instanceof ButtonGroup) {
                    ButtonGroup bg = (ButtonGroup)comp;
                    Enumeration<AbstractButton> buttons = bg.getElements();
                    while (buttons.hasMoreElements()) {
                        AbstractButton button = buttons.nextElement();
                        if (!button.isSelected()) continue;
                        map.put(name, button.getActionCommand());
                    }
                    continue;
                }
                if (!(comp instanceof Attributizer)) continue;
                Attributizer attr = (Attributizer)comp;
                map.put(name, attr.getAttributes());
            }
            return map;
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    public static void syncUI(Map<String, Object> props, JComponentHolder jComponentHolder) {
        try {
            Field[] fields;
            Class<?> guiClass = jComponentHolder.getClass();
            block4: for (Field field : fields = BeanBinder.getFields(guiClass)) {
                Object comp;
                String name = field.getName();
                field.setAccessible(true);
                int mods = field.getModifiers();
                if (Modifier.isPrivate(mods) || Modifier.isProtected(mods) || (comp = field.get(jComponentHolder)) == null || !props.containsKey(name) && !(comp instanceof JComponentHolder)) continue;
                if (comp instanceof JComponentHolder) {
                    if (field.getName().startsWith("this$")) continue;
                    MapBinder.syncUI(props, (JComponentHolder)comp);
                    continue;
                }
                String value = props.get(name).toString();
                if (componentBinders.containsKey(comp.getClass()) && (comp instanceof JComponent || field.getAnnotation(Bound.class) != null)) {
                    ComponentBinder mgr = componentBinders.get(comp.getClass());
                    mgr.setValue(comp, value);
                    continue;
                }
                if (comp instanceof JComponent) {
                    if (comp instanceof JTextComponent) {
                        JTextComponent tc = (JTextComponent)comp;
                        tc.setText(value);
                        continue;
                    }
                    if (comp instanceof JComboBox) {
                        JComboBox jc = (JComboBox)comp;
                        boolean setOk = false;
                        for (int k = 0; k < jc.getItemCount(); ++k) {
                            Object item = jc.getItemAt(k);
                            if (item instanceof Integer) {
                                item = ((Integer)item).toString();
                            }
                            if (!item.equals(value)) continue;
                            jc.setSelectedIndex(k);
                            setOk = true;
                            break;
                        }
                        if (setOk) continue;
                        jc.setSelectedItem(value);
                        continue;
                    }
                    if (comp instanceof JCheckBox) {
                        JCheckBox cb = (JCheckBox)comp;
                        cb.setSelected(value.equals("true") || value.equals("yes") || value.equals("1"));
                        continue;
                    }
                    if (comp instanceof JToggleButton) {
                        JToggleButton tb = (JToggleButton)comp;
                        tb.setSelected(value.equals("true") || value.equals("yes") || value.equals("1"));
                        continue;
                    }
                    if (comp instanceof JColorSelector) {
                        JColorSelector cs = (JColorSelector)comp;
                        cs.setColor(value);
                        continue;
                    }
                    if (comp instanceof JSlider) {
                        JSlider js = (JSlider)comp;
                        js.setValue(Integer.parseInt(value));
                        continue;
                    }
                    if (!(comp instanceof PersistentList)) continue;
                    ArrayList<String> values = new ArrayList<String>();
                    if (value.startsWith("item") && value.indexOf(9) == -1) {
                        try {
                            String val;
                            Properties p = AttributeTokenizer.getProperties(value);
                            int j = 1;
                            while ((val = p.getProperty("item" + j)) != null) {
                                values.add(val);
                                ++j;
                            }
                        }
                        catch (ElementException ex) {
                            throw new RuntimeException(ex);
                        }
                    } else {
                        StringTokenizer tokens = new StringTokenizer(value, "\t");
                        while (tokens.hasMoreTokens()) {
                            values.add(tokens.nextToken());
                        }
                    }
                    ((PersistentList)comp).setContent(values);
                    continue;
                }
                if (!(comp instanceof ButtonGroup)) continue;
                ButtonGroup bg = (ButtonGroup)comp;
                Enumeration<AbstractButton> buttons = bg.getElements();
                while (buttons.hasMoreElements()) {
                    AbstractButton button = buttons.nextElement();
                    String ac = button.getActionCommand();
                    if (ac == null || !ac.equals(value)) continue;
                    bg.setSelected(button.getModel(), true);
                    continue block4;
                }
            }
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    private static String toAttributes(List<String> values) {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < values.size(); ++i) {
            if (!first) {
                buf.append(' ');
            }
            first = false;
            buf.append("item" + (i + 1) + "=\"" + values.get(i) + "\"");
        }
        return buf.toString();
    }

    public static ComponentBinder registerComponentBinder(Class componentClass, ComponentBinder binder) {
        if (binder != null) {
            return componentBinders.put(componentClass, binder);
        }
        return componentBinders.remove(componentClass);
    }

    static {
        MapBinder.registerComponentBinder(JSpinner.class, new ComponentBinder(){

            public Object getValue(Object comp) {
                return ((JSpinner)comp).getValue();
            }

            public void setValue(Object comp, Object value) {
                ((JSpinner)comp).setValue(new Integer(value.toString()));
            }
        });
        MapBinder.registerComponentBinder(Rectangle.class, new ComponentBinder(){

            public Object getValue(Object comp) {
                Rectangle r = (Rectangle)comp;
                return "x=" + r.x + " y=" + r.y + " width=" + r.width + " height=" + r.height;
            }

            public void setValue(Object comp, Object value) {
                try {
                    Properties props = AttributeTokenizer.getProperties(value.toString());
                    Rectangle r = (Rectangle)comp;
                    int x = Integer.parseInt(props.getProperty("x"));
                    int y = Integer.parseInt(props.getProperty("y"));
                    int width = Integer.parseInt(props.getProperty("width"));
                    int height = Integer.parseInt(props.getProperty("height"));
                    r.setBounds(x, y, width, height);
                }
                catch (ElementException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
    }

    public static interface ComponentBinder {
        public Object getValue(Object var1);

        public void setValue(Object var1, Object var2);
    }
}

