/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtil {
    public static String toHexString(String s) {
        byte[] bytes = null;
        try {
            StringBuilder sb = new StringBuilder();
            bytes = s.getBytes("UTF-8");
            for (int i = 0; i < bytes.length; ++i) {
                String hex = "0" + Integer.toHexString(bytes[i]);
                sb.append(hex.substring(hex.length() - 2, hex.length()));
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String fromHexString(String hex) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int i = 0; i < hex.length() - 1; i += 2) {
            out.write(Integer.parseInt(hex.substring(i, i + 2), 16));
        }
        try {
            return new String(out.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String mapToString(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        boolean firstEntry = true;
        for (Map.Entry<String, String> e : map.entrySet()) {
            if (!firstEntry) {
                sb.append(',');
            }
            sb.append(StringUtil.escape(e.getKey().toString()));
            sb.append('=');
            sb.append(StringUtil.escape(e.getValue().toString()));
            firstEntry = false;
        }
        return sb.toString();
    }

    public static LinkedHashMap<String, String> stringToMap(String s) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (s != null) {
            String[] pairs;
            for (String pair : pairs = StringUtil.split(s, ',')) {
                String[] nv = StringUtil.split(pair, '=');
                if (nv.length != 2) continue;
                map.put(StringUtil.unescape(nv[0]), StringUtil.unescape(nv[1]));
            }
        }
        return map;
    }

    public static String setToString(Set<String> set) {
        StringBuilder sb = new StringBuilder();
        boolean firstEntry = true;
        for (String s : set) {
            if (!firstEntry) {
                sb.append(", ");
            }
            sb.append(StringUtil.escape(s));
            firstEntry = false;
        }
        return sb.toString();
    }

    public static TreeSet<String> stringToSet(String s) {
        TreeSet<String> set = new TreeSet<String>();
        if (s != null) {
            String[] items;
            for (String item : items = StringUtil.split(s, ',')) {
                String value = StringUtil.unescape(item.trim());
                if (value.length() <= 0) continue;
                set.add(value);
            }
        }
        return set;
    }

    public static String stripTags(String s) {
        if (s == null) {
            return null;
        }
        return s.replaceAll("\\<[^>]*>", " ");
    }

    private static String escape(String s) {
        StringBuilder sb = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (c == ',' || c == '=' || c == '\\') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String unescape(String s) {
        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        for (char c : s.toCharArray()) {
            if (c == '\\' && !escaped) {
                escaped = true;
                continue;
            }
            sb.append(c);
            escaped = false;
        }
        return sb.toString();
    }

    private static String[] split(String s, char delim) {
        LinkedList<String> list = new LinkedList<String>();
        int last = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != delim || i <= 0 || s.charAt(i - 1) == '\\') continue;
            list.addLast(s.substring(last, i));
            last = i + 1;
        }
        list.addLast(s.substring(last, s.length()));
        return list.toArray(new String[list.size()]);
    }
}

