/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.jalbum.filterManager.FilterManager;
import net.jalbum.filterManager.FilterProperties;
import net.jalbum.filters.BasicFilter;
import net.jalbum.filters.BlurControl;
import se.datadosen.jalbum.Msg;

public class BlurFilterPlugin
extends BasicFilter {
    private static final long serialVersionUID = -2608721221010747854L;
    protected BlurControl blurControl;
    protected int strength = 5;
    protected int passes = 3;

    public BlurFilterPlugin() {
        this.name = Msg.getString((Object)this, (String)"filters.blur.name");
        this.shortName = Msg.getString((Object)this, (String)"filters.blur.shortName");
        this.icon = new ImageIcon(this.getClass().getResource("res/blur.png"));
        this.author = "Markus Persson";
        this.version = "1.0";
        this.category = FilterProperties.FilterCategory.OTHER;
        this.description = Msg.getString((Object)this, (String)"filters.blur.description");
        this.prescale = false;
        this.postscale = true;
        this.blurControl = new BlurControl(this);
    }

    public BufferedImage renderImage(BufferedImage bi) {
        Pixels pixels = new Pixels(bi, true);
        float r = (float)this.strength / 100.0f;
        r = r * r * r;
        for (int i = 0; i < this.passes; ++i) {
            pixels.boxBlur(r * 0.1f);
        }
        return pixels.getImage();
    }

    public JPanel getControls() {
        return this.blurControl;
    }

    public void setFilterManager(FilterManager filterManager) {
        this.filterManager = filterManager;
    }

    public int getStrength() {
        return this.strength;
    }

    public void setStrength(int radius) {
        this.strength = radius;
    }

    public void adjustStrength(int radius) {
        if (radius > 100) {
            radius = 100;
        } else if (radius < 0) {
            radius = 0;
        }
        this.strength = radius;
        this.renderImage();
    }

    private static class Pixels {
        private int width;
        private int height;
        private int[] pixels;
        private int[] newPixels;
        private BufferedImage img;

        public Pixels(BufferedImage in, boolean alwaysCopy) {
            this.width = in.getWidth();
            this.height = in.getHeight();
            this.newPixels = new int[this.width * this.height];
            DataBuffer db = in.getRaster().getDataBuffer();
            if (!(db instanceof DataBufferInt) || alwaysCopy) {
                this.img = new BufferedImage(this.width, this.height, 1);
                Graphics g = this.img.getGraphics();
                g.drawImage(in, 0, 0, null);
                g.dispose();
                db = this.img.getRaster().getDataBuffer();
            } else {
                this.img = in;
            }
            DataBufferInt dbi = (DataBufferInt)db;
            this.pixels = dbi.getData();
        }

        public BufferedImage getImage() {
            return this.img;
        }

        private void blurAlongXAndRotate(int radius) {
            int[] rSum = new int[this.width + 1];
            int[] gSum = new int[this.width + 1];
            int[] bSum = new int[this.width + 1];
            for (int y = 0; y < this.height; ++y) {
                int rAcc = 0;
                int gAcc = 0;
                int bAcc = 0;
                int x = 0;
                while (x < this.width) {
                    int col = this.pixels[y * this.width + x++];
                    rSum[x] = rAcc += col >> 16 & 0xFF;
                    gSum[x] = gAcc += col >> 8 & 0xFF;
                    bSum[x] = bAcc += col & 0xFF;
                }
                for (x = 0; x < this.width; ++x) {
                    int from = x - radius;
                    int to = x + radius + 1;
                    if (from < 0) {
                        from = 0;
                    }
                    if (to > this.width) {
                        to = this.width;
                    }
                    int len = to - from;
                    int r = (rSum[to] - rSum[from]) / len;
                    int g = (gSum[to] - gSum[from]) / len;
                    int b = (bSum[to] - bSum[from]) / len;
                    this.newPixels[x * this.height + y] = r << 16 | g << 8 | b;
                }
            }
            int[] tmp = this.pixels;
            this.pixels = this.newPixels;
            this.newPixels = tmp;
            int itmp = this.height;
            this.height = this.width;
            this.width = itmp;
        }

        public void boxBlur(float radius) {
            int size = this.width < this.height ? this.width : this.height;
            int r = (int)(radius * (float)size);
            this.blurAlongXAndRotate(r);
            this.blurAlongXAndRotate(r);
        }
    }
}

