/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import net.jalbum.filters.ColorAdjustmentFilterPlugin;
import net.jalbum.filters.FilterControl;
import net.jalbum.filters.components.ExtendedSlider;
import se.datadosen.jalbum.Msg;

public class ColorAdjustmentControl
extends FilterControl {
    private static final long serialVersionUID = 2472355637938881568L;
    protected ColorAdjustmentFilterPlugin colorAdjustmentFilterPlugin;
    protected ExtendedSlider sliderBrightness;
    protected ExtendedSlider sliderContrast;
    protected ExtendedSlider sliderSaturation;
    protected JCheckBox absoluteBrightness;
    protected JButton resetAll;

    public ColorAdjustmentControl() {
    }

    public ColorAdjustmentControl(ColorAdjustmentFilterPlugin colorAdjustmentFilterPlugin) {
        this.init(colorAdjustmentFilterPlugin);
        this.addColorAdjustmentControls();
    }

    protected void addColorAdjustmentControls() {
        this.sliderBrightness = new ExtendedSlider(-100, 100, 0);
        this.sliderBrightness.getSlider().setPaintLabels(false);
        this.sliderBrightness.setSliderWidth(132);
        this.sliderBrightness.removeResetButton();
        this.sliderBrightness.addActionListener(this);
        this.absoluteBrightness = new JCheckBox();
        this.absoluteBrightness.addActionListener(this);
        this.sliderContrast = new ExtendedSlider(-100, 100, 0);
        this.sliderContrast.getSlider().setPaintLabels(false);
        this.sliderContrast.setSliderWidth(132);
        this.sliderContrast.removeResetButton();
        this.sliderContrast.addActionListener(this);
        this.sliderSaturation = new ExtendedSlider(-100, 100, 0);
        this.sliderSaturation.getSlider().setPaintLabels(false);
        this.sliderSaturation.setSliderWidth(132);
        this.sliderSaturation.removeResetButton();
        this.sliderSaturation.addActionListener(this);
        this.resetAll = new JButton(Msg.getString((Object)this, (String)"filters.colorAdjustment.resetAll"));
        this.resetAll.addActionListener(this);
        this.add(new JLabel(Msg.getString((Object)this, (String)"filters.colorAdjustment.brightness")));
        this.add("br", this.sliderBrightness);
        this.add("p", new JLabel(Msg.getString((Object)this, (String)"filters.colorAdjustment.contrast")));
        this.add("br", this.sliderContrast);
        this.add("p", new JLabel(Msg.getString((Object)this, (String)"filters.colorAdjustment.saturation")));
        this.add("br", this.sliderSaturation);
        this.add("br", this.resetAll);
    }

    protected void init(ColorAdjustmentFilterPlugin colorAdjustmentFilterPlugin) {
        this.colorAdjustmentFilterPlugin = colorAdjustmentFilterPlugin;
        super.init(colorAdjustmentFilterPlugin);
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.sliderContrast) {
            if ((double)this.sliderContrast.getValue() != this.colorAdjustmentFilterPlugin.getContrast()) {
                this.colorAdjustmentFilterPlugin.adjustContrast(this.sliderContrast.getValue());
            }
        } else if (e.getSource() == this.sliderSaturation) {
            if ((double)this.sliderSaturation.getValue() != this.colorAdjustmentFilterPlugin.getSaturation()) {
                this.colorAdjustmentFilterPlugin.adjustSaturation(this.sliderSaturation.getValue());
            }
        } else if (e.getSource() == this.sliderBrightness) {
            if ((double)this.sliderBrightness.getValue() != this.colorAdjustmentFilterPlugin.getBrightness()) {
                this.colorAdjustmentFilterPlugin.adjustBrightness(this.sliderBrightness.getValue());
            }
        } else if (e.getSource() == this.absoluteBrightness) {
            this.colorAdjustmentFilterPlugin.setAbsoluteBrightness(this.absoluteBrightness.isSelected());
            this.colorAdjustmentFilterPlugin.adjustBrightness(this.sliderBrightness.getValue());
        } else if (e.getSource() == this.resetAll) {
            this.sliderContrast.reset();
            this.sliderSaturation.reset();
            this.sliderBrightness.reset();
        }
    }
}

