/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.jcamerainfo;

import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifDescriptor;
import com.drew.metadata.exif.ExifDirectory;
import com.drew.metadata.exif.NikonType2MakernoteDirectory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.SystemColor;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import se.datadosen.imaging.exif.ImageInfoFormatter;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.EditListener;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.PluginContext;

public class JCameraInfoPanel
extends JPanel
implements EditListener {
    private AlbumObject ao;
    private JTextArea content = new JTextArea();
    private DecimalFormat twoDec = new DecimalFormat("0.##");
    private ImageInfoFormatter formatter = new ImageInfoFormatter();
    private PluginContext context;
    private boolean showing = false;

    public JCameraInfoPanel(PluginContext context) {
        this.context = context;
        this.init();
    }

    public String toString() {
        if (this.ao == null) {
            return "";
        }
        Metadata meta = this.ao.getMetadata().getMetadata();
        this.formatter.setMetadata(meta);
        StringBuilder buf = new StringBuilder();
        buf.append(this.ao.getName() + "\n");
        if (meta != null && meta.containsDirectory(ExifDirectory.class)) {
            Directory dir = meta.getDirectory(ExifDirectory.class);
            if (!dir.containsTag(272)) {
                return buf.toString();
            }
            ExifDescriptor desc = new ExifDescriptor(dir);
            try {
                buf.append(dir.getDescription(36867) + "\n");
                buf.append(desc.getDescription(271) + " - " + desc.getDescription(272) + "\n");
                Directory nikon = null;
                if (meta.containsDirectory(NikonType2MakernoteDirectory.class)) {
                    nikon = meta.getDirectory(NikonType2MakernoteDirectory.class);
                }
                if (nikon != null) {
                    buf.append(nikon.getDescription(132) + "\n");
                }
                if (dir.containsTag(40962)) {
                    buf.append("(" + dir.getInt(40962) + " x " + dir.getInt(40963) + ") - " + this.twoDec.format((float)this.ao.getFile().length() / 1024.0f / 1024.0f) + " MB \n");
                }
                buf.append(desc.getFocalLengthDescription());
                String focalLength35mm = (String)this.formatter.format(41989);
                if (focalLength35mm != null) {
                    buf.append(" (\u223c" + focalLength35mm + ")");
                }
                buf.append('\n');
                buf.append(desc.getExposureModeDescription() + " (" + "ISO " + desc.getIsoEquivalentDescription() + ")\n");
                buf.append(desc.getExposureTimeDescription() + " - " + desc.getFNumberDescription() + "\n");
                buf.append(desc.getExposureBiasDescription() + " - " + dir.getDescription(41987));
                if (nikon != null) {
                    buf.append("(" + nikon.getDescription(5) + ")");
                }
            }
            catch (MetadataException ex) {
                System.err.println((Object)ex);
                return "Error extracting metadata";
            }
        }
        return buf.toString();
    }

    public void setAlbumObject(AlbumObject ao) {
        this.ao = ao;
        if (ao == null || ao.isFolder() && this.showing) {
            this.context.getEditPanel().removeCustomTab((JComponent)this);
            this.showing = false;
            return;
        }
        if (!ao.isFolder() && !this.showing) {
            this.context.getEditPanel().addCustomTab(Msg.get((String)"edit.camera"), (JComponent)this);
            this.showing = true;
        }
        this.content.setText(this.toString());
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.content.setOpaque(false);
        this.content.setFont(new JTextField().getFont());
        this.content.setForeground(SystemColor.darkGray);
        this.setBackground(SystemColor.text);
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.content.setFont(this.content.getFont().deriveFont(11.0f));
        this.content.setEditable(false);
        this.content.setToolTipText("<html>File name<br>Original date<br>Camera make - model<br>Lens type (if available)<br>(Pixel size) - Disk size<br>Focal length (35mm equivalent)<br>Exposure mode (ISO equivalent)<br>Exposure time - FNumber<br>Exposure bias - W. bal. mode (Temp)</html>");
        this.add((Component)this.content, "Center");
        this.validate();
    }
}

