/*
 * Decompiled with CFR 0.152.
 */
package module.aolim.ui;

import component.IcbmCore;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import main.Oscar;
import module.aolim.ui.ImAttribute;
import module.aolim.ui.UiBean;
import uiutil.ACheckbox;
import uiutil.ChangeListener;
import uiutil.ChoiceUI;
import uiutil.PropertySheet;
import uiutil.Spacer;
import uiutil.TransparentPanel;
import util.KeyBindings;

public class ImProps
extends PropertySheet
implements ChangeListener,
ItemListener {
    private static final String MODULE = "ImProps";
    private UiBean uibean;
    private ChangeListener changeListener;
    private boolean changed = false;
    private ACheckbox playReceiveSound;
    private ACheckbox playSendSound;
    private ACheckbox playRingSound;
    private ACheckbox enterCheck;
    private ACheckbox timeStampCheck;
    private ImAttribute attribute;

    public ImProps(UiBean uiBean, ChangeListener changeListener) {
        this.uibean = uiBean;
        this.attribute = uiBean.getImAttribute();
        this.changeListener = changeListener;
        ((Component)((Object)this)).setBackground(Oscar.backgroundColor);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).add("North", (Component)new Spacer());
        ((Container)((Object)this)).add("West", (Component)new Spacer());
        TransparentPanel transparentPanel = new TransparentPanel();
        ((Container)((Object)this)).add("Center", (Component)transparentPanel);
        transparentPanel.setLayout(new BorderLayout());
        transparentPanel.add("North", new Label("Set the following sound options: "));
        TransparentPanel transparentPanel2 = new TransparentPanel((LayoutManager)new GridLayout(8, 1));
        transparentPanel.add("Center", (Component)transparentPanel2);
        this.playReceiveSound = new ACheckbox("Play a sound when you get message.");
        transparentPanel2.add((Component)this.playReceiveSound);
        this.playReceiveSound.addItemListener((ItemListener)this);
        this.playSendSound = new ACheckbox("Play a sound when you send message.");
        transparentPanel2.add((Component)this.playSendSound);
        this.playSendSound.addItemListener((ItemListener)this);
        this.playRingSound = new ACheckbox("Play a special sound on first message.");
        transparentPanel2.add((Component)this.playRingSound);
        this.playRingSound.addItemListener((ItemListener)this);
        transparentPanel2.add(new Label("   "));
        transparentPanel2.add(new Label("Set other options: "));
        this.enterCheck = new ACheckbox("Enter key inserts Return");
        transparentPanel2.add((Component)this.enterCheck);
        this.enterCheck.addItemListener((ItemListener)this);
        this.timeStampCheck = new ACheckbox("Display time stamps");
        transparentPanel2.add((Component)this.timeStampCheck);
        this.timeStampCheck.addItemListener((ItemListener)this);
        this.setValues();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.setChanged(true);
    }

    public boolean changed() {
        return this.changed;
    }

    public boolean help() {
        ChoiceUI.newChoiceUI((String)"Im Setup Help", (String)"Click on a sound option check box to toggle sound play on a particular message event. Other check boxes allow you to change the function of the Enter (Return) key in an IM box or to toggle the display of time in each IM message.The Enter key can be set to automatically send the IM, or to insert a Return in the text.  Control-Enter will always do the opposite of Enter. It is also possible for a time stamp to be shown so the time an IM was received is known.");
        return true;
    }

    public void removeNotify() {
        ((Container)((Object)this)).removeAll();
        this.uibean = null;
        this.changeListener = null;
        this.attribute = null;
        this.playReceiveSound = null;
        this.playSendSound = null;
        this.playRingSound = null;
        this.timeStampCheck = null;
        this.enterCheck = null;
        super.removeNotify();
    }

    public boolean save() {
        KeyBindings keyBindings = Oscar.config.getKeyBindingsOrAdd(IcbmCore.IM_KEY);
        keyBindings.setValue(IcbmCore.SEND_SOUND_KEY, String.valueOf(this.playSendSound.getState()));
        keyBindings.setValue(IcbmCore.RECEIVE_SOUND_KEY, String.valueOf(this.playReceiveSound.getState()));
        keyBindings.setValue(IcbmCore.RING_SOUND_KEY, String.valueOf(this.playRingSound.getState()));
        keyBindings.setValue(IcbmCore.TIMESTAMP_KEY, String.valueOf(this.timeStampCheck.getState()));
        keyBindings.setValue(IcbmCore.ENTER_KEY, String.valueOf(this.enterCheck.getState()));
        this.attribute.setSoundAttribute(this.playSendSound.getState(), this.playReceiveSound.getState(), this.playRingSound.getState());
        this.attribute.viewTimeStamps = this.timeStampCheck.getState();
        this.attribute.enterKeyInserts = this.enterCheck.getState();
        this.uibean.attributeChanged();
        this.setChanged(false);
        return true;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
        if (bl) {
            this.changeListener.setChanged(true);
        }
    }

    public void setValues() {
        this.playSendSound.setState(this.attribute.playSendSound);
        this.playReceiveSound.setState(this.attribute.playReceiveSound);
        this.playRingSound.setState(this.attribute.playRingSound);
        this.timeStampCheck.setState(this.attribute.viewTimeStamps);
        this.enterCheck.setState(this.attribute.enterKeyInserts);
        this.setChanged(false);
    }
}

