/*
 * Decompiled with CFR 0.152.
 */
package module.aolim.ui;

import component.OscarLabelButton;
import component.Tool;
import component.Tools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import main.Oscar;
import module.aolim.ui.ImAttribute;
import module.aolim.ui.UiBean;
import module.aolim.ui.ZapUI;
import tool.RateEvent;
import tool.RateListener;
import uiutil.AolRtfArea;
import uiutil.AolRtfListener;
import uiutil.ColorSelector;
import uiutil.ColorSelectorListener;
import uiutil.ErrorMgr;
import uiutil.IUtil;
import uiutil.ImageButton;
import uiutil.ImageLabel;
import uiutil.ImagePanel;
import uiutil.LedBar;
import uiutil.OFrame;
import uiutil.Spacer;
import uiutil.TransparentPanel;
import uiutil.UIPack;
import util.Log;

public class ImUI
extends OFrame
implements AolRtfListener,
ColorSelectorListener,
RateListener,
ActionListener {
    private static String MODULE = "ImUI";
    protected static final int START = 0;
    protected static final int INITIATE = 1;
    protected static final int RECEIVE = 2;
    protected static final int INTERACTIVE = 3;
    public static final int OUTGOING = -1;
    public static final int SYSTEM = 0;
    public static final int INCOMMING = 1;
    private UiBean uibean;
    private TextField nicknameField;
    private String nickname;
    private AolRtfArea inputArea;
    private AolRtfArea dialogArea;
    private ImagePanel main;
    private TransparentPanel center;
    private TransparentPanel upper;
    private ImagePanel lower;
    private OscarLabelButton sendButton;
    private OscarLabelButton cancelButton;
    private ImageButton locateButton;
    private ImageButton foregroundButton;
    private ImageButton backgroundButton;
    private ImageButton smallerButton;
    private ImageButton normalButton;
    private ImageButton largerButton;
    private ImageButton boldButton;
    private ImageButton italicsButton;
    private ImageButton underlineButton;
    private ImageButton zapButton;
    private ZapUI zapUI;
    private LedBar rateIndicator = new LedBar();
    private Image tile;
    private int mode;
    private boolean disabled = false;
    private int height;
    private ImAttribute attribute;
    private String localNameColor;
    private String remoteNameColor;
    private int htmlSize = 1;
    DateFormat timeFormat = DateFormat.getTimeInstance(3);

    public ImUI(UiBean uiBean) {
        ((Component)((Object)this)).setBackground(Oscar.backgroundColor);
        this.uibean = uiBean;
        this.mode = 0;
        ((Frame)((Object)this)).setTitle("IM");
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.main = new ImagePanel();
        ((Container)((Object)this)).add("Center", (Component)this.main);
        this.tile = Oscar.images.getImage((UIPack)uiBean, Oscar.BG_TILE, (Component)this.main, true);
        this.main.setLayout(new BorderLayout());
        this.main.setTile(this.tile);
        this.attribute = uiBean.getImAttribute();
        this.effectAttributeChange();
        this.timeFormat.setTimeZone(TimeZone.getDefault());
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = this.disabled = !bl;
        if (this.sendButton != null) {
            this.sendButton.setEnabled(bl);
        }
        if (this.zapButton != null) {
            this.zapButton.setEnabled(bl);
        }
        if (this.zapUI != null) {
            this.zapUI.setEnabled(bl);
        }
        if (this.locateButton != null) {
            this.locateButton.setEnabled(bl);
        }
        if (this.disabled) {
            ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(3));
            return;
        }
        ((Component)((Object)this)).setCursor(Cursor.getDefaultCursor());
    }

    public void setImAttribute(ImAttribute imAttribute) {
        this.attribute = imAttribute;
        this.effectAttributeChange();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.zapButton) {
            this.zapButtonAction();
            return;
        }
        if (object == this.sendButton) {
            this.sendButtonAction();
            return;
        }
        if (object == this.cancelButton) {
            this.dispose();
            return;
        }
        if (object == this.locateButton) {
            this.locateButtonAction();
            return;
        }
        if (object == this.nicknameField) {
            this.nicknameField.transferFocus();
            return;
        }
        if (object == this.foregroundButton) {
            new ColorSelector((ColorSelectorListener)this, "Set the forground color", Color.black, Color.white, true);
            return;
        }
        if (object == this.backgroundButton) {
            new ColorSelector((ColorSelectorListener)this, "Set the background color", Color.black, Color.white, false);
            return;
        }
        if (object == this.smallerButton) {
            this.inputArea.shrinkFont();
            return;
        }
        if (object == this.normalButton) {
            this.inputArea.resetFontSize();
            return;
        }
        if (object == this.largerButton) {
            this.inputArea.enlargeFont();
            return;
        }
        if (object == this.boldButton) {
            if (this.boldButton.isDown()) {
                this.inputArea.setStyle('b', true);
                return;
            }
            this.inputArea.setStyle('b', false);
            return;
        }
        if (object == this.italicsButton) {
            if (this.italicsButton.isDown()) {
                this.inputArea.setStyle('i', true);
                return;
            }
            this.inputArea.setStyle('i', false);
            return;
        }
        if (object == this.underlineButton) {
            if (this.underlineButton.isDown()) {
                this.inputArea.setStyle('u', true);
                return;
            }
            this.inputArea.setStyle('u', false);
        }
    }

    private final void effectAttributeChange() {
        this.localNameColor = IUtil.getStringFromColor((Color)this.attribute.myNameColor);
        this.remoteNameColor = IUtil.getStringFromColor((Color)this.attribute.otherNameColor);
        this.htmlSize = this.attribute.fontSize < 14 ? this.attribute.fontSize / 8 + this.attribute.fontSize % 8 / 2 : (this.attribute.fontSize >= 14 && this.attribute.fontSize < 20 ? 4 : 5);
        this.alterAolRtfAreas();
    }

    private final void alterAolRtfAreas() {
        if (this.dialogArea != null) {
            this.dialogArea.setWindowColor(this.attribute.windowColor);
        }
        AolRtfArea.setDefaultFont((String)this.attribute.fontName, (int)this.attribute.fontSize);
        AolRtfArea.setDefaultColor((Color)this.attribute.textFgColor, (Color)this.attribute.textBgColor);
        if (this.inputArea != null) {
            this.inputArea.setWindowColor(this.attribute.windowColor);
            if (this.attribute.fontStyle == 1) {
                this.inputArea.setStyle('b', true);
                return;
            }
            if (this.attribute.fontStyle == 2) {
                this.inputArea.setStyle('i', true);
                return;
            }
            if (this.attribute.fontStyle == 3) {
                this.inputArea.setStyle('b', true);
                this.inputArea.setStyle('i', true);
                return;
            }
            this.inputArea.setStyle('b', false);
            this.inputArea.setStyle('i', false);
        }
    }

    public void addMessage(String string, String string2, int n) {
        String string3 = "#0000FF";
        if (n == 1) {
            if (this.attribute.playReceiveSound) {
                IUtil.playSound((UIPack)this.uibean, (String)"Receive");
            }
            string3 = this.remoteNameColor;
        } else if (n == -1) {
            if (this.attribute.playSendSound) {
                IUtil.playSound((UIPack)this.uibean, (String)"Send");
            }
            string3 = this.localNameColor;
        } else if (n == 0) {
            if (this.attribute.playReceiveSound) {
                IUtil.playSound((UIPack)this.uibean, (String)"Receive");
            }
            string3 = "#00FF00";
        }
        String string4 = "";
        if (this.attribute.viewTimeStamps) {
            string4 = " (" + this.timeFormat.format(new Date()) + ")";
        }
        String string5 = "";
        String string6 = "";
        if (this.attribute.fontStyle == 1) {
            string5 = "<B>";
            string6 = "</B>";
        } else if (this.attribute.fontStyle == 2) {
            string5 = "<I>";
            string6 = "</I>";
        } else if (this.attribute.fontStyle == 3) {
            string5 = "<B><I>";
            string6 = "</B></I>";
        }
        this.dialogArea.appendHTML("<FONT COLOR=\"" + string3 + "\" SIZE=" + this.htmlSize + ">" + string5 + string + string4 + string6 + ":   </FONT>" + string2 + "<BR>");
    }

    private String bedeck(String string, String string2, String string3, String string4) {
        if (string2 == null) {
            return string;
        }
        if (string.indexOf("<B>") >= 0 || string.indexOf("<I>") >= 0 || string.indexOf("<U>") >= 0) {
            return string;
        }
        String string5 = "";
        int n = string.indexOf(string2);
        if (n < 0) {
            return string;
        }
        int n2 = n + string2.length();
        string5 = String.valueOf(string.substring(0, n)) + string3 + string2 + string4 + string.substring(n2, string.length());
        return string5;
    }

    public TransparentPanel createActionPanel() {
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new FlowLayout(1, 5, 0));
        this.locateButton = OscarLabelButton.makeImageButton((UIPack)this.uibean, (Component)transparentPanel, (String)"Info");
        transparentPanel.add((Component)this.locateButton);
        this.locateButton.addActionListener((ActionListener)this);
        this.zapButton = OscarLabelButton.makeImageButton((UIPack)this.uibean, (Component)transparentPanel, (String)"Zap");
        transparentPanel.add((Component)this.zapButton);
        this.zapButton.addActionListener((ActionListener)this);
        return transparentPanel;
    }

    public TransparentPanel createControlPanel() {
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new FlowLayout(0, 5, 5));
        this.foregroundButton = OscarLabelButton.makeImageButton((UIPack)this.uibean, (Component)transparentPanel, (String)"Fg");
        transparentPanel.add((Component)this.foregroundButton);
        this.foregroundButton.setFocusTraversable(false);
        this.foregroundButton.addActionListener((ActionListener)this);
        this.backgroundButton = OscarLabelButton.makeImageButton((UIPack)this.uibean, (Component)transparentPanel, (String)"Bg");
        transparentPanel.add((Component)this.backgroundButton);
        this.backgroundButton.setFocusTraversable(false);
        this.backgroundButton.addActionListener((ActionListener)this);
        transparentPanel.add((Component)new Spacer());
        this.smallerButton = OscarLabelButton.makeImageButton((UIPack)this.uibean, (Component)transparentPanel, (String)"Small");
        transparentPanel.add((Component)this.smallerButton);
        this.smallerButton.setFocusTraversable(false);
        this.smallerButton.addActionListener((ActionListener)this);
        this.normalButton = OscarLabelButton.makeImageButton((UIPack)this.uibean, (Component)transparentPanel, (String)"Normal");
        transparentPanel.add((Component)this.normalButton);
        this.normalButton.setFocusTraversable(false);
        this.normalButton.addActionListener((ActionListener)this);
        this.largerButton = OscarLabelButton.makeImageButton((UIPack)this.uibean, (Component)transparentPanel, (String)"Big");
        transparentPanel.add((Component)this.largerButton);
        this.largerButton.setFocusTraversable(false);
        this.largerButton.addActionListener((ActionListener)this);
        transparentPanel.add((Component)new Spacer());
        this.boldButton = OscarLabelButton.makeImageButton((UIPack)this.uibean, (Component)transparentPanel, (String)"Bold");
        transparentPanel.add((Component)this.boldButton);
        this.boldButton.setFocusTraversable(false);
        this.boldButton.addActionListener((ActionListener)this);
        this.boldButton.setSticky(true);
        this.italicsButton = OscarLabelButton.makeImageButton((UIPack)this.uibean, (Component)transparentPanel, (String)"Italic");
        transparentPanel.add((Component)this.italicsButton);
        this.italicsButton.setFocusTraversable(false);
        this.italicsButton.setSticky(true);
        this.italicsButton.addActionListener((ActionListener)this);
        this.underlineButton = OscarLabelButton.makeImageButton((UIPack)this.uibean, (Component)transparentPanel, (String)"Under");
        transparentPanel.add((Component)this.underlineButton);
        this.underlineButton.setFocusTraversable(false);
        this.underlineButton.setSticky(true);
        this.underlineButton.addActionListener((ActionListener)this);
        return transparentPanel;
    }

    public void dispose() {
        ((Component)((Object)this)).setVisible(false);
        if (this.mode == 1) {
            this.uibean.removeUI(this, UiBean.INITIATE);
        } else {
            this.uibean.removeUI(this, UiBean.INTERACTIVE);
        }
        super.dispose();
    }

    public String getNickname() {
        return this.nickname;
    }

    public void initiate(String string) {
        Log.log((String)MODULE, (int)Log.DB2, (String)("ImUI::initiate(" + string + ")"));
        if (this.mode == 0) {
            this.center = new TransparentPanel();
            this.main.add("Center", (Component)this.center);
            this.center.setLayout(new BorderLayout());
            TransparentPanel transparentPanel = new TransparentPanel();
            this.center.add("North", (Component)transparentPanel);
            transparentPanel.setLayout(new BorderLayout());
            TransparentPanel transparentPanel2 = new TransparentPanel();
            transparentPanel.add("North", (Component)transparentPanel2);
            transparentPanel2.setLayout(new FlowLayout(0));
            transparentPanel2.add((Component)new ImageLabel("To:", 2));
            this.nickname = string;
            if (string == null) {
                string = "";
            }
            this.nicknameField = new TextField(string, 16);
            transparentPanel2.add(this.nicknameField);
            this.nicknameField.addActionListener(this);
            transparentPanel.add("South", (Component)this.createControlPanel());
            this.inputArea = new AolRtfArea("InputArea", (AolRtfListener)this, true, true, 10, this.attribute.enterKeyInserts ? 2 : 0);
            this.center.add("Center", (Component)this.inputArea);
            this.inputArea.setWindowColor(this.attribute.windowColor);
            ImagePanel imagePanel = new ImagePanel();
            this.center.add("South", (Component)imagePanel);
            imagePanel.setTile(this.tile);
            imagePanel.setLayout(new BorderLayout());
            imagePanel.add("North", (Component)this.rateIndicator);
            this.rateIndicator.setSize(170, 22);
            transparentPanel = new TransparentPanel((LayoutManager)new BorderLayout());
            imagePanel.add("South", (Component)transparentPanel);
            transparentPanel2 = new TransparentPanel((LayoutManager)new FlowLayout(1, 5, 0));
            this.locateButton = OscarLabelButton.makeImageButton((UIPack)this.uibean, (Component)transparentPanel2, (String)"Info");
            transparentPanel2.add((Component)this.locateButton);
            transparentPanel.add("West", (Component)transparentPanel2);
            this.locateButton.addActionListener((ActionListener)this);
            transparentPanel2 = new TransparentPanel((LayoutManager)new FlowLayout(2));
            this.sendButton = new OscarLabelButton("Send", (UIPack)this.uibean, (Component)transparentPanel2);
            transparentPanel2.add((Component)this.sendButton);
            this.sendButton.addActionListener((ActionListener)this);
            this.cancelButton = new OscarLabelButton("Cancel", (UIPack)this.uibean, (Component)transparentPanel2);
            transparentPanel2.add((Component)this.cancelButton);
            this.cancelButton.addActionListener((ActionListener)this);
            transparentPanel.add("East", (Component)transparentPanel2);
            this.mode = 1;
            ((Window)((Object)this)).pack();
        }
        ((Component)((Object)this)).setVisible(true);
        if (this.nicknameField != null && string != null && string.length() > 0) {
            this.nicknameField.transferFocus();
        }
    }

    private void locateButtonAction() {
        Tool tool = Tools.getTool((String)"Locate");
        if (tool == null) {
            ErrorMgr.warn((String)MODULE, (String)"The Info service is currently unavailable.");
            return;
        }
        Vector<String> vector = new Vector<String>();
        String string = this.nicknameField == null ? "" : this.nicknameField.getText();
        if ((string = Oscar.makeValidNickname((String)string)) == null || string.length() < 1) {
            string = this.nickname;
        }
        if (string == null || string.equals("")) {
            ErrorMgr.warn((String)"icbm", (String)"Please enter a valid nickname.");
            return;
        }
        vector.addElement(string);
        tool.initiate(vector, null);
    }

    public Dimension getPreferredSize() {
        if (this.mode == 1) {
            return new Dimension(300, 200);
        }
        if (this.mode == 2) {
            return new Dimension(300, 200);
        }
        return new Dimension(300, 300);
    }

    private void makeReceiveWindow(String string, String string2) {
        ((Frame)((Object)this)).setTitle("IM From: " + string);
        this.nickname = string;
        this.center = new TransparentPanel();
        this.main.add("Center", (Component)this.center);
        this.center.setLayout(new BorderLayout());
        this.upper = new TransparentPanel();
        this.center.add("Center", (Component)this.upper);
        this.upper.setLayout(new BorderLayout());
        this.dialogArea = new AolRtfArea("DialogArea", null, true, false, -1, 0);
        this.dialogArea.setWindowColor(this.attribute.windowColor);
        this.addMessage(string, string2, 1);
        this.upper.add("Center", (Component)this.dialogArea);
        this.lower = new ImagePanel();
        this.center.add("South", (Component)this.lower);
        this.lower.setTile(this.tile);
        this.lower.setLayout(new BorderLayout(5, 0));
        this.lower.add("South", (Component)this.rateIndicator);
        this.rateIndicator.setSize(170, 22);
        TransparentPanel transparentPanel = new TransparentPanel();
        this.main.add("South", (Component)transparentPanel);
        transparentPanel.setLayout(new BorderLayout(5, 0));
        transparentPanel.add("West", (Component)this.createActionPanel());
        TransparentPanel transparentPanel2 = new TransparentPanel();
        transparentPanel.add("East", (Component)transparentPanel2);
        this.sendButton = new OscarLabelButton("Respond", (UIPack)this.uibean, (Component)transparentPanel2);
        transparentPanel2.add((Component)this.sendButton);
        this.sendButton.addActionListener((ActionListener)this);
        this.cancelButton = new OscarLabelButton("Cancel", (UIPack)this.uibean, (Component)transparentPanel2);
        transparentPanel2.add((Component)this.cancelButton);
        this.cancelButton.addActionListener((ActionListener)this);
        this.mode = 2;
        ((Window)((Object)this)).pack();
        this.height = ((Component)((Object)this)).getSize().height;
    }

    private void makeInteractiveWindow() {
        int n = ((Component)((Object)this)).getSize().height;
        this.upper.add("South", (Component)this.createControlPanel());
        this.inputArea = new AolRtfArea("InputArea", (AolRtfListener)this, true, true, 10, this.attribute.enterKeyInserts ? 2 : 0);
        this.inputArea.setWindowColor(this.attribute.windowColor);
        this.lower.add("Center", (Component)this.inputArea);
        this.sendButton.changeButton("Send", (UIPack)this.uibean, (Component)this.lower);
        this.center.setLayout(new GridLayout(0, 1));
        this.mode = 3;
        if (n <= this.height) {
            ((Window)((Object)this)).pack();
            return;
        }
        ((Container)((Object)this)).invalidate();
        ((Container)((Object)this)).validate();
    }

    public void receive(String string, String string2, int n) {
        if (this.mode == 0) {
            this.makeReceiveWindow(string, string2);
            ((Component)((Object)this)).setVisible(true);
            return;
        }
        if (this.mode != 2 && this.mode != 3) {
            ErrorMgr.diag((String)MODULE, (int)3, (String)("Invalid mode " + this.mode + " during receive."));
            return;
        }
        this.addMessage(string, string2, n);
    }

    private void sendButtonAction() {
        String string = "";
        String string2 = "";
        if (this.attribute.fontStyle == 1) {
            string = "<B>";
            string2 = "</B>";
        } else if (this.attribute.fontStyle == 2) {
            string = "<I>";
            string2 = "</I>";
        } else if (this.attribute.fontStyle == 3) {
            string = "<B><I>";
            string2 = "</B></I>";
        }
        switch (this.mode) {
            case 1: {
                if (this.inputArea.isEmpty()) {
                    ErrorMgr.warn((String)"icbm", (String)"Please enter a message to send.");
                    return;
                }
                String string3 = this.inputArea.getTextAsHTML();
                String string4 = this.inputArea.getText();
                String string5 = this.nicknameField.getText();
                if ((string5 = Oscar.makeValidNickname((String)string5)) == null || string5.equals("")) {
                    ErrorMgr.warn((String)"icbm", (String)"Please enter a valid nickname.");
                    return;
                }
                if (this.attribute.playSendSound) {
                    IUtil.playSound((UIPack)this.uibean, (String)"Send");
                }
                String string6 = this.bedeck(string3, string4, string, string2);
                this.uibean.sendMessage(string5, string6);
                this.dispose();
                return;
            }
            case 2: {
                this.makeInteractiveWindow();
                return;
            }
            case 3: {
                if (this.inputArea.isEmpty()) {
                    ErrorMgr.warn((String)"icbm", (String)"Please enter a message to send.");
                    return;
                }
                String string7 = this.inputArea.getTextAsHTML();
                String string8 = this.inputArea.getText();
                this.inputArea.setHTML("");
                String string9 = this.bedeck(string7, string8, string, string2);
                this.uibean.sendMessage(this.nickname, string9);
                return;
            }
        }
        ErrorMgr.diag((String)MODULE, (int)3, (String)("Unknown mode " + this.mode));
    }

    public void sendKeyPressed() {
        if (this.discardingKeyEvents) {
            return;
        }
        this.sendButtonAction();
    }

    public void setColor(Object object, boolean bl, Color color) {
        if (this.inputArea != null) {
            if (bl) {
                this.inputArea.setFG(color);
                return;
            }
            this.inputArea.setBG(color);
        }
    }

    public void styleUpdate() {
        if (this.inputArea.selectionIsInStyle('u')) {
            this.underlineButton.setPushed();
        } else {
            this.underlineButton.setNormal();
        }
        if (this.inputArea.selectionIsInStyle('i')) {
            this.italicsButton.setPushed();
        } else {
            this.italicsButton.setNormal();
        }
        if (this.inputArea.selectionIsInStyle('b')) {
            this.boldButton.setPushed();
            return;
        }
        this.boldButton.setNormal();
    }

    public void setRate(RateEvent rateEvent) {
        if (this.rateIndicator != null) {
            if (rateEvent.isLimited()) {
                this.rateIndicator.setLimits(rateEvent.getDisconnect(), rateEvent.getClear(), rateEvent.getClear(), rateEvent.getMaxAve());
            } else {
                this.rateIndicator.setLimits(rateEvent.getDisconnect(), rateEvent.getLimit(), rateEvent.getAlert(), rateEvent.getMaxAve());
            }
            this.rateIndicator.setValue(rateEvent.getRate());
        }
    }

    public void zapRemove() {
        this.zapUI = null;
    }

    public void zapButtonAction() {
        if (this.zapUI == null) {
            this.zapUI = new ZapUI(this.uibean, this, this.nickname);
            return;
        }
        this.zapUI.toFront();
    }
}

