/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.OscarLabelButton;
import component.StatusFrame;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import uiutil.MultiLineLabel;
import uiutil.TransparentPanel;

public abstract class AdminUI
extends StatusFrame
implements ActionListener {
    private TransparentPanel dataPanel = new TransparentPanel(new BorderLayout());
    private OscarLabelButton okButton;
    private OscarLabelButton cancelButton;
    private OscarLabelButton applyButton;
    private boolean changed;

    public AdminUI(String string, String string2) {
        super("Change " + string);
        this.dataPanel.add("North", new MultiLineLabel(string2));
        TransparentPanel transparentPanel = new TransparentPanel(new BorderLayout());
        this.dataPanel.add("South", transparentPanel);
        TransparentPanel transparentPanel2 = new TransparentPanel();
        transparentPanel.add("North", transparentPanel2);
        this.okButton = new OscarLabelButton("OK", this, transparentPanel2);
        transparentPanel2.add(this.okButton);
        this.okButton.addActionListener(this);
        this.cancelButton = new OscarLabelButton("Cancel", this, transparentPanel2);
        transparentPanel2.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        this.applyButton = new OscarLabelButton("Apply", this, transparentPanel2);
        transparentPanel2.add(this.applyButton);
        this.applyButton.addActionListener(this);
        this.setChanged(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.okButton)) {
            if (this.getStatus() != StatusFrame.STATUS_WAITING) {
                if (this.changed) {
                    this.requestChange(true);
                    return;
                }
                super.dispose();
                return;
            }
        } else {
            if (object.equals(this.cancelButton)) {
                super.dispose();
                return;
            }
            if (object.equals(this.applyButton) && this.changed && this.getStatus() != StatusFrame.STATUS_WAITING) {
                this.requestChange(false);
            }
        }
    }

    public String getDisplayName() {
        return "Administration UI";
    }

    public String getName() {
        return "AdminUI";
    }

    public abstract void requestChange(boolean var1);

    public void removeNotify() {
        this.removeAll();
        this.okButton = null;
        this.cancelButton = null;
        this.applyButton = null;
        this.setLayout(null);
        super.removeNotify();
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
        this.applyButton.setEnabled(bl);
    }

    public void setContents(TransparentPanel transparentPanel) {
        this.dataPanel.add("Center", transparentPanel);
        super.setContents(this.dataPanel);
    }
}

