/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.LocateCore;
import component.OscarLabelButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import main.Oscar;
import uiutil.ACheckbox;
import uiutil.AolRtfArea;
import uiutil.ChangeListener;
import uiutil.ChoiceUI;
import uiutil.ColorSelector;
import uiutil.ColorSelectorListener;
import uiutil.ImageButton;
import uiutil.PropertySheet;
import uiutil.Spacer;
import uiutil.TransparentPanel;
import util.KeyBindings;

public class LocateProps
extends PropertySheet
implements ActionListener,
ColorSelectorListener,
ItemListener,
KeyListener {
    private LocateCore locate;
    private ChangeListener changeListener;
    private AolRtfArea editArea;
    private ImageButton foregroundButton;
    private ImageButton backgroundButton;
    private ImageButton smallerButton;
    private ImageButton normalButton;
    private ImageButton largerButton;
    private ImageButton boldButton;
    private ImageButton italicsButton;
    private ImageButton underlineButton;
    private ACheckbox showCheckbox;
    private boolean changed = false;
    private KeyBindings config;

    public LocateProps(LocateCore locateCore, ChangeListener changeListener) {
        this.locate = locateCore;
        this.changeListener = changeListener;
        this.setBackground(Oscar.backgroundColor);
        this.setLayout(new BorderLayout());
        TransparentPanel transparentPanel = new TransparentPanel();
        this.add("North", transparentPanel);
        transparentPanel.setLayout(new BorderLayout());
        TransparentPanel transparentPanel2 = new TransparentPanel(new FlowLayout(0, 5, 0));
        transparentPanel.add("North", transparentPanel2);
        transparentPanel2.add(new Label("Enter your profile information for others to access."));
        transparentPanel2 = new TransparentPanel();
        transparentPanel.add("Center", transparentPanel2);
        transparentPanel2.setLayout(new FlowLayout(0, 5, 12));
        this.foregroundButton = OscarLabelButton.makeImageButton(locateCore, transparentPanel2, "Fg");
        transparentPanel2.add(this.foregroundButton);
        this.foregroundButton.addActionListener(this);
        this.backgroundButton = OscarLabelButton.makeImageButton(locateCore, transparentPanel2, "Bg");
        transparentPanel2.add(this.backgroundButton);
        this.backgroundButton.addActionListener(this);
        transparentPanel2.add(new Spacer());
        this.smallerButton = OscarLabelButton.makeImageButton(locateCore, transparentPanel2, "Small");
        transparentPanel2.add(this.smallerButton);
        this.smallerButton.addActionListener(this);
        this.normalButton = OscarLabelButton.makeImageButton(locateCore, transparentPanel2, "Normal");
        transparentPanel2.add(this.normalButton);
        this.normalButton.addActionListener(this);
        this.largerButton = OscarLabelButton.makeImageButton(locateCore, transparentPanel2, "Big");
        transparentPanel2.add(this.largerButton);
        this.largerButton.addActionListener(this);
        transparentPanel2.add(new Spacer());
        this.boldButton = OscarLabelButton.makeImageButton(locateCore, transparentPanel2, "Bold");
        transparentPanel2.add(this.boldButton);
        this.boldButton.addActionListener(this);
        this.boldButton.setSticky(true);
        this.italicsButton = OscarLabelButton.makeImageButton(locateCore, transparentPanel2, "Italic");
        transparentPanel2.add(this.italicsButton);
        this.italicsButton.addActionListener(this);
        this.italicsButton.setSticky(true);
        this.underlineButton = OscarLabelButton.makeImageButton(locateCore, transparentPanel2, "Under");
        transparentPanel2.add(this.underlineButton);
        this.underlineButton.addActionListener(this);
        this.underlineButton.setSticky(true);
        this.editArea = new AolRtfArea("Profile", null, true, true, -1, 0);
        this.add("Center", this.editArea);
        this.editArea.addKeyListener(this);
        this.showCheckbox = new ACheckbox("Show this screen at login on missing profile.");
        this.add("South", this.showCheckbox);
        this.showCheckbox.addItemListener(this);
        this.setValues();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.foregroundButton)) {
            new ColorSelector(this, "Set the forground color", Color.black, Color.white, true);
        } else if (object.equals(this.backgroundButton)) {
            new ColorSelector(this, "Set the background color", Color.black, Color.white, false);
        } else if (object.equals(this.smallerButton)) {
            this.editArea.shrinkFont();
        } else if (object.equals(this.normalButton)) {
            this.editArea.resetFontSize();
        } else if (object.equals(this.largerButton)) {
            this.editArea.enlargeFont();
        } else if (object.equals(this.boldButton)) {
            if (this.boldButton.isDown()) {
                this.editArea.setStyle('b', true);
            } else {
                this.editArea.setStyle('b', false);
            }
        } else if (object.equals(this.italicsButton)) {
            if (this.italicsButton.isDown()) {
                this.editArea.setStyle('i', true);
            } else {
                this.editArea.setStyle('i', false);
            }
        } else if (object.equals(this.underlineButton)) {
            if (this.underlineButton.isDown()) {
                this.editArea.setStyle('u', true);
            } else {
                this.editArea.setStyle('u', false);
            }
        }
        this.setChanged(true);
    }

    public boolean changed() {
        return this.changed;
    }

    public boolean help() {
        ChoiceUI.newChoiceUI("Setup Help", "Type your profile in the edit window. You can modify the appearance of the text using the buttons above the window. After you have finished editing, you can click on the Save or Cancel button at the bottom of the edit window to save or cancel your changes. If you don't want " + Oscar.FULL_NAME + " to invoke the profile editor when you log in without a " + "profile, uncheck the box below the editor window.");
        return true;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.showCheckbox) {
            this.setChanged(true);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.setChanged(true);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void removeNotify() {
        this.removeAll();
        this.locate = null;
        this.changeListener = null;
        this.editArea = null;
        this.foregroundButton = null;
        this.backgroundButton = null;
        this.smallerButton = null;
        this.normalButton = null;
        this.largerButton = null;
        this.boldButton = null;
        this.italicsButton = null;
        this.underlineButton = null;
        this.showCheckbox = null;
        this.setLayout(null);
        super.removeNotify();
    }

    public boolean save() {
        String string = this.editArea.getText();
        int n = this.locate.getMaxSignatureSize();
        boolean bl = true;
        this.config = Oscar.config.getKeyBindingsOrAdd(LocateCore.LOCATE_KEY);
        if (string != null && string.length() > 0) {
            string = this.editArea.getTextAsHTML();
        }
        if (string != null && string.length() > n) {
            String string2 = "Your personal profile is too big. The maximum size allowed is " + n + " bytes. Your " + "profile exceeds this size by " + (string.length() - n) + " bytes. Please make your profile shorter. ";
            ChoiceUI.newChoiceUI("Profile Too Big", string2, Oscar.WARNING_SOUND);
            bl = false;
        } else {
            this.config.setValue(LocateCore.WARNING_KEY, String.valueOf(this.showCheckbox.getState()));
            if (string != null && string.length() > 0) {
                bl = this.locate.setSignature(string);
            }
            this.setChanged(false);
        }
        return bl;
    }

    private void setChanged(boolean bl) {
        this.changed = bl;
        if (bl) {
            this.changeListener.setChanged(true);
        }
    }

    public void setValues() {
        this.editArea.setHTML(this.locate.getSignatureAsHTML());
        this.showCheckbox.setState(this.locate.getValue(LocateCore.WARNING_KEY, true));
        this.setChanged(false);
    }

    public void setColor(Object object, boolean bl, Color color) {
        if (bl) {
            this.editArea.setFG(color);
        } else {
            this.editArea.setBG(color);
        }
        this.setChanged(true);
    }
}

