/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.LocateCore;
import component.OscarLabelButton;
import component.PaintedIcon;
import component.Tool;
import component.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import main.Nickname;
import main.Oscar;
import main.Rate;
import uiutil.AolRtfArea;
import uiutil.ChoiceUI;
import uiutil.ErrorMgr;
import uiutil.HorizontalRule;
import uiutil.IUtil;
import uiutil.IconMeter;
import uiutil.ImageButton;
import uiutil.ImageLabel;
import uiutil.ImagePanel;
import uiutil.LedBar;
import uiutil.OFrame;
import uiutil.TransparentPanel;
import util.JUtil;

class LocateUI
extends OFrame
implements ActionListener,
KeyListener {
    private static String MODULE = "LocateUI";
    private static int WIDTH = 350;
    private static int HEIGHT = 350;
    private LocateCore core;
    private Tools tools;
    private String nickname;
    private OscarLabelButton sendButton;
    private OscarLabelButton cancelButton;
    private ImageButton imButton;
    private TransparentPanel userInfoPanel;
    private IconMeter classIcon;
    private ImageLabel classLabel;
    private String classLabelMax;
    private ImageLabel memberLabel;
    private String memberLabelMax;
    private PaintedIcon evilIcon;
    private ImageLabel evilLabel;
    private String evilLabelMax;
    private PaintedIcon idleIcon;
    private ImageLabel idleLabel;
    private String idleLabelMax;
    private ImageLabel logonLabel;
    private String logonLabelMax;
    private TextField nicknameField;
    private AolRtfArea dataDisplay;
    private boolean fullDataDisplay;
    private boolean firstShow;
    private Image tile;
    private Image[] classImages;
    private String[] classStrings;
    private String[] classLabels;
    private LedBar rateIndicator;
    private boolean enabled;

    public LocateUI(LocateCore locateCore, Tools tools, String string) {
        TransparentPanel transparentPanel;
        String string2;
        this.classStrings = Oscar.images.CLASS_ICON_FILES;
        this.classLabels = Oscar.images.CLASS_ICON_LABELS;
        this.enabled = true;
        this.core = locateCore;
        this.tools = tools;
        this.firstShow = true;
        this.setLayout(new BorderLayout());
        ImagePanel imagePanel = new ImagePanel();
        this.add("Center", imagePanel);
        imagePanel.setLayout(new BorderLayout());
        this.tile = Oscar.images.getImage(locateCore, Oscar.BG_TILE, imagePanel, true);
        imagePanel.setTile(this.tile);
        if (string == null) {
            string2 = "Info";
            this.nickname = "";
            this.fullDataDisplay = false;
            transparentPanel = new TransparentPanel();
            transparentPanel.add(new ImageLabel("Get Info On:", 3));
            this.nicknameField = new TextField(16);
            transparentPanel.add(this.nicknameField);
        } else {
            string2 = "Info: " + string;
            this.nickname = string;
            this.fullDataDisplay = true;
            transparentPanel = new TransparentPanel();
            transparentPanel.setLayout(new BorderLayout());
            this.userInfoPanel = this.createUserInfoPanel();
            transparentPanel.add("North", this.userInfoPanel);
            transparentPanel.add("Center", new HorizontalRule());
            transparentPanel.add("South", new ImageLabel("Personal Profile:", 2));
            this.dataDisplay = new AolRtfArea("Info", null, true, false, -1, 0);
            imagePanel.add("Center", this.dataDisplay);
        }
        this.setTitle(string2);
        imagePanel.add("North", transparentPanel);
        ImagePanel imagePanel2 = new ImagePanel();
        imagePanel.add("South", imagePanel2);
        imagePanel2.setTile(this.tile);
        imagePanel2.setLayout(new BorderLayout());
        this.rateIndicator = new LedBar();
        imagePanel2.add("North", this.rateIndicator);
        this.rateIndicator.setSize(170, 22);
        transparentPanel = new TransparentPanel();
        imagePanel2.add("South", transparentPanel);
        if (string == null) {
            this.sendButton = new OscarLabelButton("Send", locateCore, transparentPanel);
            transparentPanel.add(this.sendButton);
            this.sendButton.addActionListener(this);
            this.cancelButton = new OscarLabelButton("Cancel", locateCore, transparentPanel);
            transparentPanel.add(this.cancelButton);
            this.cancelButton.addActionListener(this);
        } else {
            this.imButton = OscarLabelButton.makeImageButton(locateCore, transparentPanel, "Im");
            transparentPanel.add(this.imButton);
            this.imButton.addActionListener(this);
        }
        this.updateRate(locateCore.getRate());
        this.pack();
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (this.sendButton != null) {
            this.sendButton.setEnabled(bl);
        }
        if (this.imButton != null) {
            this.imButton.setEnabled(bl);
        }
        if (bl) {
            ((Component)this).setCursor(Cursor.getDefaultCursor());
            return;
        }
        ((Component)this).setCursor(Cursor.getPredefinedCursor(3));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.sendButton) || object.equals(this.nicknameField)) {
            this.locateButtonAction();
            return;
        }
        if (object.equals(this.imButton)) {
            this.icbmButtonAction();
            return;
        }
        if (object.equals(this.cancelButton)) {
            ((Component)this).setVisible(false);
            this.dispose();
        }
    }

    private TransparentPanel createUserInfoPanel() {
        this.setLabelMaximums();
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.setLayout(new BorderLayout());
        TransparentPanel transparentPanel2 = new TransparentPanel();
        transparentPanel.add("West", transparentPanel2);
        transparentPanel2.setLayout(new FlowLayout(1, 0, 0));
        TransparentPanel transparentPanel3 = new TransparentPanel();
        transparentPanel2.add(transparentPanel3);
        transparentPanel3.setLayout(new GridLayout(0, 1, 0, 0));
        transparentPanel3.add(new ImageLabel("Warnings: ", 3, 5, 1));
        transparentPanel3.add(new ImageLabel("Idle Time: ", 3, 5, 1));
        transparentPanel3.add(new ImageLabel("On Since: ", 3, 5, 1));
        transparentPanel3 = new TransparentPanel();
        transparentPanel2.add(transparentPanel3);
        transparentPanel3.setLayout(new GridLayout(0, 1, 0, 0));
        TransparentPanel transparentPanel4 = new TransparentPanel();
        transparentPanel3.add(transparentPanel4);
        transparentPanel4.setLayout(new FlowLayout(0, 0, 0));
        this.evilIcon = new PaintedIcon(Oscar.images.MINI_ICON_SIZE, Oscar.images.MINI_ICON_SIZE, 1);
        transparentPanel4.add(this.evilIcon);
        this.evilLabel = new ImageLabel(this.evilLabelMax, 2, 5, 1);
        transparentPanel4.add(this.evilLabel);
        this.evilLabel.setTextStyle(0);
        transparentPanel4 = new TransparentPanel();
        transparentPanel3.add(transparentPanel4);
        transparentPanel4.setLayout(new FlowLayout(0, 0, 0));
        this.idleIcon = new PaintedIcon(Oscar.images.MINI_ICON_SIZE, Oscar.images.MINI_ICON_SIZE, 2);
        transparentPanel4.add(this.idleIcon);
        this.idleLabel = new ImageLabel(this.idleLabelMax, 2, 5, 1);
        transparentPanel4.add(this.idleLabel);
        this.idleLabel.setTextStyle(0);
        this.logonLabel = new ImageLabel(this.logonLabelMax, 2, 0, 1);
        transparentPanel3.add(this.logonLabel);
        this.logonLabel.setTextStyle(0);
        transparentPanel2 = new TransparentPanel();
        transparentPanel.add("East", transparentPanel2);
        transparentPanel2.setLayout(new FlowLayout(0, 0, 0));
        transparentPanel3 = new TransparentPanel();
        transparentPanel2.add(transparentPanel3);
        transparentPanel3.setLayout(new GridLayout(0, 1, 0, 0));
        transparentPanel3.add(new ImageLabel("Class: ", 3, 5, 1));
        transparentPanel3.add(new ImageLabel("Member Since: ", 3, 5, 1));
        transparentPanel3 = new TransparentPanel();
        transparentPanel2.add(transparentPanel3);
        transparentPanel3.setLayout(new GridLayout(0, 1, 0, 0));
        transparentPanel4 = new TransparentPanel();
        transparentPanel3.add(transparentPanel4);
        transparentPanel4.setLayout(new FlowLayout(0, 0, 0));
        this.classImages = Oscar.images.getImages(this.core, this.classStrings, transparentPanel2, true);
        this.classIcon = new IconMeter("locate-class", this.classImages);
        transparentPanel4.add(this.classIcon);
        this.classLabel = new ImageLabel(this.classLabelMax, 2, 5, 1);
        transparentPanel4.add(this.classLabel);
        this.classLabel.setTextStyle(0);
        this.memberLabel = new ImageLabel(this.memberLabelMax, 2, 0, 1);
        transparentPanel3.add(this.memberLabel);
        this.memberLabel.setTextStyle(0);
        return transparentPanel;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c != '\u0002' && c == '\t') {
            this.icbmButtonAction();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void icbmButtonAction() {
        Tool tool = this.tools.get("Icbm");
        if (tool != null) {
            Vector<String> vector = new Vector<String>(1);
            vector.addElement(this.nickname);
            tool.initiate(vector, null);
            return;
        }
        ErrorMgr.warn(MODULE, "The IM service is currently unavailable.");
    }

    private void locateButtonAction() {
        String string = this.nicknameField.getText();
        if (string != null && string.length() > 0) {
            this.nickname = string;
            ((Component)this).setVisible(false);
            this.core.locate(this.nickname);
            this.dispose();
            return;
        }
        ChoiceUI.newChoiceUI("Locate Alert", "Please provide the name of the member you wish to locate.", Oscar.WARNING_SOUND);
    }

    public void removeNotify() {
        this.removeAll();
        if (this.core != null) {
            this.core.removeUI(this);
        }
        this.core = null;
        this.tools = null;
        this.nickname = null;
        this.sendButton = null;
        this.cancelButton = null;
        this.imButton = null;
        this.userInfoPanel = null;
        this.classIcon = null;
        this.classLabel = null;
        this.classLabelMax = null;
        this.memberLabel = null;
        this.memberLabelMax = null;
        this.evilIcon = null;
        this.evilLabel = null;
        this.evilLabelMax = null;
        this.idleIcon = null;
        this.idleLabel = null;
        this.idleLabelMax = null;
        this.logonLabel = null;
        this.logonLabelMax = null;
        this.nicknameField = null;
        if (this.dataDisplay != null) {
            this.dataDisplay.destroy();
        }
        this.dataDisplay = null;
        this.tile = null;
        this.classImages = null;
        this.classStrings = null;
        this.classLabels = null;
        this.rateIndicator = null;
        super.removeNotify();
    }

    private void setLabelMaximums() {
        int n;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.classLabels.length) {
            n = this.classLabels[n3].length();
            if (n > n2) {
                n2 = n;
            }
            ++n3;
        }
        this.classLabelMax = "";
        n = 0;
        while (n < n2) {
            this.classLabelMax = String.valueOf(this.classLabelMax) + "M";
            ++n;
        }
        this.memberLabelMax = "MM MM, MMMM";
        this.evilLabelMax = "MMM";
        this.idleLabelMax = "MMMMMMM";
        this.logonLabelMax = "MMMMMMM";
    }

    public void showData(Nickname nickname, String string, byte[] byArray) {
        Object object;
        if (!this.fullDataDisplay) {
            return;
        }
        String string2 = byArray != null ? new String(byArray) : LocateCore.LOCATE_INFO;
        if (!string2.toUpperCase().startsWith("<HTML>")) {
            string2 = JUtil.htmlize(string2);
        }
        if (string == null) {
            string = LocateCore.DEFAULT_MIME_TYPE;
        }
        if (nickname.nickname == null) {
            nickname.nickname = LocateCore.BLANK_NICKNAME;
        }
        if (!(string.toLowerCase().startsWith("text/plain") || string.toLowerCase().startsWith("text/x-aolrtf") || string.toLowerCase().startsWith("text/aolrtf") || string.toLowerCase().startsWith("text/html"))) {
            object = "Unsupported MIME type \"" + string + "\".";
            ErrorMgr.warn(MODULE, String.valueOf(object) + "Will try to display as HTML.");
        }
        if (string2 != null) {
            this.dataDisplay.setHTML(string2);
        }
        if (this.firstShow) {
            this.pack();
            object = this.getBounds();
            if (((Rectangle)object).width > WIDTH) {
                WIDTH = ((Rectangle)object).width;
            }
            if (((Rectangle)object).height > HEIGHT) {
                HEIGHT = ((Rectangle)object).height;
            }
            ((Component)this).setSize(WIDTH, HEIGHT);
        }
        this.updateRate(this.core.getRate());
        this.updateUserInfo(nickname);
        ((Component)this).setVisible(true);
        if (this.firstShow) {
            IUtil.playSound(this.core, "info");
            this.firstShow = false;
        }
    }

    public void updateRate(Rate rate) {
        if (rate != null && this.rateIndicator != null) {
            if (rate.limited) {
                this.rateIndicator.setLimits(rate.disconnect, rate.clear, rate.clear, rate.maxAve);
            } else {
                this.rateIndicator.setLimits(rate.disconnect, rate.limit, rate.alert, rate.maxAve);
            }
            this.rateIndicator.setValue(rate.rate);
        }
    }

    public void updateUserEvil(int n) {
        this.evilIcon.set(n);
        this.evilLabel.setText(String.valueOf(n));
    }

    public void updateUserInfo(Nickname nickname) {
        int n = nickname.getClassCode();
        this.classIcon.set(n + 1);
        this.classLabel.setText(this.classLabels[n + 1]);
        String string = nickname.memberSinceAsString();
        if (string == null) {
            string = "Unknown";
        }
        this.memberLabel.setText(string);
        this.evilIcon.set(nickname.evil);
        this.evilLabel.setText(String.valueOf(nickname.evil));
        this.idleIcon.set(nickname.idleTime);
        this.idleLabel.setText(JUtil.timeString(nickname.idleTime));
        this.logonLabel.setText(JUtil.shortDate(nickname.signonTOD));
    }
}

