/*
 * Decompiled with CFR 0.152.
 */
package component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import main.Oscar;
import uiutil.ImageButton;
import uiutil.ImagePanel;
import uiutil.ImageStore;
import uiutil.UIPack;

public class OscarLabelButton
extends ImageButton {
    private static final Font font = new Font("Dialog", 0, 12);
    private UIPack pack;
    Component observer;
    private String etchedLabel;

    public OscarLabelButton() {
    }

    public OscarLabelButton(String string, UIPack uIPack, Component component) {
        this.label = string;
        this.etchedLabel = string;
        this.pack = uIPack;
        this.observer = component;
    }

    public String getLabel() {
        if (this.label == null) {
            return this.etchedLabel;
        }
        return this.label;
    }

    public void addNotify() {
        super.addNotify();
        this.etchedLabel = this.label;
        this.createImages();
    }

    public void destroy() {
        this.pack = null;
        this.observer = null;
        super.destroy();
    }

    public void removeNotify() {
        this.destroy();
        super.removeNotify();
    }

    public void changeButton(String string, UIPack uIPack, Component component) {
        this.pack = uIPack;
        this.observer = component;
        this.label = string;
        this.etchedLabel = string;
        this.createImages();
    }

    public static void changeImageButton(ImageButton imageButton, UIPack uIPack, Component component, String string) {
        String[] stringArray = new String[4];
        String[] stringArray2 = new String[4];
        stringArray[0] = ImageStore.makeName(String.valueOf(string) + ImageStore.NORMAL);
        stringArray[1] = ImageStore.makeName(String.valueOf(string) + ImageStore.PRESSED);
        stringArray[2] = ImageStore.makeName(String.valueOf(string) + ImageStore.HIGHLIGHTED);
        stringArray[3] = null;
        Image[] imageArray = Oscar.images.getImages(uIPack, stringArray, component, true, false, stringArray2);
        imageArray = Oscar.images.getMissingButtonImages(imageArray, component);
        imageArray[3] = Oscar.images.makeDimImage(imageArray[0], component, String.valueOf(stringArray2[0]) + ImageStore.DISABLED);
        imageButton.setImages(imageArray[0], imageArray[1], imageArray[3], imageArray[2]);
    }

    public static ImageButton makeImageButton(UIPack uIPack, Component component, String string) {
        String[] stringArray = new String[4];
        String[] stringArray2 = new String[4];
        stringArray[0] = ImageStore.makeName(String.valueOf(string) + ImageStore.NORMAL);
        stringArray[1] = ImageStore.makeName(String.valueOf(string) + ImageStore.PRESSED);
        stringArray[2] = ImageStore.makeName(String.valueOf(string) + ImageStore.HIGHLIGHTED);
        stringArray[3] = null;
        Image[] imageArray = Oscar.images.getImages(uIPack, stringArray, component, true, false, stringArray2);
        imageArray = Oscar.images.getMissingButtonImages(imageArray, component);
        imageArray[3] = Oscar.images.makeDimImage(imageArray[0], component, String.valueOf(stringArray2[0]) + 4);
        return new ImageButton(imageArray[0], imageArray[1], imageArray[3], imageArray[2]);
    }

    private void createImages() {
        int n;
        String[] stringArray = new String[12];
        String[] stringArray2 = new String[12];
        stringArray[0] = ImageStore.makeName("BlankL" + ImageStore.NORMAL);
        stringArray[1] = ImageStore.makeName("BlankL" + ImageStore.PRESSED);
        stringArray[2] = ImageStore.makeName("BlankL" + ImageStore.HIGHLIGHTED);
        stringArray[3] = null;
        stringArray[4] = ImageStore.makeName("BlankC" + ImageStore.NORMAL);
        stringArray[5] = ImageStore.makeName("BlankC" + ImageStore.PRESSED);
        stringArray[6] = ImageStore.makeName("BlankC" + ImageStore.HIGHLIGHTED);
        stringArray[7] = null;
        stringArray[8] = ImageStore.makeName("BlankR" + ImageStore.NORMAL);
        stringArray[9] = ImageStore.makeName("BlankR" + ImageStore.PRESSED);
        stringArray[10] = ImageStore.makeName("BlankR" + ImageStore.HIGHLIGHTED);
        stringArray[11] = null;
        Image[] imageArray = Oscar.images.getImages(this.pack, stringArray, this.observer, true, false, stringArray2);
        imageArray = Oscar.images.getMissingButtonImages(imageArray, this.observer);
        if (this.label == null) {
            this.label = "Unknown";
        }
        FontMetrics fontMetrics = this.observer.getFontMetrics(font);
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        rectangle.width = fontMetrics.stringWidth(this.label);
        rectangle.height = fontMetrics.getAscent() + fontMetrics.getDescent();
        rectangle.y = (imageArray[0].getHeight(this.observer) - 4 - rectangle.height) / 2 + rectangle.height - fontMetrics.getDescent();
        int n2 = imageArray[0].getWidth(this.observer);
        int n3 = imageArray[8].getWidth(this.observer);
        int n4 = 0;
        while ((n = 2 * n2 - 2 * ImageStore.BUTTON_MARGIN + n4 * n3) < rectangle.width) {
            ++n4;
        }
        rectangle.x = (n + 2 * ImageStore.BUTTON_MARGIN - rectangle.width) / 2;
        Image image = null;
        Image[] imageArray2 = new Image[4];
        if (this.observer instanceof ImagePanel) {
            image = ((ImagePanel)this.observer).getTile();
        }
        int n5 = 0;
        while (n5 < 3) {
            Image image2 = (Image)Oscar.images.get(String.valueOf(stringArray2[n5]) + " " + this.label);
            if (image2 != null) {
                imageArray2[n5] = image2;
            } else {
                image2 = this.observer.createImage(n + 2 * ImageStore.BUTTON_MARGIN, imageArray[n5].getHeight(this.observer));
                Graphics graphics = image2.getGraphics();
                if (image != null) {
                    graphics.drawImage(image, 0, 0, this.observer);
                } else {
                    graphics.setColor(Color.red);
                    graphics.fillRect(0, 0, image2.getWidth(this.observer), image2.getHeight(this.observer));
                }
                graphics.drawImage(imageArray[n5], 0, 0, this.observer);
                int n6 = 0;
                while (n6 < n4) {
                    graphics.drawImage(imageArray[n5 + 4], n2 + n6 * n3, 0, this.observer);
                    ++n6;
                }
                graphics.drawImage(imageArray[n5 + 8], n2 + n4 * n3, 0, this.observer);
                graphics.setColor(Color.white);
                graphics.setFont(font);
                if (n5 == 1) {
                    graphics.drawString(this.label, rectangle.x + 3, rectangle.y + 3);
                } else {
                    graphics.drawString(this.label, rectangle.x, rectangle.y);
                }
                imageArray2[n5] = image2 = ImageStore.makeTransparent(image2, Color.red, this);
                Oscar.images.put(String.valueOf(stringArray2[n5]) + " " + this.label, image2);
            }
            ++n5;
        }
        imageArray2[3] = Oscar.images.makeDimImage(imageArray2[0], this.observer, String.valueOf(stringArray2[0]) + ImageStore.DISABLED + " " + this.label);
        this.label = null;
        this.setImages(imageArray2[0], imageArray2[1], imageArray2[3], imageArray2[2]);
    }
}

