/*
 * Decompiled with CFR 0.152.
 */
package module;

import java.awt.BorderLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import main.Oscar;
import uiutil.ChangeListener;
import uiutil.ChoiceUI;
import uiutil.IUtil;
import uiutil.PropertySheet;
import uiutil.Spacer;
import uiutil.TransparentPanel;
import util.JarFile;
import util.KeyBindings;

public class ModuleSelector
extends PropertySheet
implements ItemListener,
ActionListener {
    String prefix;
    List list;
    ChangeListener changeListener;
    boolean changed = false;
    KeyBindings keys;
    Vector jars = new Vector();

    public ModuleSelector(KeyBindings keyBindings, String string, ChangeListener changeListener) {
        this.keys = keyBindings;
        this.prefix = string;
        this.changeListener = changeListener;
        this.setLayout(new BorderLayout());
        this.add("North", new Spacer());
        this.add("West", new Spacer());
        this.add("East", new Spacer());
        this.add("South", new Spacer());
        TransparentPanel transparentPanel = new TransparentPanel(new BorderLayout());
        this.add("Center", transparentPanel);
        transparentPanel.add("North", new Label("Select modules to use.  Double click for more info."));
        this.list = new List();
        transparentPanel.add("Center", this.list);
        this.list.setMultipleMode(true);
        this.list.addItemListener(this);
        this.list.addActionListener(this);
        this.setValues();
    }

    public boolean changed() {
        return this.changed;
    }

    public boolean help() {
        ChoiceUI.newChoiceUI("Module Selection Help", "Selection which modules you want loaded.");
        return true;
    }

    public boolean save() {
        this.keys.setKeySeparator('#');
        int n = 0;
        while (n < this.jars.size()) {
            String string = (String)this.jars.elementAt(n);
            int n2 = -1;
            n2 = this.keys.size() - 1;
            while (n2 >= 0) {
                String string2 = this.keys.getKeyAt(n2);
                if (string2.equals(string)) {
                    if (this.list.isIndexSelected(n)) break;
                    this.keys.deleteKey(string2);
                    break;
                }
                --n2;
            }
            if (n2 == -1 && this.list.isIndexSelected(n)) {
                this.keys.setValue(string, "");
            }
            ++n;
        }
        this.setChanged(false);
        this.keys.setKeySeparator('.');
        ChoiceUI.newChoiceUI("Module Selection", "These changes will not take effect until you restart " + Oscar.FULL_NAME + ".");
        return true;
    }

    void addDirToList(File file) throws IOException {
        String[] stringArray = file.list();
        int n = this.keys.size();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].startsWith(this.prefix)) {
                JarFile jarFile = new JarFile(String.valueOf(file) + File.separator + stringArray[n2]);
                jarFile.loadManifest();
                String string = jarFile.getModuleTitle();
                if (string == null) {
                    string = stringArray[n2];
                }
                if (!IUtil.inList(string, this.list)) {
                    this.list.addItem(string);
                    this.jars.addElement(stringArray[n2]);
                    int n3 = 0;
                    while (n3 < n) {
                        String string2 = this.keys.getKeyAt(n3);
                        if (string2.equals(stringArray[n2])) {
                            this.list.select(this.list.getItemCount() - 1);
                            break;
                        }
                        ++n3;
                    }
                }
            }
            ++n2;
        }
    }

    public void setValues() {
        this.setChanged(false);
        this.list.removeAll();
        try {
            File file = new File(String.valueOf(Oscar.ROOT) + "modules");
            if (file.exists()) {
                this.addDirToList(file);
            }
            if ((file = new File(String.valueOf(Oscar.CONFIG_DIR) + "modules")).exists()) {
                this.addDirToList(file);
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
        if (bl) {
            this.changeListener.setChanged(true);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.setChanged(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        int n = 0;
        while (n < this.list.getItemCount()) {
            if (string.equals(this.list.getItem(n))) {
                try {
                    File file = new File(String.valueOf(Oscar.CONFIG_DIR) + "modules" + File.separator + (String)this.jars.elementAt(n));
                    if (!file.exists()) {
                        file = new File(String.valueOf(Oscar.ROOT) + "modules" + File.separator + (String)this.jars.elementAt(n));
                    }
                    if (!file.exists()) {
                        return;
                    }
                    JarFile jarFile = new JarFile(file.getPath());
                    jarFile.loadManifest();
                    ChoiceUI.newChoiceUI("Detail Information On: " + string, "Version: " + jarFile.getModuleVersion() + " \n" + "Author: " + jarFile.getModuleAuthor() + " \n" + "Description: " + jarFile.getModuleDescription());
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
            }
            ++n;
        }
    }
}

