/*
 * Decompiled with CFR 0.152.
 */
package module;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import main.Oscar;
import module.Module;
import util.JarFile;
import util.KeyBindings;
import util.Log;

public class Modules {
    private static final String MODULE = "Modules";
    static Hashtable loadedModules = new Hashtable();

    static void register(Module module) {
        loadedModules.put(module.getModuleName(), module);
    }

    public static Enumeration keys() {
        return loadedModules.keys();
    }

    public static Enumeration elements() {
        return loadedModules.elements();
    }

    public static Module lookup(String string) {
        return (Module)loadedModules.get(string);
    }

    public static Module loadModule(String string, Class clazz) {
        if (string.endsWith(".class")) {
            try {
                String string2 = string.substring(0, string.length() - 6);
                Class<?> clazz2 = Class.forName(string2);
                if (clazz != null && !clazz.isAssignableFrom(clazz2)) {
                    Log.log(MODULE, Log.ERROR, String.valueOf(clazz2) + " is  not of type " + clazz);
                    return null;
                }
                Module module = (Module)clazz2.newInstance();
                Modules.register(module);
                return module;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            if (string.endsWith(".jar")) {
                File file = new File(String.valueOf(Oscar.CONFIG_DIR) + "modules", string);
                if (!file.exists()) {
                    file = new File(String.valueOf(Oscar.ROOT) + "modules", string);
                }
                if (!file.exists()) {
                    Log.log(MODULE, Log.NOTICE, "Can't file jar file " + string + " anywhere.");
                    return null;
                }
                try {
                    JarFile jarFile = new JarFile(file.getPath());
                    jarFile.loadEntireJar();
                    Vector vector = jarFile.getBeanNames();
                    if (vector.size() < 1) {
                        return null;
                    }
                    String string3 = (String)vector.elementAt(0);
                    Class clazz3 = jarFile.loadClass(string3);
                    if (clazz != null && !clazz.isAssignableFrom(clazz3)) {
                        Log.log(MODULE, Log.ERROR, String.valueOf(clazz3) + " is not of type " + clazz);
                        return null;
                    }
                    Module module = (Module)clazz3.newInstance();
                    Modules.register(module);
                    return module;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return null;
                }
            }
            Log.log(MODULE, Log.ERROR, "Don't know how to load module " + string + " yet.");
        }
        return null;
    }

    public static Vector loadModules(KeyBindings keyBindings, Class clazz) {
        Vector<Module> vector = new Vector<Module>();
        if (keyBindings == null) {
            return vector;
        }
        int n = 0;
        while (n < keyBindings.size()) {
            Module module = Modules.loadModule(keyBindings.getKeyAt(n), clazz);
            if (module != null) {
                vector.addElement(module);
            }
            ++n;
        }
        return vector;
    }
}

