/*
 * Decompiled with CFR 0.152.
 */
package snac;

import flap.FLAPSock;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import snac.BuddyListener;
import snac.DispatcherListener;
import snac.Listener;
import snac.SNACHeader;
import snac.SnacHandler;
import snac.SnacNickname;
import snac.SnacNicknameWdelta;
import snac.SnacNicknameWinfo;
import snac.SnacTlv;
import snac.TLV;
import uiutil.ErrorMgr;
import util.Log;
import util.OutputBuffer;

public class BuddyHandler
extends SnacHandler {
    private static final String MODULE = "SNAC";

    public BuddyHandler(DispatcherListener dispatcherListener) {
        this.dispatcher = dispatcherListener;
        dispatcherListener.registerSNACHandler(3, 1, this);
    }

    public void rightsQuery(FLAPSock fLAPSock, BuddyListener buddyListener, Object object) {
        Log.log(MODULE, Log.DB1, "writing buddyRightsQuery SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            this.dispatcher.queueOutput(fLAPSock, buddyListener, object, 3, 2, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Buddy", "got IOException in buddyRightsQuery " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeRightsReply(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got buddyRightsReply SNAC");
        BuddyListener buddyListener = (BuddyListener)listener;
        try {
            block8: {
                int n;
                int n2;
                TLV tLV;
                block7: {
                    tLV = new TLV();
                    while (dataInputStream.available() > 0) {
                        tLV.addElement(new SnacTlv(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (buddyListener != null) {
                        n2 = this.updateHandledState(n2, buddyListener.buddyRightsReply(fLAPSock, object, sNACHeader.reqID, n2, tLV));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    BuddyListener buddyListener2;
                    if ((buddyListener2 = (BuddyListener)vector.elementAt(n)) != buddyListener) {
                        n2 = this.updateHandledState(n2, buddyListener2.buddyRightsReply(fLAPSock, object, sNACHeader.reqID, n2, tLV));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Buddy", "got IOException in buddyRightsReply " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void addBuddies(FLAPSock fLAPSock, BuddyListener buddyListener, Object object, Vector vector) {
        Log.log(MODULE, Log.DB1, "writing buddyAddBuddies SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < vector.size()) {
                ((SnacNickname)vector.elementAt(n)).write(outputBuffer.d);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, buddyListener, object, 3, 4, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Buddy", "got IOException in buddyAddBuddies " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void delBuddies(FLAPSock fLAPSock, BuddyListener buddyListener, Object object, Vector vector) {
        Log.log(MODULE, Log.DB1, "writing buddyDelBuddies SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < vector.size()) {
                ((SnacNickname)vector.elementAt(n)).write(outputBuffer.d);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, buddyListener, object, 3, 5, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Buddy", "got IOException in buddyDelBuddies " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void watcherListQuery(FLAPSock fLAPSock, BuddyListener buddyListener, Object object) {
        Log.log(MODULE, Log.DB1, "writing buddyWatcherListQuery SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            this.dispatcher.queueOutput(fLAPSock, buddyListener, object, 3, 6, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Buddy", "got IOException in buddyWatcherListQuery " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeWatcherListResponse(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got buddyWatcherListResponse SNAC");
        BuddyListener buddyListener = (BuddyListener)listener;
        try {
            block8: {
                int n;
                int n2;
                Vector<SnacNickname> vector2;
                int n3;
                block7: {
                    n3 = dataInputStream.readUnsignedShort();
                    vector2 = new Vector<SnacNickname>();
                    while (dataInputStream.available() > 0) {
                        vector2.addElement(new SnacNickname(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (buddyListener != null) {
                        n2 = this.updateHandledState(n2, buddyListener.buddyWatcherListResponse(fLAPSock, object, sNACHeader.reqID, n2, n3, vector2));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    BuddyListener buddyListener2;
                    if ((buddyListener2 = (BuddyListener)vector.elementAt(n)) != buddyListener) {
                        n2 = this.updateHandledState(n2, buddyListener2.buddyWatcherListResponse(fLAPSock, object, sNACHeader.reqID, n2, n3, vector2));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Buddy", "got IOException in buddyWatcherListResponse " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void watcherSubRequest(FLAPSock fLAPSock, BuddyListener buddyListener, Object object, int n) {
        Log.log(MODULE, Log.DB1, "writing buddyWatcherSubRequest SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            outputBuffer.d.writeShort(n);
            this.dispatcher.queueOutput(fLAPSock, buddyListener, object, 3, 8, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Buddy", "got IOException in buddyWatcherSubRequest " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeWatcherNotification(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got buddyWatcherNotification SNAC");
        BuddyListener buddyListener = (BuddyListener)listener;
        try {
            block8: {
                int n;
                int n2;
                Vector<SnacNicknameWdelta> vector2;
                block7: {
                    vector2 = new Vector<SnacNicknameWdelta>();
                    while (dataInputStream.available() > 0) {
                        vector2.addElement(new SnacNicknameWdelta(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (buddyListener != null) {
                        n2 = this.updateHandledState(n2, buddyListener.buddyWatcherNotification(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    BuddyListener buddyListener2;
                    if ((buddyListener2 = (BuddyListener)vector.elementAt(n)) != buddyListener) {
                        n2 = this.updateHandledState(n2, buddyListener2.buddyWatcherNotification(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Buddy", "got IOException in buddyWatcherNotification " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeRejectNotification(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got buddyRejectNotification SNAC");
        BuddyListener buddyListener = (BuddyListener)listener;
        try {
            block8: {
                int n;
                int n2;
                Vector<SnacNickname> vector2;
                block7: {
                    vector2 = new Vector<SnacNickname>();
                    while (dataInputStream.available() > 0) {
                        vector2.addElement(new SnacNickname(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (buddyListener != null) {
                        n2 = this.updateHandledState(n2, buddyListener.buddyRejectNotification(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    BuddyListener buddyListener2;
                    if ((buddyListener2 = (BuddyListener)vector.elementAt(n)) != buddyListener) {
                        n2 = this.updateHandledState(n2, buddyListener2.buddyRejectNotification(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Buddy", "got IOException in buddyRejectNotification " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeArrived(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got buddyArrived SNAC");
        BuddyListener buddyListener = (BuddyListener)listener;
        try {
            block8: {
                int n;
                int n2;
                Vector<SnacNicknameWinfo> vector2;
                block7: {
                    vector2 = new Vector<SnacNicknameWinfo>();
                    while (dataInputStream.available() > 0) {
                        vector2.addElement(new SnacNicknameWinfo(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (buddyListener != null) {
                        n2 = this.updateHandledState(n2, buddyListener.buddyArrived(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    BuddyListener buddyListener2;
                    if ((buddyListener2 = (BuddyListener)vector.elementAt(n)) != buddyListener) {
                        n2 = this.updateHandledState(n2, buddyListener2.buddyArrived(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Buddy", "got IOException in buddyArrived " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeDeparted(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got buddyDeparted SNAC");
        BuddyListener buddyListener = (BuddyListener)listener;
        try {
            block8: {
                int n;
                int n2;
                Vector<SnacNicknameWinfo> vector2;
                block7: {
                    vector2 = new Vector<SnacNicknameWinfo>();
                    while (dataInputStream.available() > 0) {
                        vector2.addElement(new SnacNicknameWinfo(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (buddyListener != null) {
                        n2 = this.updateHandledState(n2, buddyListener.buddyDeparted(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    BuddyListener buddyListener2;
                    if ((buddyListener2 = (BuddyListener)vector.elementAt(n)) != buddyListener) {
                        n2 = this.updateHandledState(n2, buddyListener2.buddyDeparted(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Buddy", "got IOException in buddyDeparted " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void decodeSNAC(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        if (sNACHeader.subtype == 1) {
            this.decodeSnacError(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 3) {
            this.decodeRightsReply(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 7) {
            this.decodeWatcherListResponse(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 9) {
            this.decodeWatcherNotification(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 10) {
            this.decodeRejectNotification(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 11) {
            this.decodeArrived(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 12) {
            this.decodeDeparted(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        ErrorMgr.warn("Buddy", " got unrecognized SNAC " + sNACHeader + " ignoring");
        fLAPSock.close("server sending bad data", 23);
    }
}

