/*
 * Decompiled with CFR 0.152.
 */
package snac;

import flap.FLAPSock;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import snac.DispatcherListener;
import snac.Listener;
import snac.PopupHostListener;
import snac.SNACHeader;
import snac.SnacHandler;
import snac.SnacTlv;
import snac.TLV;
import uiutil.ErrorMgr;
import util.Log;
import util.OutputBuffer;

public class PopupHostHandler
extends SnacHandler {
    private static final String MODULE = "SNAC";

    public PopupHostHandler(DispatcherListener dispatcherListener) {
        this.dispatcher = dispatcherListener;
        dispatcherListener.registerSNACHandler(8, 1, this);
    }

    public void displayPopup(FLAPSock fLAPSock, PopupHostListener popupHostListener, Object object, TLV tLV) {
        Log.log(MODULE, Log.DB1, "writing popupDisplayPopup SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < tLV.size()) {
                ((SnacTlv)tLV.elementAt(n)).write(outputBuffer.d);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, popupHostListener, object, 8, 2, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Popup", "got IOException in popupDisplayPopup " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void decodeSNAC(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        if (sNACHeader.subtype == 1) {
            this.decodeSnacError(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
        }
    }
}

