/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import component.DataChoiceUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.Scrollbar;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.FileWriter;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import uiutil.AolRtfListener;
import uiutil.AolRtfPos;
import uiutil.AolRtfTokenizer;
import uiutil.ChoiceListener;
import uiutil.ErrorMgr;
import uiutil.FontInfo;
import uiutil.IUtil;
import uiutil.MUI;
import uiutil.UrlViewer;
import util.JUtil;
import util.Log;
import util.Timer;
import util.TimerListener;

public class AolRtf
extends Panel
implements TimerListener,
ClipboardOwner,
ChoiceListener,
FocusListener,
KeyListener,
MouseListener,
MouseMotionListener,
ActionListener,
AdjustmentListener {
    private static final String MODULE = "AolRtf";
    private static boolean initFonts = true;
    private static String defFamily = "helvetica";
    private static int defPtSize = 12;
    private static Hashtable fontCache = null;
    public static int[] fontSizeMap = new int[]{6, 8, 10, 12, 18, 24, 36, 48};
    public static FontInfo urlFont = null;
    public static FontInfo defFont = null;
    public static Color defFG = Color.black;
    public static Color defBG = Color.white;
    public static int blinkTime = 1000;
    public static long DBL_CLICK_TIME = 300L;
    public static int CURSOR_BLINK_EVENT;
    public static int EDIT_URL;
    private Color fooColor = Color.white;
    private String name;
    private MUI muiStart;
    private MUI muiEnd;
    private Scrollbar sb;
    private Image offScreenBM;
    private int offScreenWidth;
    private int offScreenHeight;
    private int totalHeight;
    private int totalWidth;
    private AolRtfPos selStart;
    private AolRtfPos selEnd;
    private Color selColor = Color.red;
    private boolean editable = false;
    private long lastMouseDownTime;
    private boolean inDoubleClick = false;
    private AolRtfPos mouseDownPos;
    private boolean entireSelectionUnderlined;
    private boolean entireSelectionItalic;
    private boolean entireSelectionBold;
    private AolRtfListener listener;
    private int sendKey = -1;
    private int sendKeyModifiers;
    private MUI scrollToMUI;
    Clipboard clipboard = this.getToolkit().getSystemClipboard();
    private static boolean lb;
    private static boolean sc;
    private static boolean ev;
    private static boolean di;
    private boolean verboseRedraw = false;
    private PopupMenu editMenu;
    private MenuItem[] editItems = new MenuItem[10];
    private static final int UNDO = 0;
    private static final int HYPERLINK = 1;
    private static final int CUT = 2;
    private static final int COPY = 3;
    private static final int PASTE = 4;
    private static final int DELETE = 5;
    private static final int SELECTALL = 6;
    private static final int SAVE = 7;
    private static final int APPEND = 8;
    private static final int PRINT = 9;
    static int moveNone;
    static int moveStart;
    static int moveEnd;
    int lastMoved = moveNone;

    private static void dbg(boolean bl, String string) {
        if (bl) {
            Log.log(MODULE, Log.DB0, string);
        }
    }

    public void destroy() {
        this.name = null;
        MUI mUI = this.muiStart;
        while (mUI != null) {
            MUI mUI2 = mUI.next;
            mUI.flush();
            mUI = mUI2;
        }
        this.muiStart = null;
        this.muiEnd = null;
        this.sb = null;
        this.offScreenBM = null;
        this.selStart = null;
        this.selEnd = null;
        this.selColor = null;
        this.mouseDownPos = null;
        this.listener = null;
    }

    public static void setDefaultColor(Color color, Color color2) {
        defFG = color;
        defBG = color2;
    }

    public static void setDefaultFont(String string, int n) {
        defFamily = string;
        defPtSize = n;
        initFonts = true;
    }

    private void initFonts() {
        if (initFonts) {
            fontCache = new Hashtable();
            urlFont = this.getFontInfoByPt(defFamily, FontInfo.UNDERLINE, defPtSize);
            defFont = this.getFontInfoByPt(defFamily, FontInfo.PLAIN, defPtSize);
        }
        initFonts = false;
    }

    public AolRtf(String string, AolRtfListener aolRtfListener, Scrollbar scrollbar, boolean bl, int n, int n2) {
        this.initFonts();
        this.name = string;
        this.sb = scrollbar;
        if (scrollbar != null) {
            scrollbar.addAdjustmentListener(this);
        }
        this.editable = bl;
        this.listener = aolRtfListener;
        this.sendKey = n;
        this.sendKeyModifiers = n2;
        this.appendMUI(new MUI("", defFont, defFG, defBG));
        this.assignLines(0, this.muiStart, true);
        this.assignXY(this.muiStart, true);
        this.selStart = this.getPos(0, 0);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.editMenu = new PopupMenu();
        this.editItems[1] = new MenuItem("Insert Hyperlink");
        this.editMenu.add(this.editItems[1]);
        this.editMenu.addSeparator();
        this.editItems[2] = new MenuItem("Cut");
        this.editMenu.add(this.editItems[2]);
        this.editItems[3] = new MenuItem("Copy");
        this.editMenu.add(this.editItems[3]);
        this.editItems[4] = new MenuItem("Paste");
        this.editMenu.add(this.editItems[4]);
        this.editItems[5] = new MenuItem("Delete");
        this.editMenu.add(this.editItems[5]);
        this.editItems[6] = new MenuItem("Select All");
        this.editMenu.add(this.editItems[6]);
        this.editMenu.addSeparator();
        this.editItems[7] = new MenuItem("Save");
        this.editMenu.add(this.editItems[7]);
        this.editItems[8] = new MenuItem("Append");
        this.editMenu.add(this.editItems[8]);
        this.editItems[9] = new MenuItem("Print");
        this.editMenu.add(this.editItems[9]);
        this.add(this.editMenu);
        int n3 = 0;
        while (n3 < this.editItems.length) {
            if (this.editItems[n3] != null) {
                this.editItems[n3].addActionListener(this);
            }
            ++n3;
        }
        this.requestFocus();
    }

    public String toString() {
        return this.name;
    }

    private synchronized void ensureSelStartBeforeSelEnd() {
        if (this.selEnd != null) {
            int n = this.selStart.compareTo(this.selEnd);
            if (n == 0) {
                this.selEnd = null;
                return;
            }
            if (n > 0) {
                AolRtfPos aolRtfPos = new AolRtfPos();
                aolRtfPos.copy(this.selStart);
                this.selStart.copy(this.selEnd);
                this.selEnd.copy(aolRtfPos);
            }
        }
    }

    private synchronized void appendMUI(MUI mUI) {
        this.insertMUI(mUI, null);
    }

    private synchronized void insertMUI(MUI mUI, MUI mUI2) {
        if (mUI == null) {
            return;
        }
        MUI mUI3 = mUI.startOfChain();
        MUI mUI4 = mUI.endOfChain();
        if (this.muiStart == mUI2) {
            this.muiStart = mUI3;
        }
        if (mUI2 == null) {
            MUI mUI5 = this.muiEnd;
            this.muiEnd = mUI4;
            if (mUI5 != null) {
                mUI5.next = mUI3;
                mUI3.prev = mUI5;
                return;
            }
        } else {
            if (mUI2.prev != null) {
                mUI2.prev.next = mUI3;
            }
            mUI3.prev = mUI2.prev;
            mUI4.next = mUI2;
            mUI2.prev = mUI4;
        }
    }

    private synchronized void removeMUI(MUI mUI) {
        if (this.muiStart == mUI) {
            this.muiStart = mUI.next;
        }
        if (this.muiEnd == mUI) {
            this.muiEnd = mUI.prev;
        }
        if (mUI.next != null) {
            mUI.next.prev = mUI.prev;
        }
        if (mUI.prev != null) {
            mUI.prev.next = mUI.next;
        }
    }

    public String getText() {
        AolRtfPos aolRtfPos = new AolRtfPos();
        aolRtfPos.mui = this.muiStart;
        aolRtfPos.c = aolRtfPos.mui.posBefore();
        AolRtfPos aolRtfPos2 = new AolRtfPos();
        aolRtfPos2.mui = this.muiEnd;
        aolRtfPos2.c = aolRtfPos2.mui.posAfter();
        return this.getText(aolRtfPos, aolRtfPos2);
    }

    private synchronized String getText(AolRtfPos aolRtfPos, AolRtfPos aolRtfPos2) {
        String string = "";
        if (aolRtfPos.mui == aolRtfPos2.mui) {
            MUI mUI = aolRtfPos.mui.muiBetween(aolRtfPos.c, aolRtfPos2.c);
            string = String.valueOf(string) + mUI.prettyName();
            return string;
        }
        MUI mUI = aolRtfPos.mui.muiAfter(aolRtfPos.c);
        if (mUI != null) {
            string = String.valueOf(string) + mUI.prettyName();
        }
        mUI = aolRtfPos.mui.next;
        while (mUI != aolRtfPos2.mui) {
            string = String.valueOf(string) + mUI.prettyName();
            mUI = mUI.next;
        }
        mUI = aolRtfPos2.mui.muiBefore(aolRtfPos2.c);
        if (mUI != null) {
            string = String.valueOf(string) + mUI.prettyName();
        }
        return string;
    }

    public String getTextAsHTML() {
        AolRtfPos aolRtfPos = new AolRtfPos();
        aolRtfPos.mui = this.muiStart;
        aolRtfPos.c = aolRtfPos.mui.posBefore();
        AolRtfPos aolRtfPos2 = new AolRtfPos();
        aolRtfPos2.mui = this.muiEnd;
        aolRtfPos2.c = aolRtfPos2.mui.posAfter();
        return this.getTextAsHTML(aolRtfPos, aolRtfPos2);
    }

    private synchronized String getTextAsHTML(AolRtfPos aolRtfPos, AolRtfPos aolRtfPos2) {
        Stack stack = new Stack();
        String string = "<HTML>";
        MUI mUI = null;
        if (aolRtfPos.mui == aolRtfPos2.mui) {
            MUI mUI2 = aolRtfPos.mui.muiBetween(aolRtfPos.c, aolRtfPos2.c);
            string = this.htmlizeMUI(string, mUI2, mUI, stack);
            mUI = aolRtfPos.mui;
        } else {
            MUI mUI3 = aolRtfPos.mui.muiAfter(aolRtfPos.c);
            if (mUI3 != null) {
                string = this.htmlizeMUI(string, mUI3, mUI, stack);
                mUI = aolRtfPos.mui;
            }
            mUI3 = aolRtfPos.mui.next;
            while (mUI3 != aolRtfPos2.mui) {
                string = this.htmlizeMUI(string, mUI3, mUI, stack);
                mUI = mUI3;
                mUI3 = mUI3.next;
            }
            mUI3 = aolRtfPos2.mui.muiBefore(aolRtfPos2.c);
            if (mUI3 != null) {
                string = this.htmlizeMUI(string, mUI3, mUI, stack);
                mUI = mUI3;
            }
        }
        if (mUI != null && !mUI.isBreak() && mUI.url == null) {
            string = this.turnOffCurrentHTMLStyles(string, stack);
            string = String.valueOf(string) + "</FONT>";
        }
        string = String.valueOf(string) + "</HTML>";
        return string;
    }

    private synchronized String htmlizeMUI(String string, MUI mUI, MUI mUI2, Stack stack) {
        if (mUI2 == null || !mUI2.f.name.equals(mUI.f.name) || mUI2.f.size != mUI.f.size || mUI2.fgColor != mUI.fgColor || mUI2.bgColor != mUI.bgColor) {
            if (mUI2 != null && !mUI2.isBreak() && mUI2.url == null) {
                string = this.turnOffCurrentHTMLStyles(string, stack);
                string = String.valueOf(string) + "</FONT>";
            }
            if (mUI.url == null) {
                string = String.valueOf(string) + "<FONT COLOR=\"#" + this.HTMLColor(mUI.fgColor.getRGB()) + "\" BACK=\"#" + this.HTMLColor(mUI.bgColor.getRGB()) + "\" SIZE=" + this.getHtmlSize(mUI.f.size) + ">";
                string = this.turnOnNewHTMLStyles(string, mUI.f.style, stack);
            }
        } else if (mUI2.f.style != mUI.f.style) {
            if (mUI2 != null && !mUI2.isBreak() && mUI2.url == null) {
                string = this.turnOffCurrentHTMLStyles(string, stack);
            }
            if (!mUI.isBreak() && mUI.url == null) {
                string = this.turnOnNewHTMLStyles(string, mUI.f.style, stack);
            }
        }
        string = String.valueOf(string) + mUI.htmlName();
        return string;
    }

    private synchronized String turnOffCurrentHTMLStyles(String string, Stack stack) {
        while (!stack.empty()) {
            String string2 = (String)stack.pop();
            string = String.valueOf(string) + string2;
        }
        return string;
    }

    private synchronized String turnOnNewHTMLStyles(String string, int n, Stack stack) {
        String string2 = "";
        String string3 = "";
        if ((n & FontInfo.BOLD) != 0) {
            string2 = String.valueOf(string2) + "<B>";
            string3 = String.valueOf(string3) + "</B>";
        }
        if ((n & FontInfo.ITALIC) != 0) {
            string2 = String.valueOf(string2) + "<I>";
            string3 = String.valueOf(string3) + "</I>";
        }
        if ((n & FontInfo.UNDERLINE) != 0) {
            string2 = String.valueOf(string2) + "<U>";
            string3 = String.valueOf(string3) + "</U>";
        }
        string = String.valueOf(string) + string2;
        stack.push(string3);
        return string;
    }

    public void setText(String string) {
        this.muiStart = null;
        this.muiEnd = null;
        this.appendText(string);
    }

    public void appendText(String string) {
        this.appendMUI(new MUI(string, defFont, defFG, defBG));
        this.selStart.mui = this.muiEnd;
        this.selStart.c = this.selStart.mui.posAfter();
        this.selEnd = null;
        this.scrollTo(this.selStart.mui);
        this.repaint();
    }

    private synchronized MUI concatMUI(MUI mUI, MUI mUI2) {
        if (mUI != null) {
            mUI.next = mUI2;
            mUI2.prev = mUI;
        }
        return mUI2;
    }

    public void setHTML(String string) {
        this.muiStart = null;
        this.muiEnd = null;
        this.appendHTML(string);
    }

    public void appendHTML(String string) {
        Log.log(MODULE, Log.DB0, String.valueOf(this.name) + " in appendHTML '" + string + "'");
        MUI mUI = this.HTMLToMUI(string);
        if (mUI == null && this.muiStart == null && this.muiEnd == null) {
            mUI = new MUI("", defFont, defFG, defBG);
        }
        this.appendMUI(mUI);
        this.selStart.mui = this.muiEnd;
        this.selStart.c = this.selStart.mui.posAfter();
        this.selEnd = null;
        this.scrollTo(this.selStart.mui);
        this.repaint();
    }

    private synchronized MUI HTMLToMUI(String string) {
        AolRtfTokenizer aolRtfTokenizer = new AolRtfTokenizer(string);
        String string2 = "";
        FontInfo fontInfo = defFont;
        Color color = defFG;
        Color color2 = defBG;
        String string3 = null;
        Stack<MUI> stack = new Stack<MUI>();
        MUI mUI = null;
        while (true) {
            boolean bl = aolRtfTokenizer.nextToken();
            if (aolRtfTokenizer.whiteSpace != null) {
                string2 = String.valueOf(string2) + aolRtfTokenizer.whiteSpace;
            }
            if (aolRtfTokenizer.word != null) {
                string2 = String.valueOf(string2) + aolRtfTokenizer.word;
            } else if (aolRtfTokenizer.html != null) {
                if (aolRtfTokenizer.html.key.equals("HTML") || aolRtfTokenizer.html.key.equals("/HTML") || aolRtfTokenizer.html.key.equals("PRE") || aolRtfTokenizer.html.key.equals("/PRE") || aolRtfTokenizer.html.key.equals("S") || aolRtfTokenizer.html.key.equals("/S") || aolRtfTokenizer.html.key.equals("SUB") || aolRtfTokenizer.html.key.equals("/SUB") || aolRtfTokenizer.html.key.equals("SUP") || aolRtfTokenizer.html.key.equals("/SUP") || aolRtfTokenizer.html.key.equals("P") || aolRtfTokenizer.html.key.equals("/P") || aolRtfTokenizer.html.key.equals("EMBED") || aolRtfTokenizer.html.key.equals("/EMBED") || aolRtfTokenizer.html.key.equals("BINARY") || aolRtfTokenizer.html.key.equals("/BINARY") || aolRtfTokenizer.html.key.equals("DATA") || aolRtfTokenizer.html.key.equals("/DATA")) continue;
                if (string2.length() > 0) {
                    if (string3 != null) {
                        mUI = this.concatMUI(mUI, new MUI(string2, string3));
                        string3 = null;
                    } else {
                        mUI = this.concatMUI(mUI, new MUI(string2, fontInfo, color, color2));
                    }
                    string2 = "";
                }
                if (aolRtfTokenizer.html.key.equals("BIG")) {
                    int n = this.getHtmlSize(fontInfo.size);
                    if (n < 7) {
                        ++n;
                    }
                    stack.push(new MUI("", fontInfo, color, color2));
                    fontInfo = this.getFontInfoByIndex(fontInfo.name, fontInfo.style, n);
                } else if (aolRtfTokenizer.html.key.equals("SMALL")) {
                    int n = this.getHtmlSize(fontInfo.size);
                    if (n > 1) {
                        --n;
                    }
                    stack.push(new MUI("", fontInfo, color, color2));
                    fontInfo = this.getFontInfoByIndex(fontInfo.name, fontInfo.style, n);
                } else if (aolRtfTokenizer.html.key.equals("/BIG") || aolRtfTokenizer.html.key.equals("/SMALL")) {
                    MUI mUI2 = (MUI)stack.pop();
                    fontInfo = mUI2.f;
                    color = mUI2.fgColor;
                    color2 = mUI2.bgColor;
                } else if (aolRtfTokenizer.html.key.equals("H1")) {
                    mUI = this.concatMUI(mUI, new MUI("<BR>"));
                    stack.push(new MUI("", fontInfo, color, color2));
                    fontInfo = this.getFontInfoByIndex(AolRtf.defFont.name, FontInfo.BOLD, 6);
                } else if (aolRtfTokenizer.html.key.equals("H2")) {
                    mUI = this.concatMUI(mUI, new MUI("<BR>"));
                    stack.push(new MUI("", fontInfo, color, color2));
                    fontInfo = this.getFontInfoByIndex(AolRtf.defFont.name, FontInfo.BOLD, 5);
                } else if (aolRtfTokenizer.html.key.equals("H3")) {
                    mUI = this.concatMUI(mUI, new MUI("<BR>"));
                    stack.push(new MUI("", fontInfo, color, color2));
                    fontInfo = this.getFontInfoByIndex(AolRtf.defFont.name, FontInfo.BOLD, 4);
                } else if (aolRtfTokenizer.html.key.equals("/H1") || aolRtfTokenizer.html.key.equals("/H2") || aolRtfTokenizer.html.key.equals("/H3")) {
                    mUI = this.concatMUI(mUI, new MUI("<BR>"));
                    MUI mUI3 = (MUI)stack.pop();
                    fontInfo = mUI3.f;
                    color = mUI3.fgColor;
                    color2 = mUI3.bgColor;
                } else if (aolRtfTokenizer.html.key.equals("FONT")) {
                    int n;
                    int n2;
                    String string4;
                    String string5;
                    block53: {
                        String string6 = aolRtfTokenizer.html.getValue("color");
                        String string7 = aolRtfTokenizer.html.getValue("back");
                        string5 = aolRtfTokenizer.html.getValue("size");
                        string4 = aolRtfTokenizer.html.getValue("ptSize");
                        n2 = 0;
                        n = 0;
                        stack.push(new MUI("", fontInfo, color, color2));
                        try {
                            if (string6 != null) {
                                color = this.parseHTMLColor(string6);
                            }
                            if (string7 != null) {
                                color2 = this.parseHTMLColor(string7);
                            }
                            if (string5 != null) {
                                n2 = this.parseInt(string5);
                            }
                            if (string4 == null) break block53;
                            n = this.parseInt(string4);
                        }
                        catch (NumberFormatException numberFormatException) {
                            ErrorMgr.diag("ParseHtml", "can't parse " + aolRtfTokenizer.html);
                            continue;
                        }
                    }
                    fontInfo = string5 != null ? this.getFontInfoByIndex(fontInfo.name, FontInfo.PLAIN, n2) : (string4 != null ? this.getFontInfoByPt(fontInfo.name, FontInfo.PLAIN, n) : this.getFontInfoByPt(fontInfo.name, FontInfo.PLAIN, fontInfo.size));
                } else if (aolRtfTokenizer.html.key.equals("/FONT")) {
                    MUI mUI4 = (MUI)stack.pop();
                    fontInfo = mUI4.f;
                    color = mUI4.fgColor;
                    color2 = mUI4.bgColor;
                } else if (aolRtfTokenizer.html.key.equals("BODY")) {
                    String string8 = aolRtfTokenizer.html.getValue("bgcolor");
                    aolRtfTokenizer.html.getValue("link");
                    aolRtfTokenizer.html.getValue("vlink");
                    aolRtfTokenizer.html.getValue("background");
                    if (string8 != null) {
                        this.fooColor = this.parseHTMLColor(string8);
                    }
                } else if (!aolRtfTokenizer.html.key.equals("/BODY")) {
                    if (aolRtfTokenizer.html.key.equals("B")) {
                        stack.push(new MUI("", fontInfo, color, color2));
                        fontInfo = this.getFontInfoByPt(fontInfo.name, fontInfo.style | FontInfo.BOLD, fontInfo.size);
                    } else if (aolRtfTokenizer.html.key.equals("U")) {
                        stack.push(new MUI("", fontInfo, color, color2));
                        fontInfo = this.getFontInfoByPt(fontInfo.name, fontInfo.style | FontInfo.UNDERLINE, fontInfo.size);
                    } else if (aolRtfTokenizer.html.key.equals("I")) {
                        stack.push(new MUI("", fontInfo, color, color2));
                        fontInfo = this.getFontInfoByPt(fontInfo.name, fontInfo.style | FontInfo.ITALIC, fontInfo.size);
                    } else if (aolRtfTokenizer.html.key.equals("/B") || aolRtfTokenizer.html.key.equals("/U") || aolRtfTokenizer.html.key.equals("/I")) {
                        MUI mUI5 = (MUI)stack.pop();
                        fontInfo = mUI5.f;
                        color = mUI5.fgColor;
                        color2 = mUI5.bgColor;
                    } else if (!aolRtfTokenizer.html.key.equals("XMP") && !aolRtfTokenizer.html.key.equals("/XMP")) {
                        if (aolRtfTokenizer.html.key.equals("A")) {
                            string3 = aolRtfTokenizer.html.getValue("href");
                        } else if (!aolRtfTokenizer.html.key.equals("/A") && aolRtfTokenizer.html.key.equals("BR")) {
                            mUI = this.concatMUI(mUI, new MUI("<BR>"));
                        }
                    }
                }
            }
            if (!bl) break;
        }
        if (string2.length() > 0) {
            if (string3 != null) {
                mUI = this.concatMUI(mUI, new MUI(string2, string3));
                string3 = null;
            } else {
                mUI = this.concatMUI(mUI, new MUI(string2, fontInfo, color, color2));
            }
            string2 = "";
        }
        if (mUI == null) {
            return null;
        }
        return mUI.startOfChain();
    }

    private synchronized int parseInt(String string) throws NumberFormatException {
        if (string.length() > 0 && string.charAt(0) == '#') {
            String string2 = string.substring(1, string.length());
            return Integer.parseInt(string2, 16);
        }
        return Integer.parseInt(string);
    }

    private synchronized String HTMLColor(int n) {
        String string = Integer.toHexString(n & 0xFFFFFF);
        while (string.length() < 6) {
            string = "0" + string;
        }
        return string;
    }

    private synchronized Color parseHTMLColor(String string) {
        int n;
        int n2 = 0;
        if (string.charAt(n2) == '#') {
            ++n2;
        }
        if ((n = string.length() - n2) >= 4) {
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = (Math.min(n, 12) + 2) / 3;
            int n7 = 0;
            while (n2 < string.length() && n7 < n6) {
                n3 |= JUtil.hexVal(string.charAt(n2++)) << (n6 - 1 - n7) * 4;
                ++n7;
            }
            n7 = 0;
            while (n2 < string.length() && n7 < n6) {
                n4 |= JUtil.hexVal(string.charAt(n2++)) << (n6 - 1 - n7) * 4;
                ++n7;
            }
            n7 = 0;
            while (n2 < string.length() && n7 < n6) {
                n5 |= JUtil.hexVal(string.charAt(n2++)) << (n6 - 1 - n7) * 4;
                ++n7;
            }
            int n8 = (n6 - 2) * 4;
            return new Color(n3 >> n8, n4 >> n8, n5 >> n8);
        }
        return Color.black;
    }

    private synchronized int getHtmlSize(int n) {
        int n2 = 1;
        while (n2 < fontSizeMap.length) {
            if (fontSizeMap[n2] >= n) {
                return n2;
            }
            ++n2;
        }
        return 7;
    }

    private synchronized FontInfo getFontInfoByIndex(String string, int n, int n2) {
        if (n2 < 1) {
            n2 = 1;
        }
        if (n2 > 7) {
            n2 = 7;
        }
        return this.getFontInfoByPt(string, n, fontSizeMap[n2]);
    }

    private synchronized FontInfo getFontInfoByPt(String string, int n, int n2) {
        String string2 = String.valueOf(string) + "/" + n + "/" + n2;
        FontInfo fontInfo = (FontInfo)fontCache.get(string2);
        if (fontInfo == null) {
            Font font = new Font(string, n, n2);
            FontMetrics fontMetrics = this.getFontMetrics(font);
            fontInfo = new FontInfo(string, n, n2, font, fontMetrics);
            fontCache.put(string2, fontInfo);
        }
        return fontInfo;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.repaint();
    }

    private final synchronized void redraw() {
        this.redraw(this.muiStart, true, null, null);
        MUI mUI = this.scrollToMUI;
        if (mUI == null) {
            return;
        }
        if (this.sb != null) {
            if (mUI.lineTop < this.sb.getValue()) {
                this.sb.setValue(mUI.lineTop);
                return;
            }
            if (mUI.lineBottom > this.sb.getValue() + this.sb.getVisibleAmount()) {
                this.sb.setValue(mUI.lineBottom - this.sb.getVisibleAmount());
            }
        }
    }

    private final synchronized void redraw(MUI mUI, boolean bl, Dimension dimension, Graphics graphics) {
        this.initFonts();
        if (dimension == null) {
            dimension = this.getSize();
        }
        mUI = this.assignLines(dimension.width, mUI, true);
        this.assignXY(this.muiStart, true);
        if (graphics == null && this.sb != null) {
            this.sb.setValues(this.sb.getValue(), Math.max(1, dimension.height), 0, this.totalHeight);
        }
        this.selStart.update();
        if (this.selEnd != null) {
            this.selEnd.update();
        }
        this.ensureSelStartBeforeSelEnd();
        if (graphics == null) {
            if (this.offScreenBM == null || this.offScreenHeight < this.totalHeight || this.offScreenWidth < this.totalWidth || this.offScreenHeight < dimension.height || this.offScreenWidth < dimension.width) {
                this.offScreenHeight = Math.max(this.offScreenHeight, this.totalHeight);
                this.offScreenWidth = Math.max(this.offScreenWidth, this.totalWidth);
                this.offScreenHeight = Math.max(this.offScreenHeight, dimension.height);
                this.offScreenWidth = Math.max(this.offScreenWidth, dimension.width);
                this.offScreenHeight = Math.max(this.offScreenHeight, 1);
                this.offScreenWidth = Math.max(this.offScreenWidth, 1);
                this.offScreenBM = this.createImage(this.offScreenWidth, this.offScreenHeight);
                if (this.offScreenBM == null) {
                    return;
                }
                graphics = this.offScreenBM.getGraphics();
            } else {
                graphics = this.offScreenBM.getGraphics();
            }
        }
        graphics.setColor(this.fooColor);
        graphics.fillRect(0, 0, this.offScreenWidth, this.offScreenHeight);
        if (this.verboseRedraw) {
            AolRtf.dbg(lb, "before draw-----");
            this.printMUIs(mUI);
            AolRtf.dbg(lb, "-----");
        }
        MUI mUI2 = mUI;
        try {
            boolean bl2 = false;
            while (mUI2 != null) {
                int n;
                if (this.verboseRedraw) {
                    System.out.println("> " + mUI2);
                }
                if (mUI2.isHidden || mUI2.isBreak()) {
                    mUI2 = mUI2.next;
                    continue;
                }
                int n2 = mUI2.lineTop + mUI2.lineHeight - mUI2.lineDescent;
                graphics.setFont(mUI2.f.font);
                if (mUI2.bgColor != null && mUI2.bgColor != defBG) {
                    graphics.setColor(mUI2.bgColor);
                    graphics.fillRect(mUI2.x, n2 + mUI2.descent - mUI2.height, mUI2.width, mUI2.height);
                }
                graphics.setColor(mUI2.fgColor);
                graphics.drawString(mUI2.data, mUI2.x, n2);
                if ((mUI2.f.style & FontInfo.UNDERLINE) != 0) {
                    graphics.drawLine(mUI2.x, n2 + 2, mUI2.x + mUI2.width, n2 + 2);
                }
                graphics.setColor(Color.red);
                if (this.selStart.mui == mUI2 && this.selEnd != null && this.selEnd.mui == mUI2) {
                    n = this.drawMUISegment(mUI2, -1, this.selStart.c, false, mUI2.x, n2, graphics);
                    n = this.drawMUISegment(mUI2, this.selStart.c, this.selEnd.c, true, n, n2, graphics);
                    this.drawMUISegment(mUI2, this.selEnd.c, mUI2.length(), false, n, n2, graphics);
                } else if (this.selStart.mui == mUI2 && this.selEnd != null && this.selEnd.mui != mUI2) {
                    n = this.drawMUISegment(mUI2, -1, this.selStart.c, false, mUI2.x, n2, graphics);
                    this.drawMUISegment(mUI2, this.selStart.c, mUI2.length(), true, n, n2, graphics);
                    bl2 = true;
                } else if (bl2 && this.selEnd != null && this.selEnd.mui == mUI2) {
                    n = this.drawMUISegment(mUI2, -1, this.selEnd.c, true, mUI2.x, n2, graphics);
                    this.drawMUISegment(mUI2, this.selEnd.c, mUI2.length(), false, n, n2, graphics);
                    bl2 = false;
                } else if (bl2 && this.selEnd != null && this.selEnd.mui != mUI2) {
                    this.drawText(mUI2.data, mUI2.bgColor, mUI2.fgColor, mUI2.x, n2, graphics, mUI2.width, mUI2.height, mUI2.descent, mUI2.f.font, mUI2.f.style);
                } else {
                    this.drawText(mUI2.data, mUI2.fgColor, mUI2.bgColor, mUI2.x, n2, graphics, mUI2.width, mUI2.height, mUI2.descent, mUI2.f.font, mUI2.f.style);
                }
                n2 += mUI2.lineDescent;
                mUI2 = mUI2.next;
            }
            mUI2 = this.selStart.mui;
            this.entireSelectionUnderlined = true;
            this.entireSelectionItalic = true;
            this.entireSelectionBold = true;
            while (mUI2 != null) {
                if ((mUI2.f.style & FontInfo.UNDERLINE) == 0) {
                    this.entireSelectionUnderlined = false;
                }
                if ((mUI2.f.style & FontInfo.ITALIC) == 0) {
                    this.entireSelectionItalic = false;
                }
                if ((mUI2.f.style & FontInfo.BOLD) == 0) {
                    this.entireSelectionBold = false;
                }
                if (this.selEnd == null || mUI2 == this.selEnd.mui) break;
                mUI2 = mUI2.next;
            }
            if (this.listener != null) {
                this.listener.styleUpdate();
                return;
            }
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("got exception " + nullPointerException);
            System.out.println("m = " + mUI2);
            nullPointerException.printStackTrace();
        }
    }

    private final synchronized int drawMUISegment(MUI mUI, int n, int n2, boolean bl, int n3, int n4, Graphics graphics) {
        if (mUI.data == null || ++n >= mUI.length() || n >= ++n2) {
            return n3;
        }
        if (n2 > mUI.length()) {
            n2 = mUI.length();
        }
        String string = mUI.data.substring(n, n2);
        int n5 = mUI.f.metrics.stringWidth(string);
        if (bl) {
            return this.drawText(string, mUI.bgColor, mUI.fgColor, n3, n4, graphics, n5, mUI.height, mUI.descent, mUI.f.font, mUI.f.style);
        }
        return this.drawText(string, mUI.fgColor, mUI.bgColor, n3, n4, graphics, n5, mUI.height, mUI.descent, mUI.f.font, mUI.f.style);
    }

    private final int drawText(String string, Color color, Color color2, int n, int n2, Graphics graphics, int n3, int n4, int n5, Font font, int n6) {
        graphics.setFont(font);
        if (color2 != defBG) {
            graphics.setColor(color2);
            graphics.fillRect(n, n2 + n5 - n4, n3, n4);
        }
        graphics.setColor(color);
        graphics.drawString(string, n, n2);
        if ((n6 & FontInfo.UNDERLINE) != 0) {
            graphics.drawLine(n, n2 + 2, n + n3, n2 + 2);
        }
        return n + n3;
    }

    private synchronized void printMUIs(MUI mUI) {
        if (mUI == null) {
            return;
        }
        int n = mUI.lineNo;
        String string = "";
        while (true) {
            if (mUI == null || mUI.lineNo != n) {
                System.out.println(String.valueOf(n) + " " + string);
            }
            if (mUI == null) {
                return;
            }
            if (mUI.lineNo != n) {
                string = "";
                n = mUI.lineNo;
            }
            string = String.valueOf(string) + mUI.name() + " ";
            mUI = mUI.next;
        }
    }

    private final synchronized void assignXY(MUI mUI, boolean bl) {
        if (mUI == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        MUI mUI2 = mUI;
        int n3 = mUI2.lineNo;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        MUI mUI3 = mUI2;
        while (true) {
            if (mUI2 == null || mUI2.lineNo != n3) {
                MUI mUI4 = mUI3;
                int n7 = n + n4;
                while (mUI4 != mUI2) {
                    mUI4.lineHeight = n4;
                    mUI4.lineDescent = n5;
                    mUI4.lineTop = n;
                    mUI4.lineBottom = n7;
                    mUI4 = mUI4.next;
                }
                n += n4;
                n2 = Math.max(n2, n6);
                if (mUI2 == null) break;
                n3 = mUI2.lineNo;
                mUI2.x = 0;
                n4 = mUI2.height;
                n5 = mUI2.descent;
                n6 = mUI2.width;
                mUI3 = mUI2;
            } else {
                mUI2.x = n6;
                n4 = Math.max(n4, mUI2.height);
                n5 = Math.max(n5, mUI2.descent);
                n6 += mUI2.width;
            }
            mUI2 = mUI2.next;
        }
        this.totalHeight = n;
        this.totalWidth = n2;
    }

    public synchronized Dimension getBoundingBox(int n) {
        this.assignLines(n, this.muiStart, true);
        this.assignXY(this.muiStart, true);
        return new Dimension(this.totalWidth, this.totalHeight);
    }

    private final synchronized MUI assignLines(int n, MUI mUI, boolean bl) {
        int n2 = 0;
        int n3 = 0;
        MUI mUI2 = mUI;
        while (mUI2 != null) {
            Cloneable cloneable;
            if (mUI2.isBreak()) {
                mUI2.lineNo = n3++;
                n2 = 0;
                mUI2 = mUI2.next;
                continue;
            }
            if (mUI2.data != null && mUI2.data.equals("") && (mUI2 != this.muiEnd || mUI2.prev != null && !mUI2.prev.isBreak())) {
                if (mUI2.next != null) {
                    if (this.selStart.mui == mUI2) {
                        this.selStart.mui = mUI2.next;
                        this.selStart.c = this.selStart.mui.posBefore();
                    }
                    if (this.selEnd != null && this.selEnd.mui == mUI2) {
                        this.selEnd.mui = mUI2.next;
                        this.selEnd.c = this.selEnd.mui.posBefore();
                    }
                    if (mUI == mUI2) {
                        mUI = mUI2.next;
                    }
                } else if (mUI2.prev != null) {
                    if (this.selStart.mui == mUI2) {
                        this.selStart.mui = mUI2.prev;
                        this.selStart.c = this.selStart.mui.posAfter();
                    }
                    if (this.selEnd != null && this.selEnd.mui == mUI2) {
                        this.selEnd.mui = mUI2.prev;
                        this.selEnd.c = this.selEnd.mui.posAfter();
                    }
                    if (mUI == mUI2) {
                        mUI = mUI2.prev;
                    }
                } else {
                    ErrorMgr.error(MODULE, "selection invalid, internal error");
                }
                cloneable = mUI2;
                mUI2 = mUI2.next;
                this.removeMUI((MUI)cloneable);
                ((MUI)cloneable).flush();
                continue;
            }
            if (n2 + mUI2.width < n) {
                mUI2.isHidden = false;
                mUI2.lineNo = n3;
                n2 += mUI2.width;
                mUI2 = mUI2.next;
                continue;
            }
            if (mUI2.isAllWS()) {
                mUI2.isHidden = true;
                mUI2.lineNo = n3;
                mUI2 = mUI2.next;
                continue;
            }
            cloneable = mUI2.split();
            if (cloneable == null || ((Vector)cloneable).size() < 2) {
                mUI2.isHidden = false;
                mUI2.lineNo = ++n3;
                n2 = mUI2.width;
                mUI2 = mUI2.next;
                continue;
            }
            if (mUI == mUI2) {
                mUI = (MUI)((Vector)cloneable).firstElement();
            }
            this.insertMUI((MUI)((Vector)cloneable).firstElement(), mUI2);
            this.removeMUI(mUI2);
            mUI2.flush();
            if (this.selStart.mui == mUI2) {
                this.updateSplitSelection(this.selStart, (Vector)cloneable);
            }
            if (this.selEnd != null && this.selEnd.mui == mUI2) {
                this.updateSplitSelection(this.selEnd, (Vector)cloneable);
            }
            mUI2 = (MUI)((Vector)cloneable).firstElement();
        }
        return mUI;
    }

    public void doLayout() {
        super.doLayout();
        this.redraw();
    }

    private synchronized void updateSplitSelection(AolRtfPos aolRtfPos, Vector vector) {
        int n = 0;
        int n2 = 0;
        while (n2 < vector.size()) {
            MUI mUI = (MUI)vector.elementAt(n2);
            int n3 = 0;
            while (n3 < mUI.length()) {
                if (n == aolRtfPos.c) {
                    aolRtfPos.mui = mUI;
                    aolRtfPos.c = n3;
                } else {
                    ++n;
                }
                ++n3;
            }
            ++n2;
        }
    }

    private synchronized void nextCharacter(AolRtfPos aolRtfPos) {
        if (!aolRtfPos.mui.posIsAfter(aolRtfPos.c)) {
            ++aolRtfPos.c;
        } else if (aolRtfPos.mui.next != null) {
            aolRtfPos.c = aolRtfPos.mui.lineNo != aolRtfPos.mui.next.lineNo ? aolRtfPos.mui.posBefore() : 0;
            aolRtfPos.mui = aolRtfPos.mui.next;
        }
        if (aolRtfPos.mui.isBreak() && aolRtfPos.mui.posIsAfter(aolRtfPos.c) && aolRtfPos.mui.next != null) {
            this.nextCharacter(aolRtfPos);
            return;
        }
        aolRtfPos.update();
    }

    private synchronized void prevCharacter(AolRtfPos aolRtfPos) {
        if (aolRtfPos.c > 0) {
            --aolRtfPos.c;
        } else if (aolRtfPos.mui.posIsBefore(aolRtfPos.c)) {
            if (aolRtfPos.mui.prev != null) {
                aolRtfPos.mui = aolRtfPos.mui.prev;
                if (aolRtfPos.mui.isBreak()) {
                    aolRtfPos.c = 0;
                    this.lastNonBreakOnThisLine(aolRtfPos);
                } else {
                    aolRtfPos.c = aolRtfPos.mui.posAfter();
                }
            }
        } else if (aolRtfPos.mui.prev == null || aolRtfPos.mui.lineNo != aolRtfPos.mui.prev.lineNo) {
            aolRtfPos.c = aolRtfPos.mui.posBefore();
        } else {
            aolRtfPos.mui = aolRtfPos.mui.prev;
            aolRtfPos.c = aolRtfPos.mui.posAfter();
        }
        aolRtfPos.update();
    }

    private synchronized void lastNonBreakOnThisLine(AolRtfPos aolRtfPos) {
        while (aolRtfPos.mui.isBreak() && !aolRtfPos.mui.posIsBefore(aolRtfPos.c)) {
            this.prevCharacter(aolRtfPos);
        }
    }

    private synchronized void lineStart(AolRtfPos aolRtfPos) {
        while (aolRtfPos.mui.prev != null && aolRtfPos.mui.prev.lineNo == aolRtfPos.mui.lineNo) {
            aolRtfPos.mui = aolRtfPos.mui.prev;
        }
        aolRtfPos.c = aolRtfPos.mui.posBefore();
        aolRtfPos.update();
    }

    private synchronized void lineEnd(AolRtfPos aolRtfPos) {
        while (aolRtfPos.mui.next != null && aolRtfPos.mui.next.lineNo == aolRtfPos.mui.lineNo) {
            aolRtfPos.mui = aolRtfPos.mui.next;
        }
        aolRtfPos.c = aolRtfPos.mui.posAfter();
        aolRtfPos.update();
    }

    private synchronized void startOfNextLine(AolRtfPos aolRtfPos) {
        this.lineEnd(aolRtfPos);
        if (aolRtfPos.mui.next != null) {
            aolRtfPos.mui = aolRtfPos.mui.next;
            aolRtfPos.c = aolRtfPos.mui.posBefore();
        }
        aolRtfPos.update();
    }

    private synchronized void endOfPrevLine(AolRtfPos aolRtfPos) {
        this.lineStart(aolRtfPos);
        if (aolRtfPos.mui.prev != null) {
            aolRtfPos.mui = aolRtfPos.mui.prev;
            aolRtfPos.c = aolRtfPos.mui.posAfter();
        }
        aolRtfPos.update();
    }

    private synchronized void sameXNextLine(AolRtfPos aolRtfPos) {
        int n = aolRtfPos.x;
        this.startOfNextLine(aolRtfPos);
        aolRtfPos.copy(this.getPos(n, aolRtfPos.mui.lineTop));
    }

    private synchronized void sameXPrevLine(AolRtfPos aolRtfPos) {
        int n = aolRtfPos.x;
        this.endOfPrevLine(aolRtfPos);
        aolRtfPos.copy(this.getPos(n, aolRtfPos.mui.lineTop));
    }

    private synchronized void normalize(AolRtfPos aolRtfPos, boolean bl) {
        if (bl && aolRtfPos.mui.posIsAfter(aolRtfPos.c) && aolRtfPos.mui.next != null) {
            aolRtfPos.mui = aolRtfPos.mui.next;
            aolRtfPos.c = aolRtfPos.mui.posBefore();
            return;
        }
        if (!bl && aolRtfPos.mui.posIsBefore(aolRtfPos.c) && aolRtfPos.mui.prev != null) {
            aolRtfPos.mui = aolRtfPos.mui.prev;
            aolRtfPos.c = aolRtfPos.mui.posAfter();
        }
    }

    private synchronized boolean chopSelection() {
        if (this.selEnd == null || this.selEnd.compareTo(this.selStart) == 0) {
            return false;
        }
        this.normalize(this.selStart, true);
        this.normalize(this.selEnd, false);
        if (this.selStart.mui.posIsBefore(this.selStart.c) && this.selEnd.mui.posIsAfter(this.selEnd.c)) {
            return true;
        }
        if (this.selStart.mui == this.selEnd.mui) {
            MUI mUI = this.selStart.mui.muiBefore(this.selStart.c);
            MUI mUI2 = this.selStart.mui.muiBetween(this.selStart.c, this.selEnd.c);
            MUI mUI3 = this.selEnd.mui.muiAfter(this.selEnd.c);
            this.insertMUI(mUI, this.selStart.mui);
            this.insertMUI(mUI2, this.selStart.mui);
            this.insertMUI(mUI3, this.selStart.mui);
            this.removeMUI(this.selStart.mui);
            this.selStart.mui.flush();
            this.selStart.mui = mUI2;
            this.selStart.c = this.selStart.mui.posBefore();
            this.selEnd.mui = mUI2;
            this.selEnd.c = this.selEnd.mui.posAfter();
        } else {
            MUI mUI = this.selStart.mui.muiBefore(this.selStart.c);
            MUI mUI4 = this.selStart.mui.muiAfter(this.selStart.c);
            this.insertMUI(mUI, this.selStart.mui);
            this.insertMUI(mUI4, this.selStart.mui);
            this.removeMUI(this.selStart.mui);
            MUI mUI5 = this.selStart.mui;
            this.selStart.mui = mUI4;
            this.selStart.c = this.selStart.mui.posBefore();
            mUI5.flush();
            mUI = this.selEnd.mui.muiBefore(this.selEnd.c);
            mUI4 = this.selEnd.mui.muiAfter(this.selEnd.c);
            this.insertMUI(mUI, this.selEnd.mui);
            this.insertMUI(mUI4, this.selEnd.mui);
            this.removeMUI(this.selEnd.mui);
            mUI5 = this.selEnd.mui;
            this.selEnd.mui = mUI;
            this.selEnd.c = this.selEnd.mui.posAfter();
            mUI5.flush();
        }
        return true;
    }

    public void setFG(Color color) {
        if (!this.chopSelection()) {
            return;
        }
        MUI mUI = this.selStart.mui;
        while (mUI != null) {
            mUI.fgColor = color;
            if (mUI == this.selEnd.mui) break;
            mUI = mUI.next;
        }
        this.repaint();
    }

    public void setBG(Color color) {
        if (!this.chopSelection()) {
            return;
        }
        MUI mUI = this.selStart.mui;
        while (mUI != null) {
            mUI.bgColor = color;
            if (mUI == this.selEnd.mui) break;
            mUI = mUI.next;
        }
        this.repaint();
    }

    public void setWindowColor(Color color) {
        this.fooColor = color;
        this.repaint();
    }

    public void setStyle(char c, boolean bl) {
        if (!this.chopSelection()) {
            return;
        }
        MUI mUI = this.selStart.mui;
        int n = 0;
        if (c == 'u') {
            n = FontInfo.UNDERLINE;
        } else if (c == 'i') {
            n = FontInfo.ITALIC;
        } else if (c == 'b') {
            n = FontInfo.BOLD;
        }
        if (!bl) {
            n ^= 0xFFFFFFFF;
        }
        while (mUI != null) {
            int n2 = mUI.f.style;
            n2 = bl ? (n2 |= n) : (n2 &= n);
            mUI.f = this.getFontInfoByPt(mUI.f.name, n2, mUI.f.size);
            mUI.recalc();
            if (mUI == this.selEnd.mui) break;
            mUI = mUI.next;
        }
        this.repaint();
    }

    public boolean selectionIsInStyle(char c) {
        if (c == 'u') {
            return this.entireSelectionUnderlined;
        }
        if (c == 'i') {
            return this.entireSelectionItalic;
        }
        if (c == 'b') {
            return this.entireSelectionBold;
        }
        return false;
    }

    public void enlargeFont() {
        if (!this.chopSelection()) {
            return;
        }
        int n = Integer.MAX_VALUE;
        MUI mUI = this.selStart.mui;
        while (mUI != null) {
            n = Math.min(n, mUI.f.size);
            if (mUI == this.selEnd.mui) break;
            mUI = mUI.next;
        }
        int n2 = this.getHtmlSize(n) + 1;
        mUI = this.selStart.mui;
        while (mUI != null) {
            mUI.f = this.getFontInfoByIndex(mUI.f.name, mUI.f.style, n2);
            mUI.recalc();
            if (mUI == this.selEnd.mui) break;
            mUI = mUI.next;
        }
        this.repaint();
    }

    public void shrinkFont() {
        if (!this.chopSelection()) {
            return;
        }
        int n = Integer.MAX_VALUE;
        MUI mUI = this.selStart.mui;
        while (mUI != null) {
            n = Math.min(n, mUI.f.size);
            if (mUI == this.selEnd.mui) break;
            mUI = mUI.next;
        }
        int n2 = this.getHtmlSize(n) - 1;
        mUI = this.selStart.mui;
        while (mUI != null) {
            mUI.f = this.getFontInfoByIndex(mUI.f.name, mUI.f.style, n2);
            mUI.recalc();
            if (mUI == this.selEnd.mui) break;
            mUI = mUI.next;
        }
        this.repaint();
    }

    public void resetFontSize() {
        if (!this.chopSelection()) {
            return;
        }
        MUI mUI = this.selStart.mui;
        while (mUI != null) {
            mUI.f = this.getFontInfoByIndex(mUI.f.name, mUI.f.style, 3);
            mUI.recalc();
            if (mUI == this.selEnd.mui) break;
            mUI = mUI.next;
        }
        this.repaint();
    }

    private synchronized void deleteSelection() {
        MUI mUI = this.selEnd.mui.next;
        MUI mUI2 = this.selStart.mui.prev;
        MUI mUI3 = this.selStart.mui.muiBefore(this.selStart.c);
        this.insertMUI(mUI3, this.selStart.mui);
        MUI mUI4 = this.selEnd.mui.muiAfter(this.selEnd.c);
        this.insertMUI(mUI4, this.selStart.mui);
        MUI mUI5 = this.selStart.mui;
        while (mUI5 != null) {
            MUI mUI6 = mUI5.next;
            this.removeMUI(mUI5);
            mUI5.flush();
            if (mUI5 == this.selEnd.mui) break;
            mUI5 = mUI6;
        }
        if (mUI4 != null) {
            this.selStart.mui = mUI4;
            this.selStart.c = this.selStart.mui.posBefore();
        } else if (mUI != null) {
            this.selStart.mui = mUI;
            this.selStart.c = this.selStart.mui.posBefore();
        } else if (mUI3 != null) {
            this.selStart.mui = mUI3;
            this.selStart.c = this.selStart.mui.posAfter();
        } else if (mUI2 != null) {
            this.selStart.mui = mUI2;
            this.selStart.c = this.selStart.mui.posAfter();
        } else {
            this.appendMUI(new MUI("", defFont, defFG, defBG));
            this.assignLines(0, this.muiStart, true);
            this.assignXY(this.muiStart, true);
            this.selStart = this.getPos(0, 0);
        }
        this.selEnd = null;
    }

    public boolean editCallback(int n) {
        switch (n) {
            case 0: {
                return true;
            }
            case 1: {
                String string = "";
                if (this.selStart.mui.url != null) {
                    string = this.selStart.mui.url;
                }
                String string2 = "";
                if (this.selEnd != null && this.selStart.compareTo(this.selEnd) != 0) {
                    string2 = this.getText(this.selStart, this.selEnd);
                }
                DataChoiceUI.newDataChoiceUI(this, EDIT_URL, "Edit URL", null, "hyperlink url", string, true, 60, "hyperlink text", string2, true, 60, "ok", "cancel", "delete", "launch", "sound", true);
                return true;
            }
            case 2: {
                if (this.selEnd != null && this.selStart.compareTo(this.selEnd) != 0) {
                    StringSelection stringSelection = new StringSelection(this.getTextAsHTML(this.selStart, this.selEnd));
                    this.clipboard.setContents(stringSelection, this);
                    this.deleteSelection();
                    this.repaint();
                }
                return true;
            }
            case 3: {
                if (this.selEnd != null && this.selStart.compareTo(this.selEnd) != 0) {
                    StringSelection stringSelection = new StringSelection(this.getTextAsHTML(this.selStart, this.selEnd));
                    AolRtf.dbg(ev, "copy " + this.selStart + " " + this.selEnd + " " + this.getTextAsHTML(this.selStart, this.selEnd));
                    this.clipboard.setContents(stringSelection, this);
                }
                return true;
            }
            case 4: {
                Transferable transferable = this.clipboard.getContents(this);
                if (transferable == null) {
                    return true;
                }
                try {
                    String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    String string3 = string.trim();
                    if (string3.startsWith("html://") || string3.startsWith("HTML://")) {
                        int n2 = string3.indexOf(32);
                        String string4 = string3.substring(0, n2);
                        string3.substring(n2, string3.length());
                        string = "<A HREF=\"" + string4 + "\">" + string4 + "</A>+rest";
                    }
                    this.paste(string);
                }
                catch (Exception exception) {
                    System.out.println("Couldn't get contents in format: " + DataFlavor.stringFlavor.getHumanPresentableName());
                }
                return true;
            }
            case 5: {
                if (this.selEnd != null && this.selStart.compareTo(this.selEnd) != 0) {
                    this.deleteSelection();
                    this.repaint();
                }
                return true;
            }
            case 6: {
                this.selStart.mui = this.muiStart;
                this.selStart.c = this.selStart.mui.posBefore();
                if (this.selEnd == null) {
                    this.selEnd = new AolRtfPos();
                }
                this.selEnd.mui = this.muiEnd;
                this.selEnd.c = this.selEnd.mui.posAfter();
                this.repaint();
                return true;
            }
            case 7: {
                FileDialog fileDialog = new FileDialog(IUtil.findFrame(this), "Save Text to", 1);
                ((Component)fileDialog).setVisible(true);
                String string = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
                if (string == null) {
                    return true;
                }
                try {
                    FileWriter fileWriter = new FileWriter(string);
                    String string5 = this.getTextAsHTML();
                    fileWriter.write(string5, 0, string5.length());
                    fileWriter.close();
                }
                catch (Exception exception) {
                    Log.log(MODULE, Log.NOTICE, "Couldn't save Text", exception);
                }
                return true;
            }
            case 8: {
                FileDialog fileDialog = new FileDialog(IUtil.findFrame(this), "Append Text to", 0);
                ((Component)fileDialog).setVisible(true);
                String string = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
                if (string == null) {
                    return true;
                }
                try {
                    RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
                    randomAccessFile.seek(randomAccessFile.length());
                    String string6 = this.getTextAsHTML();
                    randomAccessFile.writeBytes(string6);
                    randomAccessFile.close();
                }
                catch (Exception exception) {
                    Log.log(MODULE, Log.NOTICE, "Couldn't append Text", exception);
                }
                return true;
            }
            case 9: {
                Properties properties = new Properties();
                PrintJob printJob = this.getToolkit().getPrintJob(IUtil.findFrame(this), "Print Text", properties);
                if (printJob != null) {
                    Graphics graphics = printJob.getGraphics();
                    Dimension dimension = printJob.getPageDimension();
                    int n3 = this.getToolkit().getScreenResolution();
                    int n4 = printJob.getPageResolution();
                    int n5 = n3;
                    Log.log(MODULE, Log.DB0, "Printer page size = " + dimension);
                    Log.log(MODULE, Log.DB0, "Printer resolution = " + n4);
                    Log.log(MODULE, Log.DB0, "Screen resolution = " + n3);
                    Graphics graphics2 = graphics.create(n5 / 2, n5 / 2, dimension.width - n5, dimension.height - n5);
                    this.redraw(this.muiStart, true, new Dimension(dimension.width - n5, dimension.height - n5), graphics2);
                    graphics2.dispose();
                    graphics.dispose();
                    printJob.end();
                }
                return true;
            }
        }
        return false;
    }

    private void paste(String string) {
        AolRtf.dbg(ev, "paste " + this.selStart + " " + this.selEnd + " " + string);
        if (this.selEnd != null && this.selStart.compareTo(this.selEnd) != 0) {
            this.deleteSelection();
        }
        MUI mUI = this.HTMLToMUI(string);
        MUI mUI2 = mUI.endOfChain();
        if (this.selStart.mui.isBreak() || this.selStart.mui.posIsBefore(this.selStart.c)) {
            this.insertMUI(mUI, this.selStart.mui);
        } else if (this.selStart.mui.posIsAfter(this.selStart.c)) {
            this.insertMUI(mUI, this.selStart.mui.next);
        } else {
            MUI mUI3 = this.selStart.mui.duplicate();
            mUI3.data = mUI3.data.substring(0, this.selStart.c + 1);
            mUI3.recalc();
            MUI mUI4 = this.selStart.mui.duplicate();
            mUI4.data = mUI4.data.substring(this.selStart.c + 1, this.selStart.mui.length());
            mUI4.recalc();
            mUI3.prev = null;
            mUI3.next = mUI;
            mUI.prev = mUI3;
            mUI2.next = mUI4;
            mUI4.prev = mUI2;
            mUI4.next = null;
            this.insertMUI(mUI3, this.selStart.mui);
            this.removeMUI(this.selStart.mui);
            this.selStart.mui.flush();
        }
        this.selStart.mui = mUI2;
        this.selStart.c = this.selStart.mui.posAfter();
        this.selEnd = null;
        this.repaint();
    }

    public void choiceMade(int n, int n2, Object object) {
        Log.log("choice " + n2);
        if (n == EDIT_URL && n2 != -1) {
            if (n2 == 0) {
                if (object == null) {
                    return;
                }
                Vector vector = (Vector)object;
                String string = null;
                String string2 = null;
                if (vector.size() > 0) {
                    string = (String)vector.elementAt(0);
                }
                if (vector.size() > 1) {
                    string2 = (String)vector.elementAt(1);
                }
                Log.log("got " + string + " and " + string2);
                if (string != null && !string.equals("") && string2 != null && !string2.equals("")) {
                    this.paste("<A HREF=\"" + string + "\">" + string2 + "</A>");
                    return;
                }
                if (string == null && !string.equals("") && string2 != null) {
                    this.paste(string2);
                    return;
                }
            } else if (n2 != 1) {
                if (n2 == 2) {
                    if (this.selEnd != null && this.selStart.compareTo(this.selEnd) != 0) {
                        this.deleteSelection();
                        this.repaint();
                        return;
                    }
                } else if (n2 == 3) {
                    if (object == null) {
                        return;
                    }
                    Vector vector = (Vector)object;
                    new UrlViewer((String)vector.elementAt(0));
                }
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.requestFocus();
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public boolean isFocusTraversable() {
        return true;
    }

    private synchronized AolRtfPos whatToMove(boolean bl, boolean bl2) {
        AolRtfPos aolRtfPos = null;
        if (bl) {
            if (this.lastMoved == moveNone || this.selEnd == null) {
                if (this.selEnd == null) {
                    this.selEnd = new AolRtfPos();
                    this.selEnd.copy(this.selStart);
                }
                if (bl2) {
                    this.lastMoved = moveStart;
                    aolRtfPos = this.selStart;
                } else {
                    this.lastMoved = moveEnd;
                    aolRtfPos = this.selEnd;
                }
            } else {
                aolRtfPos = this.lastMoved == moveEnd ? this.selEnd : this.selStart;
            }
        } else if (this.editable) {
            if (this.selEnd != null && !bl2) {
                this.selStart.copy(this.selEnd);
            }
            this.lastMoved = moveNone;
            aolRtfPos = this.selStart;
            this.selEnd = null;
        } else if (this.sb != null) {
            this.lastMoved = moveNone;
            aolRtfPos = this.getPos(0, this.sb.getValue());
        }
        return aolRtfPos;
    }

    private synchronized MUI findFontMUI(MUI mUI) {
        MUI mUI2 = mUI;
        while (mUI2 != null) {
            if (!mUI2.isBreak() && mUI2.url == null) {
                return mUI2;
            }
            mUI2 = mUI2.prev;
        }
        return mUI;
    }

    private synchronized void scrollTo(MUI mUI) {
        this.scrollToMUI = mUI;
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        super.repaint(l, n, n2, n3, n4);
    }

    public void update(Graphics graphics) {
        this.redraw();
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        int n = 0;
        if (this.sb != null) {
            n = this.sb.getValue();
        }
        graphics.drawImage(this.offScreenBM, 0, -n, this);
        if (this.editable && this.selEnd == null) {
            graphics.setColor(this.selColor);
            graphics.drawLine(this.selStart.insertPos, this.selStart.mui.lineTop - n, this.selStart.insertPos, this.selStart.mui.lineBottom - n);
        }
    }

    public void timerEvent(String string, int n, Object object) {
        if (n == CURSOR_BLINK_EVENT) {
            Timer.createEvent("System", this, CURSOR_BLINK_EVENT, null, blinkTime);
            this.selColor = this.selColor == Color.white ? Color.black : Color.white;
            this.repaint();
        }
    }

    private synchronized AolRtfPos getPosFromScreen(int n, int n2) {
        int n3 = 0;
        if (this.sb != null) {
            n3 = this.sb.getValue();
        }
        return this.getPos(n, n2 + n3);
    }

    private synchronized AolRtfPos getPos(int n, int n2) {
        AolRtfPos aolRtfPos = new AolRtfPos();
        aolRtfPos.x = n;
        aolRtfPos.y = n2;
        n -= 2;
        MUI mUI = this.muiStart;
        while (mUI != null) {
            if (n2 >= mUI.lineTop && n2 < mUI.lineBottom && (n < mUI.x || n >= mUI.x && (n < mUI.x + mUI.width || mUI.next != null && mUI.lineNo != mUI.next.lineNo || mUI == this.muiEnd))) {
                aolRtfPos.mui = mUI;
                if (n <= 0) {
                    aolRtfPos.c = aolRtfPos.mui.posBefore();
                    aolRtfPos.insertPos = 0;
                    break;
                }
                int n3 = 0;
                int n4 = 1;
                while (n4 <= mUI.length()) {
                    String string = mUI.data.substring(0, n4);
                    n3 = mUI.f.metrics.stringWidth(string);
                    if (n < mUI.x + n3) break;
                    ++n4;
                }
                aolRtfPos.c = n4 > mUI.length() ? n4 - 2 : n4 - 1;
                aolRtfPos.insertPos = mUI.x + n3;
                break;
            }
            mUI = mUI.next;
        }
        if (aolRtfPos.mui == null) {
            aolRtfPos.mui = this.muiEnd;
            aolRtfPos.c = aolRtfPos.mui.posAfter();
        }
        if (aolRtfPos.mui.isBreak()) {
            aolRtfPos.c = 0;
            this.lastNonBreakOnThisLine(aolRtfPos);
            aolRtfPos.update();
        }
        return aolRtfPos;
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        Log.log(MODULE, Log.DB3, "AolRtf: Clipboard contents replaced.");
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isMetaDown()) {
            boolean bl = this.selEnd != null && this.selStart.compareTo(this.selEnd) != 0;
            this.editItems[2].setEnabled(this.editable && bl);
            this.editItems[3].setEnabled(bl);
            this.editItems[4].setEnabled(this.editable && this.clipboard.getContents(this) != null);
            this.editItems[5].setEnabled(this.editable && bl);
            this.editMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            return;
        }
        AolRtfPos aolRtfPos = this.getPosFromScreen(mouseEvent.getX(), mouseEvent.getY());
        if (!this.editable && aolRtfPos.mui.url != null) {
            AolRtf.dbg(ev, "clicked on a hyperlink " + aolRtfPos);
            new UrlViewer(aolRtfPos.mui.url);
            this.selStart = aolRtfPos;
            this.selEnd = null;
        } else if (!aolRtfPos.mui.isBreak() && mouseEvent.getWhen() - this.lastMouseDownTime < DBL_CLICK_TIME) {
            this.selStart = aolRtfPos;
            this.selEnd = new AolRtfPos();
            this.selEnd.copy(aolRtfPos);
            this.selStart.c = this.selStart.mui.posBefore();
            this.selEnd.c = this.selEnd.mui.posAfter();
            this.inDoubleClick = true;
            if (this.editable && aolRtfPos.mui.url != null) {
                String string = this.selStart.mui.url;
                String string2 = this.selStart.mui.data;
                DataChoiceUI.newDataChoiceUI(this, EDIT_URL, "Edit URL", null, "hyperlink url", string, true, 60, "hyperlink text", string2, true, 60, "ok", "cancel", "delete", "launch", "sound", true);
            }
        } else {
            this.selStart = aolRtfPos;
            this.selEnd = null;
        }
        this.lastMouseDownTime = mouseEvent.getWhen();
        this.mouseDownPos = aolRtfPos;
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.inDoubleClick = false;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.editable) {
            this.requestFocus();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.isMetaDown()) {
            return;
        }
        if (this.mouseDownPos == null) {
            return;
        }
        AolRtfPos aolRtfPos = this.getPosFromScreen(mouseEvent.getX(), mouseEvent.getY());
        int n = aolRtfPos.compareTo(this.mouseDownPos);
        if (this.inDoubleClick) {
            if (n != 0 && aolRtfPos.mui != this.mouseDownPos.mui) {
                if (n < 0 && aolRtfPos.mui != this.mouseDownPos.mui) {
                    this.selStart = aolRtfPos;
                    this.selStart.c = this.selStart.mui.posBefore();
                    this.selEnd.copy(this.mouseDownPos);
                    this.selEnd.c = this.selEnd.mui.posAfter();
                    this.scrollTo(this.selStart.mui);
                } else if (n > 0 && aolRtfPos.mui != this.mouseDownPos.mui) {
                    this.selStart.copy(this.mouseDownPos);
                    this.selStart.c = this.selStart.mui.posBefore();
                    this.selEnd = aolRtfPos;
                    this.selEnd.c = this.selEnd.mui.posAfter();
                    this.scrollTo(this.selEnd.mui);
                }
            }
        } else {
            if (n == 0) {
                this.selStart = this.mouseDownPos;
                this.selEnd = null;
                this.scrollTo(this.selStart.mui);
            }
            if (n < 0) {
                this.selStart = aolRtfPos;
                this.selEnd = this.mouseDownPos;
                this.scrollTo(this.selStart.mui);
            } else if (n > 0) {
                this.selStart = this.mouseDownPos;
                this.selEnd = aolRtfPos;
                this.scrollTo(this.selEnd.mui);
            }
        }
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (!this.editable) {
            return;
        }
        if (c == '\n' || c == '\r') {
            return;
        }
        if (c == '\u007f') {
            this.selEnd = null;
            return;
        }
        if (c == '\b') {
            if (this.selEnd != null && this.selStart.compareTo(this.selEnd) != 0) {
                this.deleteSelection();
            } else if (this.selStart.c >= 0 && !this.selStart.mui.isBreak()) {
                String string = this.selStart.mui.data.substring(0, this.selStart.c);
                if (this.selStart.c + 1 < this.selStart.mui.length()) {
                    string = String.valueOf(string) + this.selStart.mui.data.substring(this.selStart.c + 1);
                }
                this.selStart.mui.data = string;
                this.selStart.mui.recalc();
                this.prevCharacter(this.selStart);
            } else if (this.selStart.mui.prev != null) {
                if (this.selStart.mui.prev.isBreak()) {
                    MUI mUI = this.selStart.mui.prev;
                    this.removeMUI(mUI);
                    mUI.flush();
                    if (this.selStart.mui.prev != null && !this.selStart.mui.prev.isBreak()) {
                        this.selStart.mui = this.selStart.mui.prev;
                        this.selStart.c = this.selStart.mui.posAfter();
                    }
                } else {
                    this.selStart.mui = this.selStart.mui.prev;
                    this.selStart.c = this.selStart.mui.posAfter();
                    return;
                }
            }
            this.selEnd = null;
        } else {
            if (keyEvent.isControlDown() || keyEvent.isMetaDown()) {
                return;
            }
            if (this.selEnd != null && this.selStart.compareTo(this.selEnd) != 0) {
                this.deleteSelection();
            }
            this.selEnd = null;
            char c2 = keyEvent.getKeyChar();
            if (this.selStart.mui.isBreak()) {
                MUI mUI = this.findFontMUI(this.selStart.mui);
                MUI mUI2 = new MUI(String.valueOf(c2), mUI.f, mUI.fgColor, mUI.bgColor);
                this.insertMUI(mUI2, this.selStart.mui);
                this.selStart.mui = mUI2;
                this.selStart.c = 0;
            } else {
                StringBuffer stringBuffer = new StringBuffer(this.selStart.mui.data);
                stringBuffer.insert(this.selStart.c + 1, c2);
                this.selStart.mui.data = new String(stringBuffer);
                ++this.selStart.c;
            }
            this.selStart.mui.recalc();
        }
        this.scrollTo(this.selStart.mui);
        this.repaint();
    }

    public void keyPressed(KeyEvent keyEvent) {
        if ((keyEvent.getKeyChar() == this.sendKey || keyEvent.getKeyChar() == '\r' && this.sendKey == 10) && keyEvent.getModifiers() == this.sendKeyModifiers && this.listener != null && this.editable) {
            this.listener.sendKeyPressed();
            return;
        }
        if (keyEvent.getKeyChar() == '\u0001') {
            this.editCallback(6);
        } else if (keyEvent.getKeyChar() == '\u0003') {
            this.editCallback(3);
        } else if (keyEvent.getKeyChar() == '\t' && !keyEvent.isControlDown()) {
            return;
        }
        if (!this.editable) {
            return;
        }
        if (keyEvent.getKeyCode() == 10) {
            if (this.selEnd != null && this.selStart.compareTo(this.selEnd) != 0) {
                this.deleteSelection();
            }
            if (this.selStart.mui.posIsBefore(this.selStart.c)) {
                this.insertMUI(new MUI("<BR>"), this.selStart.mui);
            } else if (this.selStart.mui.posIsAfter(this.selStart.c)) {
                if (this.selStart.mui == this.muiEnd) {
                    MUI mUI = this.findFontMUI(this.selStart.mui);
                    this.insertMUI(new MUI("<BR>"), null);
                    this.insertMUI(new MUI("", mUI.f, mUI.fgColor, mUI.bgColor), null);
                    this.selStart.mui = this.muiEnd;
                } else {
                    if (this.selStart.mui.next != null && this.selStart.mui.next.isBreak()) {
                        this.selStart.mui = this.selStart.mui.next;
                    } else {
                        this.nextCharacter(this.selStart);
                    }
                    this.insertMUI(new MUI("<BR>"), this.selStart.mui);
                }
                this.selStart.c = this.selStart.mui.posBefore();
            } else {
                MUI mUI = this.selStart.mui.duplicate();
                mUI.data = this.selStart.mui.data.substring(0, this.selStart.c + 1);
                mUI.recalc();
                MUI mUI2 = new MUI("<BR>");
                MUI mUI3 = this.selStart.mui.duplicate();
                mUI3.data = this.selStart.mui.data.substring(this.selStart.c + 1, this.selStart.mui.length());
                mUI3.recalc();
                mUI.prev = null;
                mUI.next = mUI2;
                mUI2.prev = mUI;
                mUI2.next = mUI3;
                mUI3.prev = mUI2;
                mUI3.next = null;
                this.insertMUI(mUI, this.selStart.mui);
                this.removeMUI(this.selStart.mui);
                this.selStart.mui.flush();
                this.selStart.mui = mUI3;
                this.selStart.c = this.selStart.mui.posBefore();
            }
            this.selEnd = null;
        } else if (keyEvent.getKeyChar() == '\u001a') {
            this.editCallback(0);
        } else if (keyEvent.getKeyChar() == '\f') {
            this.editCallback(1);
        } else if (keyEvent.getKeyChar() == '\u0018') {
            this.editCallback(2);
        } else if (keyEvent.getKeyChar() == '\u0016') {
            this.editCallback(4);
        } else if (keyEvent.getKeyChar() == '\u0002' && this.selEnd != null && this.selStart.compareTo(this.selEnd) != 0) {
            this.setStyle('b', !this.entireSelectionBold);
        } else if (keyEvent.getKeyChar() == '\t' && this.selEnd != null && this.selStart.compareTo(this.selEnd) != 0) {
            this.setStyle('i', !this.entireSelectionItalic);
        } else if (keyEvent.getKeyChar() == '\u0015' && this.selEnd != null && this.selStart.compareTo(this.selEnd) != 0) {
            this.setStyle('u', !this.entireSelectionUnderlined);
        } else {
            if (keyEvent.isActionKey()) {
                this.scrollTo(null);
                AolRtf.dbg(ev, "AolRtf got action  " + keyEvent);
                switch (keyEvent.getKeyCode()) {
                    case 36: {
                        this.scrollTo(this.muiStart);
                        break;
                    }
                    case 35: {
                        this.scrollTo(this.muiEnd);
                        break;
                    }
                    case 33: {
                        if (this.sb == null) break;
                        this.sb.setValue(this.sb.getValue() - this.sb.getVisibleAmount());
                        break;
                    }
                    case 34: {
                        if (this.sb == null) break;
                        this.sb.setValue(this.sb.getValue() + this.sb.getVisibleAmount());
                        break;
                    }
                    case 38: {
                        AolRtfPos aolRtfPos = this.whatToMove(keyEvent.isShiftDown(), true);
                        if (aolRtfPos == null) break;
                        this.sameXPrevLine(aolRtfPos);
                        this.scrollTo(aolRtfPos.mui);
                        break;
                    }
                    case 40: {
                        AolRtfPos aolRtfPos = this.whatToMove(keyEvent.isShiftDown(), false);
                        if (aolRtfPos == null) break;
                        this.sameXNextLine(aolRtfPos);
                        this.scrollTo(aolRtfPos.mui);
                        break;
                    }
                    case 37: {
                        AolRtfPos aolRtfPos = this.whatToMove(keyEvent.isShiftDown(), true);
                        if (aolRtfPos == null) break;
                        this.prevCharacter(aolRtfPos);
                        this.scrollTo(aolRtfPos.mui);
                        break;
                    }
                    case 39: {
                        AolRtfPos aolRtfPos = this.whatToMove(keyEvent.isShiftDown(), false);
                        if (aolRtfPos == null) break;
                        this.nextCharacter(aolRtfPos);
                        this.scrollTo(aolRtfPos.mui);
                        break;
                    }
                    case 120: {
                        this.verboseRedraw = !this.verboseRedraw;
                        System.out.println("in f9 " + this.verboseRedraw);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                this.repaint();
                return;
            }
            return;
        }
        this.scrollTo(this.selStart.mui);
        this.repaint();
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof MenuItem) {
            int n = 0;
            while (n < this.editItems.length) {
                if (this.editItems[n] == object) {
                    this.editCallback(n);
                }
                ++n;
            }
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.scrollTo(null);
        switch (adjustmentEvent.getAdjustmentType()) {
            case 1: {
                int n = this.sb.getValue();
                AolRtfPos aolRtfPos = this.getPos(0, n);
                this.startOfNextLine(aolRtfPos);
                this.sb.setValue(aolRtfPos.mui.lineTop);
                break;
            }
            case 2: {
                int n = this.sb.getValue();
                AolRtfPos aolRtfPos = this.getPos(0, n);
                this.sb.setValue(aolRtfPos.mui.lineTop);
                break;
            }
            case 4: {
                this.sb.setValue(this.sb.getValue() + this.sb.getVisibleAmount());
                break;
            }
            case 3: {
                this.sb.setValue(this.sb.getValue() - this.sb.getVisibleAmount());
                break;
            }
        }
        this.repaint();
    }

    static {
        EDIT_URL = 1;
        lb = true;
        sc = true;
        ev = true;
        di = true;
        moveStart = 1;
        moveEnd = 2;
    }
}

