/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

public class ImageLabel
extends Component {
    public static final int CENTER = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    private int vPad = 5;
    private int hPad = 5;
    private String text;
    private Rectangle textBox = new Rectangle(0, 0, 0, 0);
    private int alignment;
    private Font font;
    private int fontStyle = 1;
    private FontMetrics metrics;
    private boolean dimmed = false;

    public ImageLabel(String string) {
        this.text = string;
        this.alignment = 2;
    }

    public ImageLabel(String string, int n) {
        this.text = string;
        this.alignment = n;
    }

    public ImageLabel(String string, int n, int n2, int n3) {
        this.text = string;
        this.alignment = n;
        this.hPad = n2;
        this.vPad = n3;
    }

    public void calculateTextSize() {
        this.font = this.getFont();
        Font font = null;
        switch (this.fontStyle) {
            case 0: {
                font = new Font(this.font.getName(), this.fontStyle, this.font.getSize());
                break;
            }
            case 2: {
                font = new Font(this.font.getName(), this.fontStyle, this.font.getSize());
                break;
            }
        }
        if (font != null) {
            this.font = font;
            this.setFont(this.font);
        }
        this.metrics = this.getFontMetrics(this.font);
        this.textBox.width = this.metrics.stringWidth(this.text);
        this.textBox.height = this.metrics.getAscent() + this.metrics.getDescent();
    }

    public void calculateTextPosition() {
        Dimension dimension = this.getSize();
        switch (this.alignment) {
            case 2: {
                this.textBox.x = this.hPad;
                break;
            }
            case 3: {
                this.textBox.x = dimension.width - this.hPad - this.textBox.width;
                break;
            }
            default: {
                this.textBox.x = (dimension.width - this.textBox.width) / 2;
            }
        }
        this.textBox.y = (dimension.height - this.textBox.height) / 2 + this.textBox.height - this.metrics.getDescent();
    }

    void recalculate() {
        this.calculateTextSize();
        this.calculateTextPosition();
        this.repaint();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.recalculate();
    }

    public Dimension getMinimumSize() {
        this.calculateTextSize();
        Dimension dimension = new Dimension(this.textBox.width + 2 * this.hPad, this.textBox.height + 2 * this.vPad);
        return dimension;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void paint(Graphics graphics) {
        if (this.dimmed) {
            graphics.setColor(Color.gray);
        } else {
            graphics.setColor(Color.black);
        }
        graphics.drawString(this.text, this.textBox.x, this.textBox.y);
    }

    public void removeNotify() {
        this.text = null;
        this.textBox = null;
        this.font = null;
        this.metrics = null;
    }

    public void setDim(boolean bl) {
        this.dimmed = bl;
        this.repaint();
    }

    public void setText(String string) {
        this.text = string;
        if (this.isValid()) {
            this.recalculate();
        }
    }

    public void setTextStyle(int n) {
        this.fontStyle = n;
        if (this.isValid()) {
            this.recalculate();
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

