/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Panel;
import uiutil.ImageContainer;

public class ImagePanel
extends Panel
implements ImageContainer {
    Image tile;
    Image background;
    Image offscreen;
    Graphics offscreenGraphics;

    public ImagePanel() {
    }

    public ImagePanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public ImagePanel(String string) {
        this.setName(string);
    }

    public void destroy() {
        this.removeAll();
        this.setLayout(null);
        this.tile = null;
        this.background = null;
        this.offscreen = null;
    }

    public Image getTile() {
        return this.tile;
    }

    public Image getBackground(int n, int n2, int n3, int n4) {
        if (n3 < 1 || n4 < 1) {
            return null;
        }
        Image image = this.createImage(n3, n4);
        Graphics graphics = image.getGraphics();
        if (this.tile != null) {
            int n5 = this.tile.getWidth(this);
            int n6 = this.tile.getHeight(this);
            int n7 = 0;
            while (n7 < n3) {
                int n8 = 0;
                while (n8 < n4) {
                    graphics.drawImage(this.tile, n7, n8, this);
                    n8 += n6;
                }
                n7 += n5;
            }
        } else {
            graphics.setColor(Color.black);
            graphics.clearRect(0, 0, n3 - 1, n4 - 1);
        }
        return image;
    }

    public void doLayout() {
        this.background = null;
        this.offscreen = null;
        this.offscreenGraphics = null;
        super.doLayout();
    }

    public void paint(Graphics graphics) {
        if (this.background == null) {
            this.makeNewBackground();
        }
        if (this.offscreen == null) {
            this.offscreen = this.createImage(this.getSize().width, this.getSize().height);
            this.offscreenGraphics = this.offscreen.getGraphics();
            this.offscreenGraphics.setClip(0, 0, this.getSize().width, this.getSize().height);
        }
        if (this.background != null) {
            this.offscreenGraphics.drawImage(this.background, 0, 0, this);
        }
        super.paint(this.offscreenGraphics);
        graphics.drawImage(this.offscreen, 0, 0, null);
    }

    public void makeNewBackground() {
        Dimension dimension = this.getSize();
        if (dimension.width < 1 || dimension.height < 1) {
            return;
        }
        this.background = this.createImage(dimension.width, dimension.height);
        if (this.background == null) {
            return;
        }
        Graphics graphics = this.background.getGraphics();
        if (this.tile != null) {
            int n = this.tile.getWidth(this);
            int n2 = this.tile.getHeight(this);
            int n3 = 0;
            while (n3 < dimension.width) {
                int n4 = 0;
                while (n4 < dimension.height) {
                    graphics.drawImage(this.tile, n3, n4, this);
                    n4 += n2;
                }
                n3 += n;
            }
            return;
        }
        graphics.setColor(Color.black);
        graphics.clearRect(0, 0, dimension.width - 1, dimension.height - 1);
    }

    public void removeNotify() {
        this.destroy();
        super.removeNotify();
    }

    public void setTile(Image image) {
        this.tile = image;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

