/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import uiutil.ImageButton;
import uiutil.ImageStore;

public class LabelButton
extends ImageButton {
    private String etchedLabel;
    private Image image;
    private int ypadding;
    private Image standard;
    private Image pushed;
    private Image disabled;
    private Image rollover;

    public LabelButton() {
    }

    public LabelButton(Image image, String string) {
        this(image, image, image, image, string, 0);
    }

    public LabelButton(Image image, String string, int n) {
        this(image, image, image, image, string, n);
    }

    public LabelButton(Image image, Image image2, Image image3, Image image4, String string) {
        this(image, image2, image3, image4, string, 0);
    }

    public LabelButton(Image image, Image image2, Image image3, Image image4, String string, int n) {
        this.label = string;
        this.etchedLabel = string;
        this.ypadding = n;
        this.standard = image;
        this.pushed = image2;
        this.disabled = image3;
        this.rollover = image4;
    }

    public String getLabel() {
        if (this.label == null) {
            return this.etchedLabel;
        }
        return this.label;
    }

    public void addNotify() {
        super.addNotify();
        this.etchedLabel = this.label;
        this.makeButtonImages();
    }

    public void destroy() {
        this.image = null;
        this.standard = null;
        this.pushed = null;
        this.disabled = null;
        this.rollover = null;
        super.destroy();
    }

    public void removeNotify() {
        this.destroy();
        super.removeNotify();
    }

    public void changeButton(Image image, String string) {
        this.image = image;
        this.label = string;
        this.etchedLabel = string;
        this.makeButtonImages();
    }

    private Image makeLabelImage(Image image) {
        if (image == null) {
            return null;
        }
        Font font = super.getFont();
        this.image = image;
        Image image2 = null;
        Graphics graphics = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        FontMetrics fontMetrics = this.getFontMetrics(font);
        if (fontMetrics != null) {
            n = fontMetrics.stringWidth(this.label);
            n2 = fontMetrics.getHeight();
            n3 = fontMetrics.getDescent() + fontMetrics.getAscent() / 2;
        }
        int n4 = image.getWidth(this);
        int n5 = image.getHeight(this);
        this.width = Math.max(n, n4);
        this.height = n2 + this.ypadding + n5;
        image2 = this.createImage(this.width, this.height);
        graphics = image2.getGraphics();
        graphics.setColor(Color.cyan);
        graphics.setFont(font);
        graphics.fillRect(0, 0, this.width, this.height);
        int n6 = 0;
        if (n > n4) {
            n6 = (n - n4) / 2;
        }
        graphics.drawImage(image, n6, 0, this);
        n6 = 0;
        if (n < n4) {
            n6 = (n4 - n) / 2;
        }
        graphics.setColor(Color.black);
        graphics.drawString(this.label, n6, this.height - n3);
        image2 = ImageStore.makeTransparent(image2, Color.cyan, this);
        return image2;
    }

    private void makeButtonImages() {
        this.standard = this.makeLabelImage(this.standard);
        this.pushed = this.makeLabelImage(this.pushed);
        this.disabled = this.makeLabelImage(this.disabled);
        this.rollover = this.makeLabelImage(this.rollover);
        this.label = null;
        this.setImages(this.standard, this.pushed, this.disabled, this.rollover);
    }
}

