/*
 * Decompiled with CFR 0.152.
 */
package rath.jmsn;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JOptionPane;
import rath.jmsn.BuddyTree;
import rath.jmsn.MainFrame;
import rath.jmsn.NativeToolkit;
import rath.jmsn.ui.AboutDialog;
import rath.jmsn.ui.AddFriendDialog;
import rath.jmsn.ui.AddGroupDialog;
import rath.jmsn.ui.LoginDialog;
import rath.jmsn.ui.OptionDialog;
import rath.jmsn.ui.RenameGroupDialog;
import rath.jmsn.ui.ReportDialog;
import rath.jmsn.util.Msg;
import rath.jmsn.util.UserStatusBox;
import rath.msnm.BuddyList;
import rath.msnm.MSNMessenger;
import rath.msnm.UserStatus;
import rath.msnm.entity.Group;
import rath.msnm.entity.MsnFriend;

public class ActionGroup
implements UserStatus {
    private MainFrame main = null;
    private MSNMessenger msnm = null;
    private BuddyTree buddies = null;
    private ReportDialog dialogBugReport = null;
    private ReportDialog dialogFeatureReq = null;
    private boolean isAlwaysOnTop = false;

    public ActionGroup(MainFrame main, BuddyTree buddies) {
        this.main = main;
        this.buddies = buddies;
        this.msnm = main.getMessenger();
    }

    public boolean actionLogin() {
        LoginDialog dialog = new LoginDialog(this.main);
        dialog.show();
        if (dialog.isConfirm()) {
            String login = dialog.getLoginName();
            String pass = dialog.getPassword();
            this.processLogin(login, pass, dialog.getInitialStatus());
            if (dialog.isRememberPassword()) {
                login = login + ":" + pass;
            }
            MainFrame.getGlobalProp().set("last.login", login);
            return true;
        }
        return false;
    }

    public void actionLogout() {
        this.main.logout();
    }

    private void processLogin(String login, String pass, String status) {
        this.msnm.setInitialStatus(status);
        this.msnm.login(login, pass);
        this.main.showLogging();
    }

    public void actionToggleOffView() {
        this.buddies.toggleOfflineView();
    }

    public void actionAddFriend() {
        AddFriendDialog add = new AddFriendDialog((Frame)this.main, this.msnm);
        add.show();
    }

    public void actionBlockFriend() {
        block2: {
            MsnFriend friend = this.buddies.getSelectedFriend();
            if (friend == null) break block2;
            String loginName = friend.getLoginName();
            try {
                this.msnm.blockFriend(loginName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void actionUnblockFriend() {
        block2: {
            MsnFriend friend = this.buddies.getSelectedFriend();
            if (friend == null) break block2;
            String loginName = friend.getLoginName();
            try {
                this.msnm.unBlockFriend(loginName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private ArrayList getSelectedGroupUsers() {
        Group group = this.buddies.getSelectedGroup();
        int groupIndex = -1;
        if (group == null) {
            MsnFriend friend = this.buddies.getSelectedFriend();
            if (friend != null) {
                groupIndex = friend.getGroupIndex();
            }
        } else {
            groupIndex = group.getIndexInt();
        }
        if (groupIndex == -1) {
            return null;
        }
        ArrayList<MsnFriend> list = new ArrayList<MsnFriend>(10);
        BuddyList fl = this.msnm.getBuddyGroup().getForwardList();
        Iterator i = fl.iterator();
        while (i.hasNext()) {
            MsnFriend f = (MsnFriend)i.next();
            if (f.getGroupIndex() != groupIndex) continue;
            list.add(f);
        }
        return list;
    }

    private boolean confirmGroupProcess(ArrayList friends, String title) {
        StringBuffer sb = new StringBuffer(256);
        Iterator i = friends.iterator();
        while (i.hasNext()) {
            MsnFriend f = (MsnFriend)i.next();
            sb.append(f.getLoginName());
            sb.append(" ");
            sb.append(f.getFormattedFriendlyName());
            sb.append("\n");
        }
        return JOptionPane.showConfirmDialog(this.main, sb.toString(), title, 2, 2) == 0;
    }

    public void actionBlockGroup() {
        ArrayList users = this.getSelectedGroupUsers();
        if (users == null) {
            return;
        }
        if (!this.confirmGroupProcess(users, "")) {
            return;
        }
        Iterator i = users.iterator();
        while (i.hasNext()) {
            MsnFriend f = (MsnFriend)i.next();
            try {
                this.msnm.blockFriend(f.getLoginName());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void actionUnblockGroup() {
        ArrayList users = this.getSelectedGroupUsers();
        if (users == null) {
            return;
        }
        if (!this.confirmGroupProcess(users, "")) {
            return;
        }
        Iterator i = users.iterator();
        while (i.hasNext()) {
            MsnFriend f = (MsnFriend)i.next();
            try {
                this.msnm.unBlockFriend(f.getLoginName());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void actionRemoveFriend() {
        block2: {
            String loginName;
            MsnFriend friend = this.buddies.getSelectedFriend();
            if (friend == null || JOptionPane.showConfirmDialog(this.main, Msg.get("remdlg.query.remove.content", loginName = friend.getLoginName()), Msg.get("remdlg.query.remove.title"), 0) != 0) break block2;
            try {
                this.msnm.removeFriend(loginName);
            }
            catch (IOException e) {}
        }
    }

    public void actionAddGroup() {
        AddGroupDialog dialog = new AddGroupDialog((Frame)this.main, this.msnm);
        dialog.show();
    }

    public void actionRenameGroup() {
        Group group = this.buddies.getSelectedGroup();
        if (group != null) {
            Integer gi = group.getIndex();
            String groupName = group.getName();
            RenameGroupDialog dialog = new RenameGroupDialog((Frame)this.main, this.msnm, gi, groupName);
            dialog.show();
        }
    }

    public void actionRemoveGroup() {
        block5: {
            Group group = this.buddies.getSelectedGroup();
            if (group == null) break block5;
            Integer gi = group.getIndex();
            BuddyList fl = this.msnm.getBuddyGroup().getForwardList();
            int i = 0;
            int len = fl.size();
            while (i < len) {
                MsnFriend friend = fl.get(i);
                if (friend.getGroupIndex().equals(gi)) {
                    JOptionPane.showMessageDialog(this.main, Msg.get("remgdlg.exist.content"), Msg.get("remgdlg.exist.title"), 0);
                    return;
                }
                ++i;
            }
            String groupName = group.getName();
            if (JOptionPane.showConfirmDialog(this.main, Msg.get("remgdlg.query.remove.content", groupName), Msg.get("remgdlg.query.remove.title"), 0) == 0) {
                try {
                    this.msnm.removeGroup(group.getIndexInt());
                }
                catch (IOException e) {}
            }
        }
    }

    public void actionStatusChange(ActionEvent evt) {
        String info = evt.getActionCommand();
        String mode = UserStatusBox.getStatusAtFormattedValue(info);
        if (mode == null) {
            return;
        }
        try {
            this.main.setMyStatus(mode);
            this.msnm.setMyStatus(mode);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void actionBuddyView(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(Msg.get("menu.item.friendview.fn"))) {
            this.buddies.setBuddyView(1);
        } else if (cmd.equals(Msg.get("menu.item.friendview.ln"))) {
            this.buddies.setBuddyView(2);
        }
        if (cmd.equals(Msg.get("menu.item.friendview.fnln"))) {
            this.buddies.setBuddyView(3);
        }
    }

    public void actionExit() {
        System.exit(0);
    }

    public void actionAbout() {
        new AboutDialog(this.main).show();
    }

    public void actionOption() {
        new OptionDialog((Frame)this.main, this.msnm).show();
    }

    public void actionBugReport() {
        new ReportDialog((Frame)this.main, this.msnm, Msg.get("title.bugreport"), "BUG").show();
    }

    public void actionFeatureRequest() {
        new ReportDialog((Frame)this.main, this.msnm, Msg.get("title.reqfeature"), "FEATURE REQUEST").show();
    }

    public void actionRefresh() {
        this.main.buddies.syncAllUsers();
    }

    public void actionAlwaysOnTop() {
        NativeToolkit.getInstance().makeTopMost(this.main, !this.isAlwaysOnTop);
        this.isAlwaysOnTop = !this.isAlwaysOnTop;
    }
}

