/*
 * Decompiled with CFR 0.152.
 */
package rath.jmsn;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import rath.jmsn.ActionGroup;
import rath.jmsn.MainFrame;
import rath.jmsn.NativeToolkit;
import rath.jmsn.ToolBox;
import rath.jmsn.ui.WrapMenu;
import rath.jmsn.ui.WrapPopupMenu;
import rath.jmsn.util.Msg;

public class MSNMenuBar
extends JMenuBar
implements ToolBox {
    private JPopupMenu statusPopup = null;
    private JMenuItem menuLogin;
    private JMenuItem menuLogout;
    private JMenuItem menuAddFriend;
    private JMenuItem menuRemoveFriend;
    private JMenuItem menuAddGroup;
    private JMenuItem menuRenameGroup;
    private JMenuItem menuRemoveGroup;
    private JMenuItem menuBlockFriend;
    private JMenuItem menuUnblockFriend;
    private JMenuItem menuBlockGroup;
    private JMenuItem menuUnblockGroup;
    private WrapMenu menuLocale;
    private JMenu menuStat;
    MainFrame main = null;
    JCheckBoxMenuItem menuOffView;

    public MSNMenuBar(MainFrame main, ActionGroup actions) {
        this.main = main;
        this.init(actions);
        this.disableLogin();
    }

    private void init(ActionGroup actions) {
        this.collectActions(actions);
        this.statusPopup = new WrapPopupMenu();
        this.add(this.createFileMenu());
        this.add(this.createViewMenu());
        this.add(this.createToolMenu());
        this.add(this.createHelpMenu());
    }

    public void updateUI() {
        if (this.menuLocale != null) {
            this.menuLocale.removeAll();
            Iterator i = Msg.getAvailableLocales().iterator();
            while (i.hasNext()) {
                final Locale loc = (Locale)i.next();
                System.out.println(loc.getDisplayName());
                JMenuItem item = this.menuLocale.add(loc.getDisplayName(), false);
                item.setFont(ToolBox.FONT);
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Msg.setLocale(loc);
                    }
                });
            }
        }
        if (this.statusPopup != null) {
            this.statusPopup.updateUI();
        }
        super.updateUI();
    }

    protected JMenu createFileMenu() {
        ActionMap action = this.getActionMap();
        WrapMenu menu = new WrapMenu("menu.file");
        menu.setMnemonic(Msg.get("menu.file.mnemonic").charAt(0));
        menu.setFont(ToolBox.MENU_HEADER_FONT);
        this.menuLogin = ((JMenu)menu).add("menu.item.login");
        this.menuLogin.setAccelerator(KeyStroke.getKeyStroke(67, 8));
        this.menuLogin.setFont(ToolBox.MENU_FONT);
        this.menuLogin.addActionListener(action.get("actionLogin"));
        this.menuLogout = ((JMenu)menu).add("menu.item.logout");
        this.menuLogout.setFont(ToolBox.MENU_FONT);
        this.menuLogout.addActionListener(action.get("actionLogout"));
        menu.addSeparator();
        JMenuItem menuExit = ((JMenu)menu).add("menu.item.exit");
        menuExit.setFont(ToolBox.MENU_FONT);
        menuExit.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        menuExit.addActionListener(action.get("actionExit"));
        return menu;
    }

    public JPopupMenu getStatusPopupMenu() {
        return this.statusPopup;
    }

    protected JMenu createViewMenu() {
        ActionMap action = this.getActionMap();
        WrapMenu menu = new WrapMenu("menu.view");
        menu.setMnemonic(Msg.get("menu.view.mnemonic").charAt(0));
        menu.setFont(ToolBox.MENU_HEADER_FONT);
        WrapMenu menuBuddy = new WrapMenu("menu.item.friendview");
        menuBuddy.setFont(ToolBox.MENU_FONT);
        JMenuItem menuFRView = ((JMenu)menuBuddy).add("menu.item.friendview.fn");
        menuFRView.setFont(ToolBox.MENU_FONT);
        menuFRView.addActionListener(action.get("actionBuddyView"));
        JMenuItem menuLGView = ((JMenu)menuBuddy).add("menu.item.friendview.ln");
        menuLGView.setFont(ToolBox.MENU_FONT);
        menuLGView.addActionListener(action.get("actionBuddyView"));
        JMenuItem menuFRLGView = ((JMenu)menuBuddy).add("menu.item.friendview.fnln");
        menuFRLGView.setFont(ToolBox.MENU_FONT);
        menuFRLGView.addActionListener(action.get("actionBuddyView"));
        menu.add(menuBuddy);
        menu.addSeparator();
        JMenuItem menuRefresh = ((JMenu)menu).add("menu.item.refresh");
        menuRefresh.setFont(ToolBox.MENU_FONT);
        menuRefresh.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        menuRefresh.addActionListener(action.get("actionRefresh"));
        this.menuOffView = new JCheckBoxMenuItem(Msg.get("menu.item.off.ignore")){

            public void updateUI() {
                this.setText(Msg.get("menu.item.off.ignore"));
                super.updateUI();
            }
        };
        this.menuOffView.addActionListener(action.get("actionToggleOffView"));
        this.menuOffView.setFont(ToolBox.MENU_FONT);
        menu.add(this.menuOffView);
        menu.addSeparator();
        if (NativeToolkit.getInstance().isWindows) {
            JCheckBoxMenuItem menuAlwaysTop = new JCheckBoxMenuItem(Msg.get("menu.item.alwaysontop")){

                public void updateUI() {
                    this.setText(Msg.get("menu.item.alwaysontop"));
                    super.updateUI();
                }
            };
            menuAlwaysTop.setAccelerator(KeyStroke.getKeyStroke(65, 8));
            menuAlwaysTop.addActionListener(action.get("actionAlwaysOnTop"));
            menuAlwaysTop.setFont(ToolBox.MENU_FONT);
            menu.add(menuAlwaysTop);
        }
        WrapMenu menuUI = new WrapMenu("menu.item.lnf");
        menuUI.setFont(ToolBox.FONT);
        UIManager.LookAndFeelInfo[] lnfs = UIManager.getInstalledLookAndFeels();
        int i = 0;
        while (i < lnfs.length) {
            final UIManager.LookAndFeelInfo info = lnfs[i];
            JMenuItem item = menuUI.add(info.getName(), false);
            item.setFont(ToolBox.FONT);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        UIManager.setLookAndFeel(info.getClassName());
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    MSNMenuBar.this.main.updateUIAll();
                }
            });
            ++i;
        }
        menu.add(menuUI);
        this.menuLocale = new WrapMenu("menu.item.locale");
        this.menuLocale.setFont(ToolBox.FONT);
        Iterator i2 = Msg.getAvailableLocales().iterator();
        while (i2.hasNext()) {
            final Locale loc = (Locale)i2.next();
            JMenuItem item = this.menuLocale.add(loc.getDisplayName(Msg.getCurrentLocale()), false);
            item.setFont(ToolBox.FONT);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Msg.setLocale(loc);
                }
            });
        }
        menu.add(this.menuLocale);
        return menu;
    }

    protected JMenu createToolMenu() {
        ActionMap action = this.getActionMap();
        WrapMenu menu = new WrapMenu("menu.tool");
        menu.setMnemonic(Msg.get("menu.tool.mnemonic").charAt(0));
        menu.setFont(ToolBox.MENU_HEADER_FONT);
        this.menuStat = new WrapMenu("menu.item.chstatus");
        this.menuStat.setFont(ToolBox.MENU_FONT);
        this.addStatusSet(this.menuStat, this.statusPopup, action);
        menu.add(this.menuStat);
        menu.addSeparator();
        this.menuAddFriend = ((JMenu)menu).add("menu.item.adduser");
        this.menuAddFriend.setAccelerator(KeyStroke.getKeyStroke(65, 8));
        this.menuAddFriend.setFont(ToolBox.MENU_FONT);
        this.menuAddFriend.addActionListener(action.get("actionAddFriend"));
        this.menuBlockFriend = ((JMenu)menu).add("menu.item.blockuser");
        this.menuBlockFriend.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        this.menuBlockFriend.setFont(ToolBox.MENU_FONT);
        this.menuBlockFriend.addActionListener(action.get("actionBlockFriend"));
        this.menuUnblockFriend = ((JMenu)menu).add("menu.item.unblockuser");
        this.menuUnblockFriend.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        this.menuUnblockFriend.setFont(ToolBox.MENU_FONT);
        this.menuUnblockFriend.addActionListener(action.get("actionUnblockFriend"));
        this.menuRemoveFriend = ((JMenu)menu).add("menu.item.removeuser");
        this.menuRemoveFriend.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.menuRemoveFriend.setFont(ToolBox.MENU_FONT);
        this.menuRemoveFriend.addActionListener(action.get("actionRemoveFriend"));
        menu.addSeparator();
        this.menuAddGroup = ((JMenu)menu).add("menu.item.addgroup");
        this.menuAddGroup.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.menuAddGroup.setFont(ToolBox.MENU_FONT);
        this.menuAddGroup.addActionListener(action.get("actionAddGroup"));
        this.menuRenameGroup = ((JMenu)menu).add("menu.item.renamegroup");
        this.menuRenameGroup.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.menuRenameGroup.setFont(ToolBox.MENU_FONT);
        this.menuRenameGroup.addActionListener(action.get("actionRenameGroup"));
        this.menuBlockGroup = ((JMenu)menu).add("menu.item.blockgroup");
        this.menuBlockGroup.setFont(ToolBox.MENU_FONT);
        this.menuBlockGroup.addActionListener(action.get("actionBlockGroup"));
        this.menuUnblockGroup = ((JMenu)menu).add("menu.item.unblockgroup");
        this.menuUnblockGroup.setFont(ToolBox.MENU_FONT);
        this.menuUnblockGroup.addActionListener(action.get("actionUnblockGroup"));
        this.menuRemoveGroup = ((JMenu)menu).add("menu.item.removegroup");
        this.menuRemoveGroup.setAccelerator(KeyStroke.getKeyStroke(127, 2));
        this.menuRemoveGroup.setFont(ToolBox.MENU_FONT);
        this.menuRemoveGroup.addActionListener(action.get("actionRemoveGroup"));
        menu.addSeparator();
        JMenuItem menuOption = ((JMenu)menu).add("menu.item.option");
        menuOption.setMnemonic(Msg.get("menu.item.option.mnemonic").charAt(0));
        menuOption.setAccelerator(KeyStroke.getKeyStroke(79, 8));
        menuOption.setFont(ToolBox.MENU_FONT);
        menuOption.addActionListener(action.get("actionOption"));
        return menu;
    }

    private void addStatusSet(JMenu menu, JPopupMenu pop, ActionMap action) {
        String[] codes = new String[]{"status.online", "status.away", "status.brb", "status.busy", "status.idle", "status.eat", "status.phone", "status.hidden"};
        int i = 0;
        while (i < codes.length) {
            JMenuItem item = menu.add(codes[i]);
            item.setFont(ToolBox.FONT);
            item.addActionListener(action.get("actionStatusChange"));
            JMenuItem popItem = pop.add(codes[i]);
            popItem.setFont(ToolBox.FONT);
            popItem.addActionListener(action.get("actionStatusChange"));
            ++i;
        }
    }

    protected JMenu createHelpMenu() {
        ActionMap action = this.getActionMap();
        WrapMenu menu = new WrapMenu("menu.help");
        menu.setMnemonic(Msg.get("menu.help.mnemonic").charAt(0));
        menu.setFont(ToolBox.MENU_HEADER_FONT);
        JMenuItem bugMenu = ((JMenu)menu).add("menu.item.bugreport");
        bugMenu.setFont(ToolBox.MENU_FONT);
        bugMenu.addActionListener(action.get("actionBugReport"));
        bugMenu.setAccelerator(KeyStroke.getKeyStroke(119, 0));
        JMenuItem featureMenu = ((JMenu)menu).add("menu.item.reqfeature");
        featureMenu.setFont(ToolBox.MENU_FONT);
        featureMenu.addActionListener(action.get("actionFeatureRequest"));
        featureMenu.setAccelerator(KeyStroke.getKeyStroke(120, 0));
        menu.addSeparator();
        JMenuItem aboutMenu = ((JMenu)menu).add("menu.item.about");
        aboutMenu.setFont(ToolBox.MENU_FONT);
        aboutMenu.addActionListener(action.get("actionAbout"));
        return menu;
    }

    public void setLoginEnabled(boolean enable) {
        this.menuLogin.setEnabled(enable);
    }

    public boolean isLoginEnabled() {
        return this.menuLogin.isEnabled();
    }

    public void enableLogin() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MSNMenuBar.this.menuLogin.setEnabled(false);
                MSNMenuBar.this.menuLogout.setEnabled(true);
                MSNMenuBar.this.menuAddFriend.setEnabled(true);
                MSNMenuBar.this.menuRemoveFriend.setEnabled(true);
                MSNMenuBar.this.menuAddGroup.setEnabled(true);
                MSNMenuBar.this.menuRenameGroup.setEnabled(true);
                MSNMenuBar.this.menuRemoveGroup.setEnabled(true);
                MSNMenuBar.this.menuStat.setEnabled(true);
                MSNMenuBar.this.menuBlockFriend.setEnabled(true);
                MSNMenuBar.this.menuUnblockFriend.setEnabled(true);
                MSNMenuBar.this.menuBlockGroup.setEnabled(true);
                MSNMenuBar.this.menuUnblockGroup.setEnabled(true);
            }
        });
    }

    public void disableLogin() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MSNMenuBar.this.menuLogin.setEnabled(true);
                MSNMenuBar.this.menuLogout.setEnabled(false);
                MSNMenuBar.this.menuAddFriend.setEnabled(false);
                MSNMenuBar.this.menuRemoveFriend.setEnabled(false);
                MSNMenuBar.this.menuAddGroup.setEnabled(false);
                MSNMenuBar.this.menuRenameGroup.setEnabled(false);
                MSNMenuBar.this.menuRemoveGroup.setEnabled(false);
                MSNMenuBar.this.menuStat.setEnabled(false);
                MSNMenuBar.this.menuBlockFriend.setEnabled(false);
                MSNMenuBar.this.menuUnblockFriend.setEnabled(false);
                MSNMenuBar.this.menuBlockGroup.setEnabled(false);
                MSNMenuBar.this.menuUnblockGroup.setEnabled(false);
            }
        });
    }

    protected void collectActions(final ActionGroup actions) {
        ActionMap action = this.getActionMap();
        Method[] ms = actions.getClass().getMethods();
        int i = 0;
        while (i < ms.length) {
            final Method m = ms[i];
            String name = m.getName();
            if (name.startsWith("action")) {
                action.put(name, new AbstractAction(){

                    public void actionPerformed(ActionEvent e) {
                        block3: {
                            try {
                                if (m.getParameterTypes().length == 0) {
                                    m.invoke((Object)actions, null);
                                    break block3;
                                }
                                m.invoke((Object)actions, e);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                });
            }
            ++i;
        }
    }
}

