/*
 * Decompiled with CFR 0.152.
 */
package rath.jmsn.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import rath.jmsn.ToolBox;
import rath.jmsn.ui.DefaultDialog;
import rath.jmsn.util.Msg;
import rath.msnm.MSNMessenger;
import rath.msnm.entity.MsnFriend;
import rath.msnm.msg.MimeUtility;

public class ReportDialog
extends DefaultDialog
implements ToolBox {
    public static final String REPORT_BUG = "BUG";
    public static final String REPORT_FEATURE = "FEATURE REQUEST";
    private MSNMessenger msnm = null;
    private JTextField lnField = null;
    private JTextField fnField = null;
    private JTextField subjectField = null;
    private JTextArea contentArea = null;
    private String kind;

    public ReportDialog(Frame owner, MSNMessenger msnm, String title, String kind) {
        super(owner);
        this.msnm = msnm;
        this.kind = kind;
        this.setTitle(title);
        this.setModal(false);
        this.createUI();
    }

    private void createUI() {
        this.setSize(350, 300);
        JPanel panel = (JPanel)this.getContentPane();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.createMainPanel(), "Center");
        panel.add((Component)this.createBottomPanel(), "South");
    }

    private JPanel createMainPanel() {
        JPanel panel = new JPanel();
        BoxLayout box = new BoxLayout(panel, 1);
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.setLayout(box);
        JPanel lnPanel = new JPanel(new BorderLayout());
        lnPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 26));
        JLabel l0 = new JLabel(Msg.get("label.loginname"));
        l0.setFont(ToolBox.FONT);
        this.lnField = new JTextField(20);
        this.lnField.setFont(ToolBox.FONT);
        lnPanel.add((Component)l0, "West");
        lnPanel.add((Component)this.lnField, "Center");
        panel.add(lnPanel);
        panel.add(this.createDummyPanel(3));
        JPanel fnPanel = new JPanel(new BorderLayout());
        fnPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 26));
        JLabel l1 = new JLabel(Msg.get("label.friendlyname"));
        l1.setFont(ToolBox.FONT);
        this.fnField = new JTextField(20);
        this.fnField.setFont(ToolBox.FONT);
        fnPanel.add((Component)l1, "West");
        fnPanel.add((Component)this.fnField, "Center");
        panel.add(fnPanel);
        MsnFriend me = this.msnm.getOwner();
        if (me != null) {
            this.lnField.setText(me.getLoginName());
            this.lnField.setEnabled(false);
            this.fnField.setText(me.getFormattedFriendlyName());
            this.fnField.setEnabled(false);
        }
        panel.add(this.createDummyPanel(3));
        JPanel sjPanel = new JPanel(new BorderLayout());
        sjPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 26));
        JLabel l2 = new JLabel(Msg.get("label.subject"));
        l2.setFont(ToolBox.FONT);
        this.subjectField = new JTextField(20);
        this.subjectField.setFont(ToolBox.FONT);
        sjPanel.add((Component)l2, "West");
        sjPanel.add((Component)this.subjectField, "Center");
        panel.add(sjPanel);
        this.contentArea = new JTextArea();
        JScrollPane pane = new JScrollPane(this.contentArea);
        pane.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        panel.add(this.createDummyPanel(3));
        panel.add(pane);
        return panel;
    }

    private JPanel createDummyPanel(int height) {
        JPanel panel = new JPanel();
        panel.setMaximumSize(new Dimension(Short.MAX_VALUE, height));
        return panel;
    }

    private JPanel createBottomPanel() {
        JPanel panel = new JPanel(new FlowLayout(1, 10, 5));
        final JButton sendButton = new JButton(Msg.get("button.submit"));
        sendButton.setFont(ToolBox.FONT);
        sendButton.setMnemonic('S');
        sendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                sendButton.setEnabled(false);
                ReportDialog.this.sendImpl();
                ReportDialog.this.dispose();
            }
        });
        JButton cancelButton = new JButton(Msg.get("button.cancel"));
        cancelButton.setFont(ToolBox.FONT);
        cancelButton.setMnemonic('C');
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ReportDialog.this.dispose();
            }
        });
        panel.add(sendButton);
        panel.add(cancelButton);
        return panel;
    }

    private String encode(String str) throws UnsupportedEncodingException {
        return MimeUtility.getURLEncodedString((String)str, (String)"UTF-8");
    }

    protected void sendImpl() {
        try {
            URLConnection con = new URL("http://xrath.com/report.jsp").openConnection();
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            OutputStream out = con.getOutputStream();
            DataOutputStream dos = new DataOutputStream(out);
            dos.writeBytes("ln=" + this.encode(this.lnField.getText()) + "&fn=" + this.encode(this.fnField.getText()) + "&subject=" + this.encode(this.subjectField.getText()) + "&kind=" + this.kind + "&os=" + System.getProperty("os.name") + "&jvm=" + System.getProperty("java.vm.version") + "&content=" + this.encode(this.contentArea.getText()) + "\r\n\r\n");
            dos.flush();
            InputStream in = con.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String buf = null;
            while ((buf = br.readLine()) != null) {
            }
            in.close();
            out.close();
            dos.close();
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        REPORT_BUG = REPORT_BUG;
        REPORT_FEATURE = REPORT_FEATURE;
    }
}

