/*
 * Decompiled with CFR 0.152.
 */
package rath.tools.tray;

import java.awt.Frame;
import java.awt.Point;
import java.util.HashMap;
import java.util.Iterator;
import rath.tools.Win32Toolkit;
import rath.tools.tray.NativeIcon;
import rath.tools.tray.TrayEventListener;
import rath.tools.tray.TrayIcon;

public class TrayIconManager {
    private final Win32Toolkit toolkit;
    private int uniqueId = 0;
    private long handle = 0L;
    private HashMap listenerMap = null;

    public TrayIconManager(Win32Toolkit toolkit) {
        this.toolkit = toolkit;
        this.listenerMap = new HashMap();
    }

    public synchronized void addTrayIcon(TrayIcon info, TrayEventListener listener) {
        if (this.listenerMap.size() == 0) {
            final Frame temp = new Frame("");
            new Thread(new Runnable(){

                public void run() {
                    temp.pack();
                    TrayIconManager.this.handle = TrayIconManager.this.createTrayHandle(temp);
                    temp.dispose();
                }
            }).start();
            try {
                int retry = 0;
                while (this.handle == 0L || retry < 20) {
                    Thread.currentThread();
                    Thread.sleep(50L);
                    ++retry;
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.handle == 0L) {
                throw new IllegalStateException("handle is not valid");
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    if (TrayIconManager.this.listenerMap.size() == 0) {
                        return;
                    }
                    Iterator i = TrayIconManager.this.listenerMap.keySet().iterator();
                    while (i.hasNext()) {
                        String id = (String)i.next();
                        TrayIconManager.this.removeTrayIcon0(TrayIconManager.this.handle, Integer.parseInt(id));
                    }
                }
            });
        }
        if (this.handle == 0L) {
            throw new IllegalStateException("handle is not valid");
        }
        info.setUniqueID(this.uniqueId++);
        NativeIcon nicon = info.getIcon();
        if (!nicon.isHandleCreated()) {
            nicon.setIconHandle(this.toolkit.createIconFromImage(nicon.getImage()));
        }
        this.listenerMap.put(String.valueOf(info.getUniqueID()), listener);
        this.addTrayIcon0(this.handle, info);
    }

    public synchronized void modifyTrayIcon(TrayIcon info, int modifyField) {
        long iconHandle = 0L;
        Object tipMessage = null;
        if (!this.listenerMap.containsKey(String.valueOf(info.getUniqueID()))) {
            throw new IllegalArgumentException("unregistered trayicon");
        }
        if (this.handle == 0L) {
            throw new IllegalStateException("handle is not valid");
        }
        if ((modifyField & 2) == 2) {
            NativeIcon nicon = info.getIcon();
            if (!nicon.isHandleCreated()) {
                iconHandle = this.toolkit.createIconFromImage(nicon.getImage());
                nicon.setIconHandle(iconHandle);
            } else {
                iconHandle = nicon.getIconHandle();
            }
        }
        this.setTrayIcon0(this.handle, info, modifyField);
    }

    public synchronized void removeTrayIcon(TrayIcon info) {
        int uid = info.getUniqueID();
        if (this.listenerMap.remove(String.valueOf(uid)) == null) {
            throw new IllegalArgumentException("unregistered trayicon");
        }
        if (this.handle == 0L) {
            throw new IllegalStateException("handle is not valid");
        }
        this.removeTrayIcon0(this.handle, uid);
        this.toolkit.destroyIcon(info.getIconHandle());
        if (this.listenerMap.size() == 0) {
            this.destroyTrayHandle(this.handle);
        }
    }

    public void removeNativeIcon(NativeIcon icon) {
        long iconHandle = icon.getIconHandle();
        if (iconHandle != 0L) {
            this.toolkit.destroyIcon(iconHandle);
        }
        icon.flush();
    }

    private void fireTrayEvent(int uid, int eventCode, Point point) {
        TrayEventListener listener = (TrayEventListener)this.listenerMap.get(String.valueOf(uid));
        if (listener != null) {
            switch (eventCode) {
                case 0: {
                    listener.mouseLeftClicked(point);
                    break;
                }
                case 1: {
                    listener.mouseRightClicked(point);
                    break;
                }
                case 2: {
                    listener.mouseDblClicked(point);
                    break;
                }
                case 3: {
                    listener.mouseMove(point);
                }
            }
        }
    }

    private native void addTrayIcon0(long var1, TrayIcon var3);

    private native void setTrayIcon0(long var1, TrayIcon var3, int var4);

    private native void removeTrayIcon0(long var1, int var3);

    private native long createTrayHandle(Frame var1);

    private native void destroyTrayHandle(long var1);
}

