/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.control;

import borland.jbcl.dataset.Column;
import borland.jbcl.dataset.ColumnVariant;
import borland.jbcl.dataset.DataSetException;
import borland.jbcl.dataset.DataSetView;
import borland.jbcl.dataset.PickListDescriptor;
import borland.jbcl.model.ItemEditSite;
import borland.jbcl.model.ItemEditor;
import borland.jbcl.util.Variant;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

public class PickListItemEditor
extends Choice
implements ItemEditor {
    private String sourceColumn;
    private DataSetView pickListDataSet;
    private boolean cache;
    private Variant value;

    public PickListItemEditor() {
        this.setBounds(0, 0, 0, 0);
        this.setVisible(false);
        this.cache = true;
        this.value = new Variant();
    }

    public final void setCachePickList(boolean bl) {
        this.cache = bl;
    }

    public final boolean isCachePickList() {
        return this.cache;
    }

    public final void loadPickList(PickListDescriptor pickListDescriptor) {
        if (this.pickListDataSet == null || !this.cache) {
            try {
                this.pickListDataSet = new DataSetView();
                this.pickListDataSet.setStorageDataSet(pickListDescriptor.getPickListDataSet().getStorageDataSet());
                this.sourceColumn = pickListDescriptor.getPickListColumns()[0];
                this.pickListDataSet.open();
                int n = this.pickListDataSet.getColumn(pickListDescriptor.getPickListDisplayColumns()[0]).getOrdinal();
                while (this.pickListDataSet.inBounds()) {
                    this.add(this.pickListDataSet.format(n));
                    this.pickListDataSet.next();
                }
            }
            catch (Exception exception) {
                this.pickListDataSet = null;
                DataSetException.handleException(exception);
            }
        }
    }

    public Object getValue() {
        if (this.pickListDataSet != null) {
            try {
                this.pickListDataSet.goToRow(this.getSelectedIndex());
                this.pickListDataSet.getVariant(this.sourceColumn, this.value);
                Variant variant = this.value;
                return variant;
            }
            catch (DataSetException dataSetException) {
                this.value.setUnassignedNull();
            }
        }
        return this.value;
    }

    public Component getComponent() {
        return this;
    }

    public void startEdit(Object object, Rectangle rectangle, ItemEditSite itemEditSite) {
        Column column = null;
        ColumnVariant columnVariant = null;
        if (object instanceof ColumnVariant) {
            columnVariant = (ColumnVariant)object;
            this.value.setVariant(columnVariant);
            column = columnVariant.getColumn();
            this.loadPickList(column.getPickList());
        }
        if (column != null) {
            this.select(column.format(columnVariant));
        }
        this.changeBounds(rectangle);
        this.setVisible(true);
        this.requestFocus();
    }

    public void changeBounds(Rectangle rectangle) {
        FontMetrics fontMetrics;
        int n = 0;
        Font font = this.getFont();
        Graphics graphics = this.getGraphics();
        FontMetrics fontMetrics2 = fontMetrics = font != null && graphics != null ? graphics.getFontMetrics(font) : null;
        if (fontMetrics != null) {
            n = fontMetrics.getHeight() * Math.min(this.getItemCount(), 6);
        }
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, Math.min(rectangle.height, n));
    }

    public boolean canPost() {
        return true;
    }

    public void endEdit(boolean bl) {
        this.setBounds(0, 0, 0, 0);
        this.setVisible(false);
    }
}

