/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.control;

import borland.jbcl.control.BevelPanel;
import borland.jbcl.control.Res;
import borland.jbcl.dataset.AccessEvent;
import borland.jbcl.dataset.AccessListener;
import borland.jbcl.dataset.DataSet;
import borland.jbcl.dataset.DataSetException;
import borland.jbcl.dataset.NavigationEvent;
import borland.jbcl.dataset.NavigationListener;
import borland.jbcl.dataset.StatusEvent;
import borland.jbcl.dataset.StatusListener;
import borland.jbcl.util.BlackBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Label;

public class StatusBar
extends BevelPanel
implements NavigationListener,
StatusListener,
AccessListener,
BlackBox {
    protected DataSet dataSet;
    protected Label label = new Label();

    public StatusBar() {
        this.setLayout(new BorderLayout());
        this.setMargins(new Insets(0, 2, 0, 2));
        this.add((Component)this.label, "Center");
    }

    public int getAlignment() {
        return this.label.getAlignment();
    }

    public void setAlignment(int n) {
        this.label.setAlignment(n);
    }

    public String getText() {
        return this.label.getText();
    }

    public void setText(String string) {
        this.label.setText(string);
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet dataSet) {
        this.removeListeners();
        this.dataSet = dataSet;
        this.updateValue();
        this.addListeners();
    }

    private final void removeListeners() {
        if (this.dataSet != null) {
            this.dataSet.removeStatusListener(this);
            this.dataSet.removeNavigationListener(this);
            this.dataSet.removeAccessListener(this);
        }
    }

    private final void addListeners() {
        if (this.dataSet != null) {
            try {
                this.dataSet.addNavigationListener(this);
                this.dataSet.addStatusListener(this);
                this.dataSet.addAccessListener(this);
            }
            catch (DataSetException dataSetException) {
                DataSetException.handleException(this.dataSet, this, dataSetException);
            }
        }
    }

    public void statusMessage(StatusEvent statusEvent) {
        this.setText(statusEvent.getMessage());
    }

    public void accessChange(AccessEvent accessEvent) {
        switch (accessEvent.getID()) {
            case 1: {
                this.updateValue();
                break;
            }
            case 2: {
                this.setText("");
                break;
            }
        }
    }

    public void navigated(NavigationEvent navigationEvent) {
        this.updateValue();
    }

    protected void updateValue() {
        if (this.dataSet != null && this.dataSet.isOpen()) {
            try {
                if (this.dataSet.getRowCount() > 0) {
                    this.setText(Res.format(16, new Long(this.dataSet.getRow() + 1), new Long(this.dataSet.getRowCount())));
                } else {
                    this.setText(Res.getString(17));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return this.getText();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension.width < 200) {
            dimension.width = 200;
        }
        return dimension;
    }
}

