/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.dataset;

import borland.jbcl.dataset.DataColumn;
import borland.jbcl.dataset.NullState;
import borland.jbcl.util.Variant;

class StringColumn
extends DataColumn {
    String pivotValue;
    String[] vector = new String[16];

    public StringColumn(NullState nullState) {
        super(nullState);
        this.vectorLength = this.vector.length;
        this.immutable = true;
    }

    final void copy(int n, int n2) {
        this.vector[n2] = this.vector[n];
        if (this.hasNulls) {
            this.nullState.copy(n, n2, this.nullMask);
        }
    }

    final void copyReference(int n, int n2) {
        this.vector[n2] = this.vector[n];
    }

    protected void grow(int n) {
        String[] stringArray = new String[n];
        System.arraycopy(this.vector, 0, stringArray, 0, this.vectorLength);
        this.vector = stringArray;
        this.vectorLength = this.vector.length;
    }

    int compare(int n, int n2) {
        if (this.hasNulls && (this.comp = this.nullState.compare(n, n2, this.nullMask)) != 0) {
            return this.comp;
        }
        if (this.vector[n] == null) {
            // empty if block
        }
        if (this.vector[n2] == null) {
            // empty if block
        }
        return this.vector[n].compareTo(this.vector[n2]);
    }

    int compareIgnoreCase(int n, int n2) {
        if (this.hasNulls && (this.comp = this.nullState.compare(n, n2, this.nullMask)) != 0) {
            return this.comp;
        }
        return this.compareIgnoreCase(n, this.vector[n2]);
    }

    int compareIgnoreCase(int n, String string) {
        int n2;
        String string2 = this.vector[n];
        int n3 = string2.length();
        int n4 = n3 > (n2 = string.length()) ? n2 : n3;
        for (int i = 0; i < n4; ++i) {
            int n5 = Character.toUpperCase(string2.charAt(i)) - Character.toUpperCase(string.charAt(i));
            if (n5 == 0) continue;
            return n5;
        }
        if (n3 == n2) {
            return 0;
        }
        return n3 - n2;
    }

    void setPivot(int[] nArray, int n) {
        this.indexVector = nArray;
        this.pivotValue = this.vector[n];
    }

    int forwardCompare(int n, boolean bl) {
        if (bl) {
            while ((this.comp = this.compareIgnoreCase(this.indexVector[++n], this.pivotValue)) < 0) {
            }
        } else {
            while ((this.comp = this.vector[this.indexVector[++n]].compareTo(this.pivotValue)) < 0) {
            }
        }
        return n;
    }

    int reverseCompare(int n, boolean bl) {
        if (bl) {
            while ((this.comp = this.compareIgnoreCase(this.indexVector[--n], this.pivotValue)) > 0) {
            }
        } else {
            while ((this.comp = this.vector[this.indexVector[--n]].compareTo(this.pivotValue)) > 0) {
            }
        }
        return n;
    }

    final boolean partialCompare(int n, int n2, boolean bl) {
        return this.vector[n].regionMatches(bl, 0, this.vector[n2], 0, this.vector[n2].length());
    }

    final void getVariant(int n, Variant variant) {
        if (this.hasNulls && this.vector[n] == "\u7fff\u7fff\u7fff") {
            this.nullState.getNull(n, variant, this.nullMask, this.assignedMask);
        } else {
            if (this.hasNulls) {
                int n2 = n;
                this.nullState.vector[n2] = (byte)(this.nullState.vector[n2] & ~this.nullMask);
            }
            variant.setString(this.vector[n]);
        }
    }

    void setVariant(int n, Variant variant) {
        if (variant.isNull()) {
            this.vector[n] = "\u7fff\u7fff\u7fff";
            this.setNull(n, variant.getType());
        } else {
            if (this.hasNulls) {
                int n2 = n;
                this.nullState.vector[n2] = (byte)(this.nullState.vector[n2] & ~this.nullMask);
            }
            this.vector[n] = variant.getString();
            if (this.vector[n] == null) {
                this.vector[n] = "\u7fff\u7fff\u7fff";
                this.setNull(n, 1);
            }
        }
    }
}

