/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.view;

import COM.objectspace.jgl.Pair;
import borland.jbcl.model.ItemPaintSite;
import borland.jbcl.model.ItemPainter;
import borland.jbcl.view.Res;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;

public class CompositeItemPainter
implements ItemPainter {
    private ItemPainter firstPainter;
    private ItemPainter secondPainter;
    private int orientation;
    private int gap;

    public CompositeItemPainter(ItemPainter itemPainter, ItemPainter itemPainter2) {
        this(itemPainter, itemPainter2, 0);
    }

    public CompositeItemPainter(ItemPainter itemPainter, ItemPainter itemPainter2, int n) {
        this(itemPainter, itemPainter2, n, 4);
    }

    public CompositeItemPainter(ItemPainter itemPainter, ItemPainter itemPainter2, int n, int n2) {
        this.firstPainter = itemPainter;
        this.secondPainter = itemPainter2;
        this.orientation = n;
        this.gap = n2;
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public Dimension getPreferredSize(Object object, Graphics graphics, int n, ItemPaintSite itemPaintSite) {
        Dimension dimension;
        Dimension dimension2;
        if (object instanceof Pair) {
            dimension2 = this.firstPainter.getPreferredSize(((Pair)object).first, graphics, n, itemPaintSite);
            dimension = this.secondPainter.getPreferredSize(((Pair)object).second, graphics, n, itemPaintSite);
        } else {
            dimension2 = this.firstPainter.getPreferredSize(object, graphics, n, itemPaintSite);
            dimension = this.secondPainter.getPreferredSize(object, graphics, n, itemPaintSite);
        }
        if (this.orientation == 0) {
            return new Dimension(dimension2.width + this.gap + dimension.width, Math.max(dimension2.height, dimension.height));
        }
        return new Dimension(Math.max(dimension2.width, dimension.width), dimension2.height + this.gap + dimension.height);
    }

    public void paint(Object object, Graphics graphics, Rectangle rectangle, int n, ItemPaintSite itemPaintSite) {
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        this.calculateRects(object, graphics, rectangle, n, itemPaintSite, rectangle2, rectangle3);
        if (object instanceof Pair) {
            this.firstPainter.paint(((Pair)object).first, graphics, rectangle2, n, itemPaintSite);
            this.secondPainter.paint(((Pair)object).second, graphics, rectangle3, n, itemPaintSite);
        } else {
            this.firstPainter.paint(object, graphics, rectangle2, n, itemPaintSite);
            this.secondPainter.paint(object, graphics, rectangle3, n, itemPaintSite);
        }
    }

    public void calculateRects(Object object, Graphics graphics, Rectangle rectangle, int n, ItemPaintSite itemPaintSite, Rectangle rectangle2, Rectangle rectangle3) {
        Dimension dimension;
        Dimension dimension2;
        if (rectangle2 == null || rectangle3 == null) {
            throw new IllegalArgumentException(Res.getString(7));
        }
        if (object instanceof Pair) {
            dimension2 = this.firstPainter.getPreferredSize(((Pair)object).first, graphics, n, itemPaintSite);
            dimension = this.secondPainter.getPreferredSize(((Pair)object).second, graphics, n, itemPaintSite);
        } else {
            dimension2 = this.firstPainter.getPreferredSize(object, graphics, n, itemPaintSite);
            dimension = this.secondPainter.getPreferredSize(object, graphics, n, itemPaintSite);
        }
        if (this.orientation == 0) {
            rectangle2.x = rectangle.x;
            rectangle2.y = rectangle.y + (rectangle.height - dimension2.height) / 2;
            rectangle2.width = dimension2.width;
            rectangle2.height = dimension2.height;
            rectangle3.x = rectangle.x + dimension2.width + this.gap;
            rectangle3.y = rectangle.y + (rectangle.height - dimension.height) / 2;
            rectangle3.width = dimension.width;
            rectangle3.height = dimension.height;
        } else {
            rectangle2.x = rectangle.x + (rectangle.width - dimension2.width) / 2;
            rectangle2.y = rectangle.y;
            rectangle2.width = dimension2.width;
            rectangle2.height = dimension2.height;
            rectangle3.x = rectangle.x + (rectangle.width - dimension.width) / 2;
            rectangle3.y = rectangle.y + dimension2.height + this.gap;
            rectangle3.width = dimension.width;
            rectangle3.height = dimension.height;
        }
    }
}

