/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jclass.bwt.JCMultiColumnInterface;
import jclass.util.JCString;
import jclass.util.JCUtilConverter;

public class BWTUtil {
    protected static Hashtable images = new Hashtable(5);
    private static final Color WHITE_BRIGHTER = new Color(200, 200, 200);
    private static final Color WHITE_DARKER = new Color(140, 140, 140);
    private static final Color BLACK_BRIGHTER = new Color(125, 125, 125);
    private static final Color BLACK_DARKER = new Color(75, 75, 75);
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;

    public static final Object[] copyList(Object[] objectArray, int n, Object object) {
        if (objectArray != null && n <= objectArray.length) {
            return objectArray;
        }
        Object[] objectArray2 = objectArray;
        int n2 = objectArray2 != null ? objectArray2.length : 0;
        objectArray = new Object[n];
        if (objectArray2 != null) {
            System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
        }
        for (int i = n2; i < objectArray.length; ++i) {
            objectArray[i] = object;
        }
        return objectArray;
    }

    public static final int[] copyList(int[] nArray, int n, int n2) {
        if (nArray != null && n <= nArray.length) {
            return nArray;
        }
        int[] nArray2 = nArray;
        int n3 = nArray2 != null ? nArray2.length : 0;
        nArray = new int[n];
        if (nArray2 != null) {
            System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
        }
        for (int i = n3; i < nArray.length; ++i) {
            nArray[i] = n2;
        }
        return nArray;
    }

    public static final boolean[] copyList(boolean[] blArray, int n, boolean bl) {
        if (blArray != null && n <= blArray.length) {
            return blArray;
        }
        boolean[] blArray2 = blArray;
        int n2 = blArray2 != null ? blArray2.length : 0;
        blArray = new boolean[n];
        if (blArray2 != null) {
            System.arraycopy(blArray2, 0, blArray, 0, blArray2.length);
        }
        for (int i = n2; i < blArray.length; ++i) {
            blArray[i] = bl;
        }
        return blArray;
    }

    public static final boolean intersects(Component component, int n, int n2, int n3, int n4) {
        return component.size().width > n && component.size().height > n2 && n + n3 >= 0 && n2 + n4 >= 0;
    }

    public static int countChar(String string, char c, int n, int n2) {
        if (string == null || n >= string.length() || n >= n2) {
            return 0;
        }
        if (n < 0) {
            n = 0;
        }
        int n3 = 0;
        n = string.indexOf(c, n);
        while (n < n2 && n != -1) {
            ++n;
            ++n3;
            n = string.indexOf(c, n);
        }
        return n3;
    }

    static final int indexOf(char[] cArray, int n, int n2, int n3) {
        for (int i = n3; i < n; ++i) {
            if (cArray[i] != n2) continue;
            return i;
        }
        return -1;
    }

    public static int countChar(char[] cArray, int n, char c, int n2, int n3) {
        if (cArray == null || n2 >= n || n2 >= n3) {
            return 0;
        }
        n3 = Math.min(n3, n);
        if (n2 < 0) {
            n2 = 0;
        }
        int n4 = 0;
        n2 = BWTUtil.indexOf(cArray, n, c, n2);
        while (n2 < n3 && n2 != -1) {
            ++n2;
            ++n4;
            n2 = BWTUtil.indexOf(cArray, n, c, n2);
        }
        return n4;
    }

    public static Point translateToParent(Container container, Component component, int n, int n2) {
        while (component != null && component != container) {
            n += component.location().x;
            n2 += component.location().y;
            component = component.getParent();
        }
        return new Point(n, n2);
    }

    public static Point translateFromParent(Container container, Component component, int n, int n2) {
        while (component != null && component != container) {
            n -= component.location().x;
            n2 -= component.location().y;
            component = component.getParent();
        }
        return new Point(n, n2);
    }

    public static Point getVisibleScreenLoc(Component component, int n, int n2, int n3, int n4) {
        Point point = BWTUtil.translateToParent(null, component, n, n2);
        Dimension dimension = component.getToolkit().getScreenSize();
        point.x = Math.max(0, Math.min(point.x, dimension.width - n3));
        point.y = Math.max(0, Math.min(point.y, dimension.height - n4));
        return point;
    }

    static synchronized Image createImage(Component component, Image image, int n, int n2) {
        Dimension dimension = component.getToolkit().getScreenSize();
        n = Math.max(1, Math.min(n, dimension.width));
        n2 = Math.max(1, Math.min(n2, dimension.height));
        try {
            if (image == null || image.getWidth(null) < n || image.getHeight(null) < n2) {
                image = component.createImage(n, n2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return image;
    }

    static synchronized Image createImage(Component component, int n, int n2) {
        Thread thread;
        Enumeration enumeration = images.keys();
        while (enumeration.hasMoreElements()) {
            thread = (Thread)enumeration.nextElement();
            if (thread.isAlive()) continue;
            images.remove(thread);
        }
        thread = Thread.currentThread();
        Image image = (Image)images.get(thread);
        Image image2 = BWTUtil.createImage(component, image, n, n2);
        if (image2 != image) {
            images.remove(thread);
            if (image2 != null) {
                images.put(thread, image2);
            }
        }
        return image2;
    }

    public static Frame getFrame(Component component) {
        Component component2 = component;
        Component component3 = component;
        while (component3 != null && !(component3 instanceof Frame)) {
            component3 = component2;
            if (component2 == null) {
                return null;
            }
            component2 = component2.getParent();
        }
        return (Frame)component3;
    }

    public static Applet getApplet(Component component) {
        if (component == null) {
            return null;
        }
        Container container = component.getParent();
        Container container2 = component.getParent();
        while (container2 != null && !(container2 instanceof Applet)) {
            container2 = container;
            container = container == null ? null : container.getParent();
        }
        return (Applet)container2;
    }

    public static AppletContext getAppletContext(Applet applet) {
        if (applet != null) {
            try {
                AppletContext appletContext = applet.getAppletContext();
                return appletContext;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean inBrowser(Component component) {
        return BWTUtil.getAppletContext(BWTUtil.getApplet(component)) != null;
    }

    public static Color brighter(Color color) {
        if (color.equals(Color.white)) {
            return WHITE_BRIGHTER;
        }
        if (color.equals(Color.black)) {
            return BLACK_BRIGHTER;
        }
        return color.brighter();
    }

    public static Color darker(Color color) {
        if (color.equals(Color.white)) {
            return WHITE_DARKER;
        }
        if (color.equals(Color.black)) {
            return BLACK_DARKER;
        }
        return color.darker();
    }

    public static boolean instanceOf(Object object, String string) {
        boolean bl;
        if (object == null) {
            return false;
        }
        Class<?> clazz = object.getClass();
        while (!(bl = clazz.getName().indexOf(string) != -1) && (clazz = clazz.getSuperclass()) != null) {
        }
        return bl;
    }

    static boolean is_jcstring(Object object) {
        return BWTUtil.instanceOf(object, "JCString");
    }

    public static boolean isParent(Component component, Component component2) {
        if (component2 == component) {
            return true;
        }
        if (component == null || component2 == null || !(component instanceof Container)) {
            return false;
        }
        for (Container container = component2.getParent(); container != null; container = container.getParent()) {
            if (container != component) continue;
            return true;
        }
        return false;
    }

    public static int getWidth(Vector vector, JCMultiColumnInterface jCMultiColumnInterface) {
        if (vector == null) {
            return 0;
        }
        int n = Math.min(jCMultiColumnInterface.getNumColumns(), vector.size());
        if (n == 0) {
            return 0;
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += jCMultiColumnInterface.getColumnWidth(i);
        }
        return n2;
    }

    public static int getWidth(Object object, Component component) {
        return BWTUtil.getWidth(object, component, component.getFont());
    }

    public static int getWidth(Object object, Component component, Font font) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Image) {
            return ((Image)object).getWidth(null);
        }
        if (BWTUtil.is_jcstring(object)) {
            return ((JCString)object).getWidth(component, font);
        }
        if (object instanceof Vector && component instanceof JCMultiColumnInterface) {
            return BWTUtil.getWidth((Vector)object, (JCMultiColumnInterface)((Object)component));
        }
        if (object instanceof Vector) {
            int n = 0;
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                n += BWTUtil.getWidth(((Vector)object).elementAt(i), component);
            }
            return n;
        }
        String string = object.toString();
        if (string == null || string.length() == 0) {
            return 0;
        }
        FontMetrics fontMetrics = component.getToolkit().getFontMetrics(font);
        if (string.indexOf(10) != -1) {
            int n;
            int n2 = 0;
            int n3 = 0;
            while ((n = string.indexOf(10, n2)) != -1) {
                n3 = Math.max(n3, BWTUtil.stringWidth(fontMetrics, font, string.substring(n2, n)));
                if (font.isItalic()) {
                    n3 += 5;
                }
                n2 = n + 1;
            }
            return Math.max(n3, BWTUtil.stringWidth(fontMetrics, font, string.substring(n2, string.length())));
        }
        return BWTUtil.stringWidth(fontMetrics, font, string);
    }

    static int stringWidth(FontMetrics fontMetrics, Font font, String string) {
        return fontMetrics.stringWidth(string) + (font.isItalic() ? font.getSize() / 3 + 1 : 0);
    }

    public static int getHeight(Object object, Component component) {
        return BWTUtil.getHeight(object, component, component.getFont());
    }

    public static int getHeight(Object object, Component component, Font font) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Image) {
            return ((Image)object).getHeight(null);
        }
        if (BWTUtil.is_jcstring(object)) {
            return ((JCString)object).getHeight(component, font);
        }
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            int n = 0;
            for (int i = 0; i < vector.size(); ++i) {
                n = Math.max(n, BWTUtil.getHeight(vector.elementAt(i), component, font));
            }
            return n;
        }
        return component.getToolkit().getFontMetrics(font).getHeight() * BWTUtil.getNumLines(object.toString());
    }

    private static int getNumLines(String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        int n = 1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\n') continue;
            ++n;
        }
        return n;
    }

    public static int getNumLines(Object object) {
        return BWTUtil.getNumLines(BWTUtil.toString(object));
    }

    static String toString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Image) {
            return null;
        }
        if (BWTUtil.is_jcstring(object)) {
            return ((JCString)object).getString();
        }
        if (object instanceof Vector) {
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                String string = BWTUtil.toString(((Vector)object).elementAt(i));
                if (string == null) continue;
                return string;
            }
            return null;
        }
        return object.toString();
    }

    static boolean startsWith(Object object, char c) {
        String string = BWTUtil.toString(object);
        return string != null && string.length() > 0 ? Character.toUpperCase(string.charAt(0)) == c : false;
    }

    public static int toHorizAlignment(int n) {
        return BWTUtil.isCenter(n) ? 1 : (BWTUtil.isRight(n) ? 2 : 0);
    }

    static boolean isRight(int n) {
        return n == 2 || n == 5 || n == 8;
    }

    static boolean isCenter(int n) {
        return n == 1 || n == 4 || n == 7;
    }

    static boolean isTop(int n) {
        return n == 0 || n == 1 || n == 2;
    }

    static boolean isMiddle(int n) {
        return n == 3 || n == 4 || n == 5;
    }

    static boolean isBottom(int n) {
        return n == 6 || n == 7 || n == 8;
    }

    public static synchronized void draw(Component component, Graphics graphics, Object object, int n, Rectangle rectangle) {
        int n2;
        if (object == null) {
            return;
        }
        int n3 = BWTUtil.toHorizAlignment(n);
        if (BWTUtil.is_jcstring(object)) {
            ((JCString)object).draw(component, graphics, rectangle, n3);
            return;
        }
        if (object instanceof Image) {
            graphics.drawImage((Image)object, rectangle.x, rectangle.y, null);
            return;
        }
        String string = object.toString();
        if (string == null || string.length() == 0) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Font font = graphics.getFont();
        int n4 = fontMetrics.getHeight();
        int n5 = 0;
        int n6 = n4 - fontMetrics.getAscent();
        int n7 = rectangle.y + n4 - n6;
        int n8 = n2 = BWTUtil.isTop(n) ? 0 : BWTUtil.getHeight(string, component, font);
        if (BWTUtil.isBottom(n)) {
            n7 += rectangle.height - n2;
        } else if (BWTUtil.isMiddle(n)) {
            n7 += (rectangle.height - n2) / 2;
        }
        if (string.indexOf(10) != -1) {
            String string2;
            int n9;
            int n10 = 0;
            int n11 = rectangle.x;
            while ((n9 = string.indexOf(10, n10)) != -1) {
                string2 = string.substring(n10, n9);
                if (n3 == 1) {
                    n5 = (rectangle.width - BWTUtil.stringWidth(fontMetrics, font, string2)) / 2;
                } else if (n3 == 2) {
                    n5 = rectangle.width - BWTUtil.stringWidth(fontMetrics, font, string2);
                }
                graphics.drawString(string2, rectangle.x + n5, n7);
                n10 = n9 + 1;
                n7 += n4;
            }
            string2 = string.substring(n10, string.length());
            if (n3 == 1) {
                n5 = (rectangle.width - BWTUtil.stringWidth(fontMetrics, font, string2)) / 2;
            } else if (n3 == 2) {
                n5 = rectangle.width - BWTUtil.stringWidth(fontMetrics, font, string2);
            }
            graphics.drawString(string2, rectangle.x + n5, n7);
        } else {
            if (n3 == 1) {
                n5 = (rectangle.width - BWTUtil.stringWidth(fontMetrics, font, string)) / 2;
            } else if (n3 == 2) {
                n5 = rectangle.width - BWTUtil.stringWidth(fontMetrics, font, string);
            }
            graphics.drawString(string, rectangle.x + n5, n7);
        }
    }

    public static void trace() {
        try {
            throw new ArrayIndexOutOfBoundsException("");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return;
        }
    }

    public static void drawDashedLine(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = Math.min(n, n3);
        int n6 = Math.min(n2, n4);
        int n7 = Math.max(n, n3);
        int n8 = Math.max(n2, n4);
        if (n3 == n) {
            int n9 = n6;
            while (n9 < n8) {
                graphics.drawLine(n, n9, n, n9 + 1);
                n9 = Math.min(n9 + 3, n8);
            }
        } else {
            int n10 = n5;
            while (n10 < n7) {
                graphics.drawLine(n10, n2, n10 + 1, n2);
                n10 = Math.min(n10 + 3, n7);
            }
        }
    }

    public static void drawDashedRect(Graphics graphics, int n, int n2, int n3, int n4) {
        BWTUtil.drawDashedLine(graphics, n, n2, n + n3, n2);
        BWTUtil.drawDashedLine(graphics, n + n3, n2, n + n3, n2 + n4);
        BWTUtil.drawDashedLine(graphics, n, n2, n, n2 + n4);
        BWTUtil.drawDashedLine(graphics, n, n2 + n4, n + n3, n2 + n4);
    }

    static void fill3DRect(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        Color color = graphics.getColor();
        Color color2 = BWTUtil.brighter(color);
        Color color3 = BWTUtil.darker(color);
        if (!bl) {
            graphics.setColor(color3);
        }
        graphics.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        graphics.setColor(bl ? color2 : color3);
        graphics.drawLine(n, n2, n, n2 + n4 - 1);
        graphics.drawLine(n + 1, n2, n + n3 - 2, n2);
        graphics.setColor(bl ? color3 : color2);
        graphics.drawLine(n + 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 2);
        graphics.setColor(color);
    }

    static void fill3DEdgeRect(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        Color color = graphics.getColor();
        BWTUtil.fill3DRect(graphics, n + 1, n2 + 1, n3 - 2, n4 - 2, bl);
        graphics.setColor(Color.black);
        graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        graphics.setColor(color);
    }

    public static void wallPaper(Component component, Graphics graphics, Image image) {
        Dimension dimension = component.size();
        if (!JCUtilConverter.waitForImage(component, image)) {
            return;
        }
        int n = image.getWidth(component);
        int n2 = image.getHeight(component);
        for (int i = 0; i < dimension.width; i += n) {
            for (int j = 0; j < dimension.height; j += n2) {
                graphics.drawImage(image, i, j, component);
            }
        }
    }

    public static int getMouseButton(Event event) {
        if (event.metaDown()) {
            return 3;
        }
        if ((event.modifiers & 8) != 0) {
            return 2;
        }
        return 1;
    }

    public static void setCursor(Component component, int n) {
        Frame frame = BWTUtil.getFrame(component);
        if (frame != null && frame.getCursorType() != n) {
            frame.setCursor(n);
            frame.getToolkit().sync();
        }
    }
}

