/*
 * Decompiled with CFR 0.152.
 */
package jclass.util;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.net.URL;
import jclass.util.JCStringTokenizer;
import jclass.util.JCUtilConverter;
import jclass.util.JCVector;

public class JCString
extends JCVector {
    public static final Integer UNDERLINE = new Integer(-2);
    public static final Integer STRIKETHROUGH = new Integer(-3);
    public static final Integer END_UNDERLINE = new Integer(-4);
    public static final Integer END_STRIKETHROUGH = new Integer(-5);
    public static final Integer HORIZ_SPACE = new Integer(-6);
    public static final Integer VERT_SPACE = new Integer(-7);
    public static final Integer NEWLINE = new Integer(-8);
    public static final Integer RESET = new Integer(-9);
    public static final Integer DEFAULT_FONT = new Integer(-10);
    public static final Integer DEFAULT_COLOR = new Integer(-11);
    public static final Integer TOP = new Integer(-17);
    public static final Integer MIDDLE = new Integer(-18);
    public static final Integer BOTTOM = new Integer(-19);
    public static final Integer LEFT = new Integer(-17);
    public static final Integer CENTER = new Integer(-18);
    public static final Integer RIGHT = new Integer(-19);
    public static final Integer HREF = new Integer(-21);
    public static final Integer END_HREF = new Integer(-22);
    public static final int STRING_LEFT = 0;
    public static final int STRING_RIGHT = 1;
    public static final int STRING_TOP = 2;
    public static final int STRING_BOTTOM = 3;
    static final int NOTFOUND = -1;
    static final int DEFAULT_SPACE = 10;
    static boolean underline = false;
    static boolean strikethrough = false;
    static Dimension size = new Dimension();
    static Rectangle draw_rect = new Rectangle();
    Rectangle url_rect;
    String url;
    JCVector url_rect_list;
    JCVector url_list;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    int x_offset;
    int y_offset;
    static boolean has_url = false;

    public JCString() {
    }

    public JCString(int n) {
        super(n);
    }

    public JCString(String string) {
        super(1);
        this.addString(string);
    }

    public JCString(String string, Image image, int n) {
        this(5);
        if (string == null) {
            this.add(image);
            return;
        }
        if (image == null) {
            this.add(string);
            return;
        }
        switch (n) {
            case 0: {
                this.add(string);
                this.add(MIDDLE);
                this.add(HORIZ_SPACE);
                this.add(image);
                break;
            }
            case 2: {
                this.add(string);
                this.add(NEWLINE);
                this.add(VERT_SPACE);
                this.add(new Integer(5));
                this.add(image);
                break;
            }
            case 3: {
                this.add(image);
                this.add(NEWLINE);
                this.add(VERT_SPACE);
                this.add(new Integer(5));
                this.add(string);
                break;
            }
            default: {
                this.add(image);
                this.add(MIDDLE);
                this.add(HORIZ_SPACE);
                this.add(string);
            }
        }
    }

    private void addString(String string) {
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf("\n", n)) != -1) {
            this.addElement(string.substring(n, n2));
            this.addElement(NEWLINE);
            n = n2 + 1;
        }
        this.addElement(string.substring(n));
    }

    private boolean isValue(Object object) {
        return object instanceof Integer && (Integer)object >= 0;
    }

    public void add(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof String) {
            this.addString((String)object);
        } else {
            this.addElement(object);
        }
    }

    public void add(int n) {
        this.addElement(new Integer(n));
    }

    public void add(int n, Object object) {
        this.add(n);
        this.add(object);
    }

    private void init() {
        strikethrough = false;
        underline = false;
    }

    private static void parseToken(Component component, JCString jCString, String string) {
        if (string == null) {
            return;
        }
        String string2 = null;
        String string3 = string;
        int n = string.indexOf(61);
        if (n != -1) {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        if (string3.equalsIgnoreCase("DEFAULT_FONT")) {
            jCString.add(DEFAULT_FONT);
        } else if (string3.equalsIgnoreCase("DEFAULT_COLOR")) {
            jCString.add(DEFAULT_COLOR);
        } else if (string3.equalsIgnoreCase("UNDERLINE") || string3.equalsIgnoreCase("UL")) {
            jCString.add(UNDERLINE);
        } else if (string3.equalsIgnoreCase("/UNDERLINE") || string3.equalsIgnoreCase("/UL")) {
            jCString.add(END_UNDERLINE);
        } else if (string3.equalsIgnoreCase("STRIKETHROUGH") || string3.equalsIgnoreCase("ST")) {
            jCString.add(STRIKETHROUGH);
        } else if (string3.equalsIgnoreCase("/STRIKETHROUGH") || string3.equalsIgnoreCase("/ST")) {
            jCString.add(END_STRIKETHROUGH);
        } else if (string3.equalsIgnoreCase("HREF")) {
            jCString.add(HREF);
            jCString.add(string2);
        } else if (string3.equalsIgnoreCase("/HREF")) {
            jCString.add(END_HREF);
        } else if (string3.equalsIgnoreCase("ALIGN")) {
            if (string2.equalsIgnoreCase("TOP")) {
                jCString.add(TOP);
            } else if (string2.equalsIgnoreCase("MIDDLE")) {
                jCString.add(MIDDLE);
            } else if (string2.equalsIgnoreCase("BOTTOM")) {
                jCString.add(BOTTOM);
            }
        } else if (string3.equalsIgnoreCase("HORIZ_SPACE")) {
            jCString.add(HORIZ_SPACE);
            if (string2 != null) {
                jCString.add(Integer.valueOf(string2));
            }
        } else if (string3.equalsIgnoreCase("VERT_SPACE")) {
            jCString.add(VERT_SPACE);
            if (string2 != null) {
                jCString.add(Integer.valueOf(string2));
            }
        } else if (string3.equalsIgnoreCase("RESET")) {
            jCString.add(RESET);
        } else if (string3.equalsIgnoreCase("COLOR")) {
            if (string2 != null) {
                if (string2.equalsIgnoreCase("DEFAULT")) {
                    jCString.add(DEFAULT_COLOR);
                } else {
                    jCString.add(JCUtilConverter.toColor(string2));
                }
            }
        } else if (string3.equalsIgnoreCase("IMAGE") || string3.equalsIgnoreCase("IMG")) {
            if (string2 != null) {
                jCString.add(JCUtilConverter.toImage(component, string2));
            }
        } else if (string3.equalsIgnoreCase("FONT")) {
            if (string2 != null) {
                if (string2.equalsIgnoreCase("DEFAULT")) {
                    jCString.add(DEFAULT_FONT);
                } else {
                    jCString.add(JCUtilConverter.toFont(string2));
                }
            }
        } else if (string3.equalsIgnoreCase("NEWLINE")) {
            jCString.add(NEWLINE);
        }
    }

    public static JCString parse(Component component, String string) {
        if (string == null) {
            return null;
        }
        JCString jCString = new JCString();
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        while (jCStringTokenizer.hasMoreTokens()) {
            String string2 = jCStringTokenizer.nextToken('[');
            jCString.add(string2);
            if (!jCStringTokenizer.hasMoreTokens()) continue;
            string2 = jCStringTokenizer.nextToken(']').trim();
            JCString.parseToken(component, jCString, string2);
        }
        return jCString;
    }

    public static Applet getApplet(Component component) {
        if (component == null) {
            return null;
        }
        Container container = component.getParent();
        Container container2 = component.getParent();
        while (container2 != null && !(container2 instanceof Applet)) {
            container2 = container;
            container = container == null ? null : container.getParent();
        }
        return (Applet)container2;
    }

    private boolean addImage(Applet applet, URL uRL, String string) {
        MediaTracker mediaTracker = new MediaTracker(applet);
        Image image = applet.getImage(uRL, string);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            boolean bl = false;
            return bl;
        }
        this.add(image);
        return true;
    }

    public boolean addImage(Applet applet, String string) {
        return this.addImage(applet, applet.getDocumentBase(), string);
    }

    public boolean addImage(Applet applet, String string, String string2) {
        try {
            this.addImage(applet, new URL(string), string2);
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public int getHeight(Component component, Font font) {
        return this.getSize((Component)component, (Font)font).height;
    }

    public int getWidth(Component component, Font font) {
        return this.getSize((Component)component, (Font)font).width;
    }

    public Dimension getSize(Component component, Font font) {
        Dimension dimension = new Dimension();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (font == null) {
            font = component.getFont();
        }
        this.init();
        while ((n = this.getLineSize(component, font, n, dimension)) != -1) {
            n2 = Math.max(n2, dimension.width);
            n3 += dimension.height;
        }
        dimension.width = n2;
        dimension.height = n3;
        return dimension;
    }

    static int stringWidth(FontMetrics fontMetrics, Font font, String string) {
        return fontMetrics.stringWidth(string) + (font.isItalic() ? font.getSize() / 3 + 1 : 0);
    }

    public int getLineSize(Component component, Font font, int n, Dimension dimension) {
        int n2;
        if (n >= this.size()) {
            return -1;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        Graphics graphics = component.getGraphics();
        for (n2 = n; n2 >= 0; --n2) {
            if (this.elementData[n2] instanceof Font) {
                graphics.setFont((Font)this.elementData[n2]);
                break;
            }
            if (!this.elementData[n2].equals(DEFAULT_FONT)) continue;
            graphics.setFont(font);
            break;
        }
        if (n2 < 0 && font != null) {
            graphics.setFont(font);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        for (n2 = n; n2 < this.size(); ++n2) {
            if (this.elementData[n2] instanceof String) {
                n7 = Math.max(n7, fontMetrics.getHeight());
                n6 += JCString.stringWidth(fontMetrics, graphics.getFont(), (String)this.elementData[n2]);
                continue;
            }
            if (this.elementData[n2] instanceof Font) {
                graphics.setFont((Font)this.elementData[n2]);
                fontMetrics = graphics.getFontMetrics();
                continue;
            }
            if (this.elementData[n2] instanceof Image) {
                Image image = (Image)this.elementData[n2];
                n7 = Math.max(n7, image.getHeight(null));
                n6 += image.getWidth(null);
                continue;
            }
            if (this.elementData[n2].equals(HREF)) {
                ++n2;
                continue;
            }
            if (this.elementData[n2].equals(DEFAULT_FONT)) {
                graphics.setFont(font);
                fontMetrics = graphics.getFontMetrics();
                continue;
            }
            if (this.elementData[n2].equals(HORIZ_SPACE)) {
                if (n2 < this.size() - 1 && this.isValue(this.elementData[n2 + 1])) {
                    n6 += ((Integer)this.elementData[++n2]).intValue();
                    continue;
                }
                n6 += 10;
                continue;
            }
            if (this.elementData[n2].equals(VERT_SPACE)) {
                if (n2 < this.size() - 1 && this.isValue(this.elementData[n2 + 1])) {
                    n3 = (Integer)this.elementData[++n2];
                    continue;
                }
                n3 = 10;
                continue;
            }
            if (!this.elementData[n2].equals(NEWLINE)) continue;
            n4 += n7;
            n5 = Math.max(n5, n6);
            n6 = 0;
            n7 = 0;
            break;
        }
        dimension.width = Math.max(n5, n6);
        dimension.height = n4 + n7 + n3;
        return n2 + 1;
    }

    int getVertSpace(int n, int n2) {
        for (int i = n; i < n2 && i < this.size(); ++i) {
            if (!this.elementData[i].equals(VERT_SPACE)) continue;
            if (i < this.size() - 1 && this.isValue(this.elementData[i + 1])) {
                return (Integer)this.elementData[++i];
            }
            return 10;
        }
        return 0;
    }

    public void draw(Component component, Graphics graphics, Rectangle rectangle, int n) {
        int n2;
        int n3 = 0;
        int n4 = rectangle.y;
        this.url = null;
        this.url_rect_list = null;
        this.url_list = null;
        Font font = graphics.getFont();
        this.init();
        while ((n2 = this.getLineSize(component, font, n3, size)) != -1) {
            int n5 = this.getVertSpace(n3, n2);
            JCString.size.height -= n5;
            draw_rect.reshape(rectangle.x, n4 += n5, JCString.size.width, JCString.size.height);
            if (n == 1) {
                JCString.draw_rect.x += (rectangle.width - JCString.size.width) / 2;
            } else if (n == 2) {
                JCString.draw_rect.x += rectangle.width - JCString.size.width;
            }
            this.drawLine(component, graphics, font, draw_rect, n3, n2);
            n3 = n2;
            n4 += JCString.size.height;
        }
    }

    public void setURLoffset(int n, int n2) {
        this.x_offset = n;
        this.y_offset = n2;
    }

    private void startURL(int n, int n2) {
        this.url_rect = new Rectangle();
        this.url_rect.x = n;
        this.url_rect.y = n2;
        if (this.url_list == null) {
            this.url_list = new JCVector();
        }
        if (this.url_rect_list == null) {
            this.url_rect_list = new JCVector();
        }
    }

    private void endURL(Graphics graphics, int n, int n2) {
        this.url_list.addElement(this.url);
        this.url_rect.width = n - this.url_rect.x;
        this.url_rect.height = n2 - this.url_rect.y;
        this.url_rect.translate(this.x_offset, this.y_offset);
        this.url_rect_list.addElement(this.url_rect);
    }

    void drawLine(Component component, Graphics graphics, Font font, Rectangle rectangle, int n, int n2) {
        Integer n3 = BOTTOM;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        for (int i = n; i < n2 && i < this.size(); ++i) {
            if (this.elementData[i] instanceof String) {
                int n6 = fontMetrics.getHeight();
                int n7 = n6 - fontMetrics.getAscent();
                if (n3.equals(BOTTOM)) {
                    n5 = rectangle.y + rectangle.height - n7;
                } else if (n3.equals(MIDDLE)) {
                    n5 = rectangle.y + (rectangle.height - n6) / 2 + n6 - n7;
                } else if (n3.equals(TOP)) {
                    n5 = rectangle.y + n6 - n7;
                }
                graphics.drawString((String)this.elementData[i], n4, n5);
                if (this.url != null) {
                    this.startURL(n4, n5 - n6);
                }
                int n8 = JCString.stringWidth(fontMetrics, graphics.getFont(), (String)this.elementData[i]);
                if (underline) {
                    graphics.drawLine(n4, n5 + 1, n4 + n8, n5 + 1);
                }
                if (strikethrough) {
                    graphics.drawLine(n4, n5 - n6 / 2 + 3, n4 + n8, n5 - n6 / 2 + 3);
                }
                n4 += n8;
                if (this.url == null) continue;
                this.endURL(graphics, n4, n5);
                continue;
            }
            if (this.elementData[i] instanceof Image) {
                if (this.url != null) {
                    this.startURL(n4, rectangle.y);
                }
                graphics.drawImage((Image)this.elementData[i], n4, rectangle.y, null);
                n4 += ((Image)this.elementData[i]).getWidth(null);
                if (this.url == null) continue;
                this.endURL(graphics, n4, rectangle.y + rectangle.height);
                continue;
            }
            if (this.elementData[i] instanceof Font) {
                graphics.setFont((Font)this.elementData[i]);
                fontMetrics = graphics.getFontMetrics();
                continue;
            }
            if (this.elementData[i].equals(DEFAULT_FONT)) {
                graphics.setFont(font);
                fontMetrics = graphics.getFontMetrics();
                continue;
            }
            if (this.elementData[i].equals(DEFAULT_COLOR)) {
                graphics.setColor(component.getForeground());
                continue;
            }
            if (this.elementData[i].equals(HREF)) {
                underline = true;
                this.url = (String)this.elementData[++i];
                continue;
            }
            if (this.elementData[i].equals(UNDERLINE)) {
                underline = true;
                continue;
            }
            if (this.elementData[i].equals(END_UNDERLINE)) {
                underline = false;
                continue;
            }
            if (this.elementData[i].equals(END_HREF)) {
                underline = false;
                this.url = null;
                continue;
            }
            if (this.elementData[i].equals(STRIKETHROUGH)) {
                strikethrough = true;
                continue;
            }
            if (this.elementData[i].equals(END_STRIKETHROUGH)) {
                strikethrough = false;
                continue;
            }
            if (this.elementData[i].equals(TOP)) {
                n3 = TOP;
                continue;
            }
            if (this.elementData[i].equals(MIDDLE)) {
                n3 = MIDDLE;
                continue;
            }
            if (this.elementData[i].equals(BOTTOM)) {
                n3 = BOTTOM;
                continue;
            }
            if (this.elementData[i].equals(HORIZ_SPACE)) {
                if (i < this.size() - 1 && this.isValue(this.elementData[i + 1])) {
                    n4 += ((Integer)this.elementData[++i]).intValue();
                    continue;
                }
                n4 += 10;
                continue;
            }
            if (this.elementData[i].equals(RESET)) {
                if (this.url == null) {
                    underline = false;
                }
                strikethrough = false;
                n3 = BOTTOM;
                graphics.setColor(component.getForeground());
                graphics.setFont(font);
                fontMetrics = graphics.getFontMetrics();
                continue;
            }
            if (this.elementData[i] instanceof Color) {
                graphics.setColor((Color)this.elementData[i]);
                continue;
            }
            if (this.elementData[i].equals(NEWLINE)) break;
        }
    }

    public String getURL(int n, int n2) {
        if (this.url_rect_list != null) {
            for (int i = 0; i < this.url_rect_list.size(); ++i) {
                if (!((Rectangle)this.url_rect_list.elementAt(i)).inside(n, n2)) continue;
                return (String)this.url_list.elementAt(i);
            }
        }
        return null;
    }

    public static String getURL(Applet applet, Object object, int n, int n2) {
        String string = null;
        if (applet != null) {
            try {
                if (applet.getAppletContext() == null) {
                    applet = null;
                }
            }
            catch (Exception exception) {
                applet = null;
            }
        }
        if (object instanceof JCString) {
            string = ((JCString)object).getURL(n, n2);
            if (string != null && applet != null) {
                int n3 = Math.max(string.indexOf("TARGET="), string.indexOf("target="));
                if (n3 == -1) {
                    applet.showStatus(string);
                } else {
                    applet.showStatus(string.substring(0, n3));
                }
            }
            has_url = true;
        }
        if (applet != null && has_url && string == null) {
            applet.showStatus(null);
        }
        if (string == null) {
            has_url = false;
        }
        return string;
    }

    public static boolean showURL(String string, AppletContext appletContext, Applet applet) {
        if (string == null || appletContext == null) {
            return false;
        }
        int n = string.indexOf("TARGET=");
        String string2 = n == -1 ? string : string.substring(0, n);
        String string3 = n == -1 ? null : string.substring(n + 7);
        try {
            URL uRL = new URL(applet.getDocumentBase(), string2);
            if (string3 == null) {
                appletContext.showDocument(uRL);
            } else {
                appletContext.showDocument(uRL, string3);
            }
        }
        catch (Exception exception) {
            applet.showStatus("Invalid URL");
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public String getString() {
        String string = new String();
        for (int i = 0; i < this.size(); ++i) {
            if (this.elementData[i].equals(HREF)) {
                ++i;
                continue;
            }
            if (this.elementData[i] instanceof String) {
                string = string.concat((String)this.elementData[i]);
                continue;
            }
            if (!this.elementData[i].equals(NEWLINE)) continue;
            string = string.concat("\n");
        }
        return string;
    }

    public Image getImage() {
        for (int i = 0; i < this.size(); ++i) {
            if (!(this.elementData[i] instanceof Image)) continue;
            return (Image)this.elementData[i];
        }
        return null;
    }
}

