/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp.jmx;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.WeakHashMap;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotificationBroadcaster;

public class StandardMBeanIntrospector {
    private static final MBeanConstructorInfo[] EMPTY_CONSTRUCTORS = new MBeanConstructorInfo[0];
    private static final MBeanParameterInfo[] EMPTY_PARAMETERS = new MBeanParameterInfo[0];
    private static final MBeanAttributeInfo[] EMPTY_ATTRIBUTES = new MBeanAttributeInfo[0];
    private static final MBeanNotificationInfo[] EMPTY_NOTIFICATIONS = new MBeanNotificationInfo[0];
    private static final MBeanOperationInfo[] EMPTY_OPERATIONS = new MBeanOperationInfo[0];
    private static final WeakHashMap mbeanInfoCache = new WeakHashMap();

    private StandardMBeanIntrospector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MBeanInfo createStandardMBeanInfo(Class mBeanInterface, Object mBean) {
        WeakHashMap weakHashMap = mbeanInfoCache;
        synchronized (weakHashMap) {
            MBeanInfo info = (MBeanInfo)mbeanInfoCache.get(mBeanInterface);
            if (info != null) {
                return info;
            }
        }
        MBeanConstructorInfo[] ctors = StandardMBeanIntrospector.createMBeanConstructorInfo(mBean);
        if (ctors == null) {
            return null;
        }
        MBeanAttributeInfo[] attrs = StandardMBeanIntrospector.createMBeanAttributeInfo(mBeanInterface);
        if (attrs == null) {
            return null;
        }
        MBeanOperationInfo[] opers = StandardMBeanIntrospector.createMBeanOperationInfo(mBeanInterface);
        if (opers == null) {
            return null;
        }
        MBeanNotificationInfo[] notifs = StandardMBeanIntrospector.createMBeanNotificationInfo(mBean);
        if (notifs == null) {
            return null;
        }
        MBeanInfo info = new MBeanInfo(mBeanInterface.getName(), mBeanInterface.getName(), attrs, ctors, opers, notifs);
        WeakHashMap weakHashMap2 = mbeanInfoCache;
        synchronized (weakHashMap2) {
            mbeanInfoCache.put(mBeanInterface, info);
        }
        return info;
    }

    private static MBeanOperationInfo[] createMBeanOperationInfo(Class mBeanInterface) {
        ArrayList<MBeanOperationInfo> operations = new ArrayList<MBeanOperationInfo>();
        Method[] methods = mBeanInterface.getMethods();
        for (int j = 0; j < methods.length; ++j) {
            Method method = methods[j];
            if (StandardMBeanIntrospector.isAttributeGetter(method) || StandardMBeanIntrospector.isAttributeSetter(method)) continue;
            Class<?>[] params = method.getParameterTypes();
            int paramsNumber = params.length;
            MBeanParameterInfo[] paramsInfo = paramsNumber == 0 ? EMPTY_PARAMETERS : new MBeanParameterInfo[paramsNumber];
            for (int k = 0; k < paramsNumber; ++k) {
                Class<?> param = params[k];
                paramsInfo[k] = new MBeanParameterInfo("param" + k, param.getName(), null);
            }
            MBeanOperationInfo info = new MBeanOperationInfo(method.getName(), null, paramsInfo, method.getReturnType().getName(), 3);
            operations.add(info);
        }
        int opersNumber = operations.size();
        return opersNumber == 0 ? EMPTY_OPERATIONS : operations.toArray(new MBeanOperationInfo[opersNumber]);
    }

    private static MBeanAttributeInfo[] createMBeanAttributeInfo(Class mBeanInterface) {
        HashMap<String, MBeanAttributeInfo> attributes = new HashMap<String, MBeanAttributeInfo>();
        HashMap<String, Method> getterNames = new HashMap<String, Method>();
        Method[] methods = mBeanInterface.getMethods();
        for (int j = 0; j < methods.length; ++j) {
            String name;
            Method method = methods[j];
            if (StandardMBeanIntrospector.isAttributeGetter(method)) {
                name = method.getName();
                boolean isIs = name.startsWith("is");
                String attribute = null;
                attribute = isIs ? name.substring(2) : name.substring(3);
                MBeanAttributeInfo info = (MBeanAttributeInfo)attributes.get(attribute);
                if (info != null) {
                    if (!info.getType().equals(method.getReturnType().getName())) {
                        return null;
                    }
                    if (getterNames.get(name) != null) continue;
                    if (info.isReadable()) {
                        return null;
                    }
                    info = new MBeanAttributeInfo(attribute, info.getType(), info.getDescription(), true, info.isWritable(), isIs);
                } else {
                    info = new MBeanAttributeInfo(attribute, method.getReturnType().getName(), null, true, false, isIs);
                }
                attributes.put(attribute, info);
                getterNames.put(name, method);
                continue;
            }
            if (!StandardMBeanIntrospector.isAttributeSetter(method)) continue;
            name = method.getName();
            String attribute = name.substring(3);
            MBeanAttributeInfo info = (MBeanAttributeInfo)attributes.get(attribute);
            if (info != null) {
                if (!info.getType().equals(method.getParameterTypes()[0].getName())) {
                    return null;
                }
                info = new MBeanAttributeInfo(info.getName(), info.getType(), info.getDescription(), info.isReadable(), true, info.isIs());
            } else {
                info = new MBeanAttributeInfo(attribute, method.getParameterTypes()[0].getName(), null, false, true, false);
            }
            attributes.put(attribute, info);
        }
        int size = attributes.size();
        return size == 0 ? EMPTY_ATTRIBUTES : attributes.values().toArray(new MBeanAttributeInfo[size]);
    }

    private static MBeanNotificationInfo[] createMBeanNotificationInfo(Object mBean) {
        MBeanNotificationInfo[] notifs = null;
        if (mBean instanceof NotificationBroadcaster) {
            notifs = ((NotificationBroadcaster)mBean).getNotificationInfo();
        }
        if (notifs == null || notifs.length == 0) {
            notifs = EMPTY_NOTIFICATIONS;
        }
        return notifs;
    }

    private static MBeanConstructorInfo[] createMBeanConstructorInfo(Object mBean) {
        Class<?> mbeanClass = mBean.getClass();
        Constructor<?>[] ctors = mbeanClass.getConstructors();
        int ctorsNumber = ctors.length;
        MBeanConstructorInfo[] constructors = ctorsNumber == 0 ? EMPTY_CONSTRUCTORS : new MBeanConstructorInfo[ctorsNumber];
        for (int i = 0; i < ctorsNumber; ++i) {
            MBeanConstructorInfo info;
            Constructor<?> constructor = ctors[i];
            Class<?>[] params = constructor.getParameterTypes();
            int paramsNumber = params.length;
            MBeanParameterInfo[] paramsInfo = paramsNumber == 0 ? EMPTY_PARAMETERS : new MBeanParameterInfo[paramsNumber];
            for (int j = 0; j < paramsNumber; ++j) {
                Class<?> param = params[j];
                paramsInfo[j] = new MBeanParameterInfo(null, param.getName(), null);
            }
            String ctorName = constructor.getName();
            constructors[i] = info = new MBeanConstructorInfo(ctorName, null, paramsInfo);
        }
        return constructors;
    }

    private static boolean isAttributeGetter(Method m) {
        if (m == null) {
            return false;
        }
        String name = m.getName();
        Class<?> retType = m.getReturnType();
        Class<?>[] params = m.getParameterTypes();
        if (retType != Void.TYPE && params.length == 0) {
            if (name.startsWith("get") && name.length() > 3) {
                return true;
            }
            if (name.startsWith("is") && name.length() > 2 && retType == Boolean.TYPE) {
                return true;
            }
        }
        return false;
    }

    private static boolean isAttributeSetter(Method m) {
        if (m == null) {
            return false;
        }
        String name = m.getName();
        Class<?> retType = m.getReturnType();
        Class<?>[] params = m.getParameterTypes();
        return retType == Void.TYPE && params.length == 1 && name.startsWith("set") && name.length() > 3;
    }
}

