/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip;

import gov.nist.core.LogWriter;
import gov.nist.javax.sip.EventWrapper;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import java.io.IOException;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.SipListener;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionState;

class EventScanner
implements Runnable {
    private boolean isStopped;
    protected int refCount;
    private LinkedList pendingEvents = new LinkedList();
    private int[] eventMutex = new int[]{0};
    private SipStackImpl sipStackImpl;

    public EventScanner(SipStackImpl sipStackImpl) {
        this.pendingEvents = new LinkedList();
        Thread myThread = new Thread(this);
        myThread.setDaemon(false);
        this.sipStackImpl = sipStackImpl;
        myThread.setName("EventScannerThread");
        myThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(EventWrapper eventWrapper) {
        int[] nArray = this.eventMutex;
        synchronized (this.eventMutex) {
            this.pendingEvents.add(eventWrapper);
            this.eventMutex.notify();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void stop() {
        if (this.refCount > 0) {
            --this.refCount;
        }
        if (this.refCount != 0) return;
        int[] nArray = this.eventMutex;
        synchronized (this.eventMutex) {
            this.isStopped = true;
            this.eventMutex.notify();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliverEvent(EventWrapper eventWrapper) {
        EventObject sipEvent = eventWrapper.sipEvent;
        SipListener sipListener = ((SipProviderImpl)sipEvent.getSource()).sipListener;
        if (sipEvent instanceof RequestEvent) {
            SIPTransaction tr;
            SIPRequest sipRequest = (SIPRequest)((RequestEvent)sipEvent).getRequest();
            if (this.sipStackImpl.isDialogCreated(sipRequest.getMethod())) {
                tr = (SIPServerTransaction)this.sipStackImpl.findTransaction(sipRequest, true);
                SIPDialog dialog = this.sipStackImpl.getDialog(sipRequest.getDialogId(true));
                EventScanner eventScanner = this;
                synchronized (eventScanner) {
                    if (tr != null && !((SIPServerTransaction)tr).passToListener()) {
                        if (LogWriter.needsLogging) {
                            this.sipStackImpl.logMessage("transaction already exists! " + tr);
                        }
                        return;
                    }
                    if (this.sipStackImpl.findPendingTransaction(sipRequest) != null) {
                        if (LogWriter.needsLogging) {
                            this.sipStackImpl.logMessage("transaction already exists!!");
                        }
                        return;
                    }
                    SIPServerTransaction st = (SIPServerTransaction)eventWrapper.transaction;
                    this.sipStackImpl.putPendingTransaction(st);
                }
            } else if (!sipRequest.getMethod().equals("CANCEL") && this.sipStackImpl.getDialog(sipRequest.getDialogId(true)) == null && (tr = this.sipStackImpl.findTransaction(sipRequest, true)) != null) {
                if (LogWriter.needsLogging) {
                    this.sipStackImpl.logMessage("transaction already exists!");
                }
                return;
            }
            sipRequest.setTransaction(eventWrapper.transaction);
            if (sipRequest.getMethod().equals("CANCEL") && (tr = this.sipStackImpl.findTransaction(sipRequest, true)) != null && tr.getState() == SIPTransaction.TERMINATED_STATE) {
                if (LogWriter.needsLogging) {
                    this.sipStackImpl.logMessage("Too late to cancel Transaction");
                }
                try {
                    tr.sendMessage(sipRequest.createResponse(200));
                }
                catch (IOException ex) {
                    // empty catch block
                }
                return;
            }
            try {
                SIPDialog dialog;
                if (LogWriter.needsLogging) {
                    this.sipStackImpl.logMessage("Calling listener " + sipRequest.getRequestURI());
                }
                if (sipListener != null) {
                    sipListener.processRequest((RequestEvent)sipEvent);
                }
                this.sipStackImpl.removePendingTransaction((SIPServerTransaction)eventWrapper.transaction);
                if (eventWrapper.transaction != null && (dialog = (SIPDialog)eventWrapper.transaction.getDialog()) != null) {
                    dialog.requestConsumed();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (eventWrapper.transaction != null) {
                ((SIPServerTransaction)eventWrapper.transaction).clearPending();
            }
        } else if (sipEvent instanceof ResponseEvent) {
            try {
                if (LogWriter.needsLogging) {
                    SIPResponse sipResponse = (SIPResponse)((ResponseEvent)sipEvent).getResponse();
                    this.sipStackImpl.logMessage("Calling listener for " + sipResponse.getFirstLine());
                }
                if (sipListener != null) {
                    sipListener.processResponse((ResponseEvent)sipEvent);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            SIPClientTransaction ct = (SIPClientTransaction)eventWrapper.transaction;
            if (ct != null && TransactionState.COMPLETED == ct.getState() && ct.getOriginalRequest() != null && !ct.getOriginalRequest().getMethod().equals("INVITE")) {
                ct.clearState();
            }
            if (ct != null) {
                ct.clearPending();
            }
        } else if (sipEvent instanceof TimeoutEvent) {
            try {
                if (sipListener != null) {
                    sipListener.processTimeout((TimeoutEvent)sipEvent);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (LogWriter.needsLogging) {
            this.sipStackImpl.logMessage("bad event" + sipEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        block4: while (true) {
            Object sipEvent = null;
            EventWrapper eventWrapper = null;
            int[] nArray = this.eventMutex;
            // MONITORENTER : this.eventMutex
            while (this.pendingEvents.isEmpty()) {
                if (this.isStopped) {
                    if (LogWriter.needsLogging) {
                        this.sipStackImpl.logMessage("Stopped event scanner!!");
                    }
                    // MONITOREXIT : nArray
                    return;
                }
                try {
                    this.eventMutex.wait();
                }
                catch (InterruptedException ex) {
                    this.sipStackImpl.logMessage("Interrupted!");
                    // MONITOREXIT : nArray
                    return;
                }
            }
            LinkedList eventsToDeliver = this.pendingEvents;
            this.pendingEvents = new LinkedList();
            // MONITOREXIT : nArray
            ListIterator iterator = eventsToDeliver.listIterator();
            while (true) {
                if (!iterator.hasNext()) continue block4;
                eventWrapper = (EventWrapper)iterator.next();
                if (LogWriter.needsLogging) {
                    this.sipStackImpl.logMessage("Processing " + eventWrapper + "nevents " + eventsToDeliver.size());
                }
                this.deliverEvent(eventWrapper);
            }
            break;
        }
    }
}

