/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.address;

import gov.nist.core.GenericObject;
import gov.nist.core.GenericObjectList;
import gov.nist.javax.sip.address.NetObject;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.ListIterator;

public class NetObjectList
extends GenericObjectList {
    public NetObjectList(String lname) {
        super(lname);
    }

    public NetObjectList(String lname, Class cname) {
        super(lname, cname);
    }

    public NetObjectList(String lname, String cname) {
        super(lname, cname);
    }

    public NetObjectList() {
    }

    public void add(NetObject obj) {
        super.add(obj);
    }

    public void concatenate(NetObjectList net_obj_list) {
        super.concatenate(net_obj_list);
    }

    public Object clone() {
        NetObjectList newObject = (NetObjectList)super.clone();
        ListIterator li = this.listIterator();
        while (li.hasNext()) {
            Object listObj = li.next();
            Object clone_obj = NetObjectList.makeClone(listObj);
            newObject.add(clone_obj);
        }
        Class<?> myclass = this.getClass();
        Field[] fields = myclass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            int modifier = f.getModifiers();
            if (Modifier.isPrivate(modifier) || Modifier.isStatic(modifier) || Modifier.isInterface(modifier)) continue;
            Class<?> fieldType = f.getType();
            String fieldName = f.getName();
            String fname = fieldType.toString();
            System.out.println("Field type = " + fieldType.getName());
            try {
                if (fieldType.isPrimitive()) {
                    if (fname.compareTo("int") == 0) {
                        int intfield = f.getInt(this);
                        f.setInt(newObject, intfield);
                        continue;
                    }
                    if (fname.compareTo("short") == 0) {
                        short shortField = f.getShort(this);
                        f.setShort(newObject, shortField);
                        continue;
                    }
                    if (fname.compareTo("char") == 0) {
                        char charField = f.getChar(this);
                        f.setChar(newObject, charField);
                        continue;
                    }
                    if (fname.compareTo("long") == 0) {
                        long longField = f.getLong(this);
                        f.setLong(newObject, longField);
                        continue;
                    }
                    if (fname.compareTo("boolean") == 0) {
                        boolean booleanField = f.getBoolean(this);
                        f.setBoolean(newObject, booleanField);
                        continue;
                    }
                    if (fname.compareTo("double") == 0) {
                        double doubleField = f.getDouble(this);
                        f.setDouble(newObject, doubleField);
                        continue;
                    }
                    if (fname.compareTo("float") != 0) continue;
                    float floatField = f.getFloat(this);
                    f.setFloat(newObject, floatField);
                    continue;
                }
                Object obj = f.get(this);
                if (obj == null) {
                    f.set(newObject, null);
                    continue;
                }
                Object clone_obj = NetObjectList.makeClone(obj);
                f.set(newObject, clone_obj);
                continue;
            }
            catch (IllegalAccessException ex1) {
                ex1.printStackTrace();
            }
        }
        return newObject;
    }

    public void mergeObjects(GenericObjectList mergeList) {
        if (!mergeList.getMyClass().equals(this.getMyClass())) {
            throw new IllegalArgumentException("class mismatch");
        }
        ListIterator it1 = this.listIterator();
        ListIterator it2 = mergeList.listIterator();
        while (it1.hasNext()) {
            GenericObject outerObj = (GenericObject)it1.next();
            while (it2.hasNext()) {
                Object innerObj = it2.next();
                outerObj.merge(innerObj);
            }
        }
    }

    public GenericObject first() {
        return (NetObject)super.first();
    }

    public Class getMyClass() {
        return super.getMyClass();
    }

    public GenericObject next() {
        return (NetObject)super.next();
    }

    public GenericObject next(ListIterator li) {
        return (NetObject)super.next(li);
    }

    public void replace(String objectText, GenericObject replacementObject, boolean matchSubstring) throws IllegalArgumentException {
        if (objectText == null || replacementObject == null) {
            throw new IllegalArgumentException("null argument");
        }
        ListIterator listIterator = this.listIterator();
        LinkedList ll = new LinkedList();
        while (listIterator.hasNext()) {
            Serializable gobj;
            Object obj = listIterator.next();
            if (GenericObject.isMySubclass(obj.getClass())) {
                gobj = (GenericObject)obj;
                if (!gobj.getClass().equals(replacementObject.getClass())) continue;
                if (!matchSubstring && ((GenericObject)gobj).encode().compareTo(objectText) == 0) {
                    ll.add(obj);
                    continue;
                }
                if (matchSubstring && ((GenericObject)gobj).encode().indexOf(objectText) >= 0) {
                    ll.add(obj);
                    continue;
                }
                ((GenericObject)gobj).replace(objectText, replacementObject, matchSubstring);
                continue;
            }
            if (!GenericObjectList.isMySubclass(obj.getClass()) || !(gobj = (GenericObjectList)obj).getClass().equals(replacementObject.getClass())) continue;
            if (!matchSubstring && ((GenericObjectList)gobj).encode().compareTo(objectText) == 0) {
                ll.add(obj);
                continue;
            }
            if (matchSubstring && ((GenericObjectList)gobj).encode().indexOf(objectText) >= 0) {
                ll.add(obj);
                continue;
            }
            ((GenericObjectList)gobj).replace(objectText, replacementObject, matchSubstring);
        }
        for (int i = 0; i < ll.size(); ++i) {
            Object obj = ll.get(i);
            this.remove(obj);
            this.add(i, replacementObject);
        }
    }

    public void replace(String objectText, GenericObjectList replacementObject, boolean matchSubstring) throws IllegalArgumentException {
        if (objectText == null || replacementObject == null) {
            throw new IllegalArgumentException("null argument");
        }
        ListIterator listIterator = this.listIterator();
        LinkedList ll = new LinkedList();
        while (listIterator.hasNext()) {
            Serializable gobj;
            Object obj = listIterator.next();
            if (GenericObject.isMySubclass(obj.getClass())) {
                gobj = (GenericObject)obj;
                if (!gobj.getClass().equals(replacementObject.getClass())) continue;
                if (!matchSubstring && ((GenericObject)gobj).encode().compareTo(objectText) == 0) {
                    ll.add(obj);
                    continue;
                }
                if (matchSubstring && ((GenericObject)gobj).encode().indexOf(objectText) >= 0) {
                    ll.add(obj);
                    continue;
                }
                ((GenericObject)gobj).replace(objectText, replacementObject, matchSubstring);
                continue;
            }
            if (!GenericObjectList.isMySubclass(obj.getClass()) || !(gobj = (GenericObjectList)obj).getClass().equals(replacementObject.getClass())) continue;
            if (!matchSubstring && ((GenericObjectList)gobj).encode().compareTo(objectText) == 0) {
                ll.add(obj);
                continue;
            }
            if (matchSubstring && ((GenericObjectList)gobj).encode().indexOf(objectText) >= 0) {
                ll.add(obj);
                continue;
            }
            ((GenericObjectList)gobj).replace(objectText, replacementObject, matchSubstring);
        }
        for (int i = 0; i < ll.size(); ++i) {
            Object obj = ll.get(i);
            this.remove(obj);
            this.add(i, replacementObject);
        }
    }

    public void setMyClass(Class cl) {
        super.setMyClass(cl);
    }

    public String debugDump(int indent) {
        return super.debugDump(indent);
    }

    public String toString() {
        return this.encode();
    }
}

