/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.address;

import gov.nist.core.GenericObject;
import gov.nist.core.Host;
import gov.nist.core.HostPort;
import gov.nist.core.NameValue;
import gov.nist.core.NameValueList;
import gov.nist.javax.sip.address.Authority;
import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.address.TelephoneNumber;
import gov.nist.javax.sip.address.UserInfo;
import java.text.ParseException;
import java.util.Iterator;
import java.util.ListIterator;
import javax.sip.address.SipURI;

public class SipUri
extends GenericURI
implements SipURI {
    protected String scheme = "sip";
    protected Authority authority;
    protected NameValueList uriParms = new NameValueList("uriparms");
    protected NameValueList qheaders = new NameValueList("qheaders");
    protected TelephoneNumber telephoneSubscriber;

    public SipUri() {
        this.qheaders.setSeparator("&");
    }

    public void setScheme(String scheme) {
        if (scheme.compareToIgnoreCase("sip") != 0 && scheme.compareToIgnoreCase("sips") != 0) {
            throw new IllegalArgumentException("bad scheme " + scheme);
        }
        this.scheme = scheme.toLowerCase();
    }

    public String getScheme() {
        return this.scheme;
    }

    public void clearUriParms() {
        this.uriParms = new NameValueList("uriparms");
    }

    public void clearPassword() {
        UserInfo userInfo;
        if (this.authority != null && (userInfo = this.authority.getUserInfo()) != null) {
            userInfo.clearPassword();
        }
    }

    public Authority getAuthority() {
        return this.authority;
    }

    public void clearQheaders() {
        this.qheaders = new NameValueList("qheaders");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (!this.getClass().equals(that.getClass())) {
            return false;
        }
        SipUri other = (SipUri)that;
        if (this.uriParms.size() != other.uriParms.size()) {
            return false;
        }
        if (!this.authority.equals(other.authority)) {
            return false;
        }
        ListIterator li = this.uriParms.listIterator();
        NameValueList hisParms = other.uriParms;
        while (li.hasNext()) {
            NameValue nv = (NameValue)li.next();
            if (nv.getName().equals("transport")) {
                String value = (String)nv.getValue();
                String hisTransport = (String)hisParms.getValue("transport");
                if (hisTransport == null && value.compareToIgnoreCase("udp") == 0) continue;
                if (hisTransport == null) {
                    return false;
                }
                if (hisTransport.compareToIgnoreCase(value) != 0) continue;
                continue;
            }
            NameValue hisnv = hisParms.getNameValue(nv.getName());
            if (hisnv == null) {
                return false;
            }
            if (hisnv.equals(nv)) continue;
            return false;
        }
        return true;
    }

    public String encode() {
        StringBuffer retval = new StringBuffer(this.scheme).append(":");
        if (this.authority != null) {
            retval.append(this.authority.encode());
        }
        if (!this.uriParms.isEmpty()) {
            retval.append(";").append(this.uriParms.encode());
        }
        if (!this.qheaders.isEmpty()) {
            retval.append("?").append(this.qheaders.encode());
        }
        return retval.toString();
    }

    public String toString() {
        return this.encode();
    }

    public String getUserAtHost() {
        String user = this.authority.getUserInfo().getUser();
        String host = this.authority.getHost().encode();
        return user + "@" + host;
    }

    public String getUserAtHostPort() {
        String user = "";
        if (this.authority.getUserInfo() != null) {
            user = this.authority.getUserInfo().getUser();
        }
        String host = this.authority.getHost().encode();
        int port = this.authority.getPort();
        StringBuffer s = null;
        s = user.equals("") ? new StringBuffer() : new StringBuffer(user).append("@");
        if (port != -1) {
            return s.append(host).append(":").append(port).toString();
        }
        return s.append(host).toString();
    }

    public Object getParm(String parmname) {
        Object obj = this.uriParms.getValue(parmname);
        return obj;
    }

    public String getMethod() {
        return (String)this.getParm("method");
    }

    public NameValueList getUriParms() {
        return this.uriParms;
    }

    public void removeUriParms() {
        this.uriParms = new NameValueList();
    }

    public NameValueList getQheaders() {
        return this.qheaders;
    }

    public String getUserType() {
        return (String)this.uriParms.getValue("user");
    }

    public String getUserPassword() {
        if (this.authority == null) {
            return null;
        }
        return this.authority.getPassword();
    }

    public void setUserPassword(String password) {
        if (this.authority == null) {
            this.authority = new Authority();
        }
        this.authority.setPassword(password);
    }

    public TelephoneNumber getTelephoneSubscriber() {
        if (this.telephoneSubscriber == null) {
            this.telephoneSubscriber = new TelephoneNumber();
        }
        return this.telephoneSubscriber;
    }

    public HostPort getHostPort() {
        if (this.authority == null) {
            return null;
        }
        return this.authority.getHostPort();
    }

    public int getPort() {
        HostPort hp = this.getHostPort();
        if (hp == null) {
            return -1;
        }
        return hp.getPort();
    }

    public String getHost() {
        return this.authority.getHost().encode();
    }

    public boolean isUserTelephoneSubscriber() {
        String usrtype = (String)this.uriParms.getValue("user");
        if (usrtype == null) {
            return false;
        }
        return usrtype.equals("phone");
    }

    public void removeTTL() {
        if (this.uriParms != null) {
            this.uriParms.delete("ttl");
        }
    }

    public void removeMAddr() {
        if (this.uriParms != null) {
            this.uriParms.delete("maddr");
        }
    }

    public void removeTransport() {
        if (this.uriParms != null) {
            this.uriParms.delete("transport");
        }
    }

    public void removeHeader(String name) {
        if (this.qheaders != null) {
            this.qheaders.delete(name);
        }
    }

    public void removeHeaders() {
        this.qheaders = new NameValueList("qheaders");
    }

    public void removeUserType() {
        if (this.uriParms != null) {
            this.uriParms.delete("user");
        }
    }

    public void removePort() {
        this.authority.removePort();
    }

    public void removeMethod() {
        if (this.uriParms != null) {
            this.uriParms.delete("method");
        }
    }

    public void setUser(String uname) {
        if (this.authority == null) {
            this.authority = new Authority();
        }
        this.authority.setUser(uname);
    }

    public void removeUser() {
        this.authority.removeUserInfo();
    }

    public void setDefaultParm(String name, Object value) {
        if (this.uriParms.getValue(name) == null) {
            NameValue nv = new NameValue(name, value);
            this.uriParms.add(nv);
        }
    }

    public void setAuthority(Authority authority) {
        this.authority = authority;
    }

    public void setHost(Host h) {
        if (this.authority == null) {
            this.authority = new Authority();
        }
        this.authority.setHost(h);
    }

    public void setUriParms(NameValueList parms) {
        this.uriParms = parms;
    }

    public void setUriParm(String name, Object value) {
        NameValue nv = new NameValue(name, value);
        this.uriParms.add(nv);
    }

    public void setQheaders(NameValueList parms) {
        this.qheaders = parms;
    }

    public void setMAddr(String mAddr) {
        NameValue nameValue = this.uriParms.getNameValue("maddr");
        Host host = new Host();
        host.setAddress(mAddr);
        if (nameValue != null) {
            nameValue.setValue(host);
        } else {
            nameValue = new NameValue("maddr", host);
            this.uriParms.add(nameValue);
        }
    }

    public void setUserParam(String usertype) {
        this.uriParms.delete("user");
        this.uriParms.add("user", usertype);
    }

    public void setMethod(String method) {
        this.uriParms.add("method", method);
    }

    public void setIsdnSubAddress(String isdnSubAddress) {
        if (this.telephoneSubscriber == null) {
            this.telephoneSubscriber = new TelephoneNumber();
        }
        this.telephoneSubscriber.setIsdnSubaddress(isdnSubAddress);
    }

    public void setTelephoneSubscriber(TelephoneNumber tel) {
        this.telephoneSubscriber = tel;
    }

    public void setPort(int p) {
        if (this.authority == null) {
            this.authority = new Authority();
        }
        this.authority.setPort(p);
    }

    public boolean hasParameter(String name) {
        return this.uriParms.getValue(name) != null;
    }

    public void setQHeader(NameValue nameValue) {
        this.qheaders.set(nameValue);
    }

    public void setUriParameter(NameValue nameValue) {
        this.uriParms.set(nameValue);
    }

    public boolean hasTransport() {
        return this.hasParameter("transport");
    }

    public void removeParameter(String name) {
        this.uriParms.delete(name);
    }

    public void setHostPort(HostPort hostPort) {
        if (this.authority == null) {
            this.authority = new Authority();
        }
        this.authority.setHostPort(hostPort);
    }

    public Object clone() {
        SipUri retval = new SipUri();
        retval.scheme = new String(this.scheme);
        retval.authority = (Authority)this.authority.clone();
        retval.uriParms = (NameValueList)this.uriParms.clone();
        if (this.qheaders != null) {
            retval.qheaders = (NameValueList)this.qheaders.clone();
        }
        if (this.telephoneSubscriber != null) {
            retval.telephoneSubscriber = (TelephoneNumber)this.telephoneSubscriber.clone();
        }
        return retval;
    }

    public String getHeader(String name) {
        return this.qheaders.getValue(name) != null ? this.qheaders.getValue(name).toString() : null;
    }

    public Iterator getHeaderNames() {
        return this.qheaders.listIterator();
    }

    public String getLrParam() {
        boolean haslr = this.hasParameter("lr");
        return haslr ? "true" : null;
    }

    public String getMAddrParam() {
        NameValue maddr = this.uriParms.getNameValue("maddr");
        if (maddr == null) {
            return null;
        }
        String host = (String)maddr.getValue();
        return host;
    }

    public String getMethodParam() {
        return this.getParameter("method");
    }

    public String getParameter(String name) {
        Object val = this.uriParms.getValue(name);
        if (val == null) {
            return null;
        }
        if (val instanceof GenericObject) {
            return ((GenericObject)val).encode();
        }
        return val.toString();
    }

    public Iterator getParameterNames() {
        return this.uriParms.getNames();
    }

    public int getTTLParam() {
        Integer ttl = (Integer)this.uriParms.getValue("ttl");
        if (ttl != null) {
            return ttl;
        }
        return -1;
    }

    public String getTransportParam() {
        if (this.uriParms != null) {
            return (String)this.uriParms.getValue("transport");
        }
        return null;
    }

    public String getUser() {
        return this.authority.getUser();
    }

    public boolean isSecure() {
        return this.getScheme().equalsIgnoreCase("sips");
    }

    public boolean isSipURI() {
        return true;
    }

    public void setHeader(String name, String value) {
        if (this.qheaders.getValue(name) == null) {
            NameValue nv = new NameValue(name, value);
            this.qheaders.add(nv);
        } else {
            NameValue nv = this.qheaders.getNameValue(name);
            nv.setValue(value);
        }
    }

    public void setHost(String host) throws ParseException {
        Host h = new Host(host);
        this.setHost(h);
    }

    public void setLrParam() {
        if (this.uriParms.getValue("lr") != null) {
            return;
        }
        NameValue nv = new NameValue("lr", null);
        this.uriParms.add(nv);
    }

    public void setMAddrParam(String maddr) throws ParseException {
        if (maddr == null) {
            throw new NullPointerException("bad maddr");
        }
        this.setParameter("maddr", maddr);
    }

    public void setMethodParam(String method) throws ParseException {
        this.setParameter("method", method);
    }

    public void setParameter(String name, String value) throws ParseException {
        if (name.equals("ttl")) {
            try {
                int ttl = Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                throw new ParseException("bad parameter " + value, 0);
            }
        }
        NameValue nv = new NameValue(name, value);
        this.uriParms.delete(name);
        this.uriParms.add(nv);
    }

    public void setSecure(boolean secure) {
        this.scheme = secure ? "sips" : "sip";
    }

    public void setTTLParam(int ttl) {
        if (ttl <= 0) {
            throw new IllegalArgumentException("Bad ttl value");
        }
        if (this.uriParms != null) {
            this.uriParms.delete("ttl");
            NameValue nv = new NameValue("ttl", new Integer(ttl));
            this.uriParms.add(nv);
        }
    }

    public void setTransportParam(String transport) throws ParseException {
        if (transport == null) {
            throw new NullPointerException("null arg");
        }
        if (transport.compareToIgnoreCase("UDP") != 0 && transport.compareToIgnoreCase("TCP") != 0) {
            throw new ParseException("bad transport " + transport, 0);
        }
        NameValue nv = new NameValue("transport", transport.toLowerCase());
        this.uriParms.delete("transport");
        this.uriParms.add(nv);
    }

    public String getUserParam() {
        return this.getParameter("user");
    }

    public boolean hasLrParam() {
        return this.uriParms.getNameValue("lr") != null;
    }
}

