/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.HostPort;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.LogWriter;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.SIPMessageStack;
import gov.nist.javax.sip.stack.TCPMessageChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;

public class TCPMessageProcessor
extends MessageProcessor {
    protected Thread thread;
    protected int port;
    protected int nConnections;
    private boolean isRunning;
    private Hashtable tcpMessageChannels;
    private ServerSocket sock;
    protected int useCount;
    protected SIPMessageStack sipStack;

    protected TCPMessageProcessor(SIPMessageStack sipStack, int port) {
        this.sipStack = sipStack;
        this.port = port;
        this.tcpMessageChannels = new Hashtable();
    }

    public void start() throws IOException {
        this.thread = new Thread(this);
        this.thread.setName("TCPMessageProcessorThread");
        this.thread.setDaemon(true);
        this.sock = new ServerSocket(this.port, 0, this.sipStack.savedStackInetAddress);
        this.isRunning = true;
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.isRunning) {
            try {
                TCPMessageProcessor tCPMessageProcessor = this;
                synchronized (tCPMessageProcessor) {
                    while (this.isRunning && this.sipStack.maxConnections != -1 && this.nConnections >= this.sipStack.maxConnections) {
                        try {
                            this.wait();
                            if (this.isRunning) continue;
                            return;
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                            break;
                        }
                    }
                    ++this.nConnections;
                }
                Socket newsock = this.sock.accept();
                if (LogWriter.needsLogging) {
                    this.getSIPStack().logWriter.logMessage("Accepting new connection!");
                }
                TCPMessageChannel tCPMessageChannel = new TCPMessageChannel(newsock, this.sipStack, this);
            }
            catch (SocketException ex) {
                this.isRunning = false;
            }
            catch (IOException ex) {
                if (!LogWriter.needsLogging) continue;
                this.getSIPStack().logWriter.logException(ex);
            }
            catch (Exception ex) {
                InternalErrorHandler.handleException(ex);
            }
        }
    }

    public String getTransport() {
        return "tcp";
    }

    public int getPort() {
        return this.port;
    }

    public SIPMessageStack getSIPStack() {
        return this.sipStack;
    }

    public synchronized void stop() {
        this.isRunning = false;
        this.listeningPoint = null;
        try {
            this.sock.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Collection en = this.tcpMessageChannels.values();
        Iterator it = en.iterator();
        while (it.hasNext()) {
            TCPMessageChannel next = (TCPMessageChannel)it.next();
            next.close();
        }
        this.notify();
    }

    protected synchronized void remove(TCPMessageChannel tcpMessageChannel) {
        String key = tcpMessageChannel.getKey();
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage(Thread.currentThread() + " removing " + key);
        }
        if (this.tcpMessageChannels.get(key) == tcpMessageChannel) {
            this.tcpMessageChannels.remove(key);
        }
    }

    public synchronized MessageChannel createMessageChannel(HostPort targetHostPort) throws IOException {
        String key = MessageChannel.getKey(targetHostPort, "TCP");
        if (this.tcpMessageChannels.get(key) != null) {
            return (TCPMessageChannel)this.tcpMessageChannels.get(key);
        }
        TCPMessageChannel retval = new TCPMessageChannel(targetHostPort.getInetAddress(), targetHostPort.getPort(), this.sipStack, this);
        this.tcpMessageChannels.put(key, retval);
        retval.isCached = true;
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("key " + key);
            this.sipStack.logWriter.logMessage("Creating " + retval);
        }
        return retval;
    }

    protected synchronized void cacheMessageChannel(TCPMessageChannel messageChannel) {
        String key = messageChannel.getKey();
        TCPMessageChannel currentChannel = (TCPMessageChannel)this.tcpMessageChannels.get(key);
        if (currentChannel != null) {
            if (LogWriter.needsLogging) {
                this.sipStack.logWriter.logMessage("Closing " + key);
            }
            currentChannel.close();
        }
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("Caching " + key);
        }
        this.tcpMessageChannels.put(key, messageChannel);
    }

    public synchronized MessageChannel createMessageChannel(InetAddress host, int port) throws IOException {
        try {
            String key = MessageChannel.getKey(host, port, "TCP");
            if (this.tcpMessageChannels.get(key) != null) {
                return (TCPMessageChannel)this.tcpMessageChannels.get(key);
            }
            TCPMessageChannel retval = new TCPMessageChannel(host, port, this.sipStack, this);
            this.tcpMessageChannels.put(key, retval);
            retval.isCached = true;
            if (LogWriter.needsLogging) {
                this.sipStack.logMessage("key " + key);
                this.sipStack.logMessage("Creating " + retval);
            }
            return retval;
        }
        catch (UnknownHostException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public int getMaximumMessageSize() {
        return Integer.MAX_VALUE;
    }

    public String getNAPTRService() {
        return "SIP+D2T";
    }

    public String getSRVPrefix() {
        return "_sip._tcp.";
    }

    public boolean inUse() {
        return this.useCount != 0;
    }

    public int getDefaultTargetPort() {
        return 5060;
    }

    public boolean isSecure() {
        return false;
    }
}

