/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public class StunAddress {
    InetSocketAddress socketAddress = null;

    public StunAddress(String hostname, int port) {
        this.socketAddress = new InetSocketAddress(hostname, port);
    }

    public StunAddress(byte[] ipAddress, int port) {
        try {
            this.socketAddress = new InetSocketAddress(InetAddress.getByAddress(ipAddress), port);
        }
        catch (UnknownHostException ex) {
            this.socketAddress = new InetSocketAddress((ipAddress[0] & 0xFF) + "." + (ipAddress[1] & 0xFF) + "." + (ipAddress[2] & 0xFF) + "." + (ipAddress[3] & 0xFF) + ".", port);
        }
    }

    public StunAddress(InetAddress address, int port) {
        this.socketAddress = new InetSocketAddress(address, port);
    }

    public StunAddress(int port) {
        this.socketAddress = new InetSocketAddress(port);
    }

    public byte[] getAddressBytes() {
        return this.socketAddress == null ? null : this.socketAddress.getAddress().getAddress();
    }

    public char getPort() {
        return this.socketAddress == null ? (char)'\u0000' : (char)this.socketAddress.getPort();
    }

    public InetSocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    public String toString() {
        return this.socketAddress.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StunAddress)) {
            return false;
        }
        StunAddress target = (StunAddress)obj;
        if (target.socketAddress == null && this.socketAddress == null) {
            return true;
        }
        return this.socketAddress.equals(target.getSocketAddress());
    }

    public String getHostName() {
        return this.socketAddress.getHostName();
    }
}

