/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.stack;

import net.java.stun4j.StunAddress;
import net.java.stun4j.StunException;
import net.java.stun4j.StunMessageEvent;
import net.java.stun4j.message.Message;
import net.java.stun4j.stack.ErrorHandler;
import net.java.stun4j.stack.MessageEventHandler;
import net.java.stun4j.stack.MessageQueue;
import net.java.stun4j.stack.RawMessage;

class MessageProcessor
implements Runnable {
    private MessageQueue messageQueue = null;
    private MessageEventHandler messageHandler = null;
    private ErrorHandler errorHandler = null;
    private boolean isRunning = false;
    private Thread runningThread = null;

    MessageProcessor(MessageQueue queue, MessageEventHandler messageHandler, ErrorHandler errorHandler) {
        this.messageQueue = queue;
        this.messageHandler = messageHandler;
        this.errorHandler = errorHandler;
    }

    public void run() {
        try {
            while (this.isRunning) {
                RawMessage rawMessage = null;
                try {
                    rawMessage = this.messageQueue.remove();
                }
                catch (InterruptedException ex) {
                    System.err.println("A net access point has gone useless:");
                    ex.printStackTrace();
                }
                if (!this.isRunning()) {
                    return;
                }
                if (rawMessage == null) continue;
                Message stunMessage = null;
                try {
                    stunMessage = Message.decode(rawMessage.getBytes(), '\u0000', (char)rawMessage.getMessageLength());
                }
                catch (StunException ex) {
                    this.errorHandler.handleError("Failed to decode a stun mesage!", ex);
                    continue;
                }
                StunMessageEvent stunMessageEvent = new StunMessageEvent(rawMessage.getNetAccessPoint(), stunMessage, new StunAddress(rawMessage.getRemoteAddress().getAddress(), rawMessage.getRemoteAddress().getPort()));
                this.messageHandler.handleMessageEvent(stunMessageEvent);
            }
        }
        catch (Throwable err) {
            this.errorHandler.handleFatalError(this, "Unexpected Error!", err);
        }
    }

    void start() {
        this.isRunning = true;
        this.runningThread = new Thread(this);
        this.runningThread.start();
    }

    void stop() {
        this.isRunning = false;
    }

    boolean isRunning() {
        return this.isRunning;
    }
}

