/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils.icon;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import javax.swing.Icon;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.icon.IconWrapper;

public class ProgressIcon
implements Icon,
IconWrapper {
    private Icon originalIcon;
    private float cyclePos;

    public ProgressIcon(Icon originalIcon) {
        this.originalIcon = originalIcon;
        this.cyclePos = 0.0f;
    }

    public void setCyclePos(double cyclePos) {
        this.cyclePos = (float)cyclePos;
    }

    public int getIconHeight() {
        return this.originalIcon.getIconHeight();
    }

    public int getIconWidth() {
        return this.originalIcon.getIconWidth();
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g.create();
        float transp = (double)this.cyclePos < 0.5 ? 2.0f * this.cyclePos : 2.0f * (1.0f - this.cyclePos);
        g2.setComposite(AlphaComposite.getInstance(3, 0.5f * transp));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.originalIcon.paintIcon(c, g2, x, y);
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        double pos = (double)((int)(this.cyclePos * 10.0f)) / 10.0;
        double leadAngle = 1.5707963267948966 + 2.0 * pos * Math.PI;
        for (int i = 0; i < 10; ++i) {
            double trailAngle = leadAngle - 0.3141592653589793;
            double r = (double)this.getIconWidth() / 2.5;
            double d = (double)this.getIconWidth() / 8.0;
            double cx = (double)x + (double)this.getIconWidth() / 2.0;
            double cy = (double)y + (double)this.getIconHeight() / 2.0;
            double lx = cx + r * Math.cos(leadAngle);
            double ly = cy + r * Math.sin(leadAngle);
            double tnx = cx + (r - d) * Math.cos(trailAngle);
            double tny = cy + (r - d) * Math.sin(trailAngle);
            double tfx = cx + (r + d) * Math.cos(trailAngle);
            double tfy = cy + (r + d) * Math.sin(trailAngle);
            GeneralPath gp = new GeneralPath();
            gp.moveTo((float)tnx, (float)tny);
            gp.lineTo((float)lx, (float)ly);
            gp.lineTo((float)tfx, (float)tfy);
            g2.setStroke(new BasicStroke(3.2f));
            g2.setColor(new Color(255, 255, 255, 96));
            g2.draw(gp);
            g2.setStroke(new BasicStroke(2.0f));
            g2.setColor(Color.black);
            g2.draw(gp);
            if (i < 5) {
                g2.setColor(SubstanceColorUtilities.getInterpolatedColor(Color.black, Color.white, (double)i / 5.0));
                g2.setStroke(new BasicStroke(1.4f));
                g2.draw(gp);
            }
            leadAngle -= 0.6283185307179586;
        }
        g2.dispose();
    }

    public Icon getOriginalIcon() {
        return this.originalIcon;
    }
}

