/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.nativeskin;

import com.l2fprod.gui.region.ImageRegion;
import com.l2fprod.gui.region.Region;
import com.l2fprod.util.OS;
import java.awt.Image;
import java.awt.Window;

public abstract class NativeSkin {
    private static NativeSkin theInstance;

    public static boolean isSupported() {
        return OS.isWindows();
    }

    public static NativeSkin getInstance() {
        if (theInstance == null) {
            String impl = null;
            String library = null;
            if (OS.isWindows()) {
                impl = "com.l2fprod.gui.nativeskin.win32.Win32NativeSkin";
                library = OS.isOneDotFour() ? "nativeskinwin32JAWT" : "nativeskinwin32";
            } else {
                throw new Error("NativeSkin is not yet available for your platform: " + System.getProperty("os.name"));
            }
            try {
                System.loadLibrary(library);
                theInstance = (NativeSkin)Class.forName(impl).newInstance();
            }
            catch (Throwable th) {
                th.printStackTrace();
                throw new Error("Error while loading the SkinRegion library: " + th.getMessage());
            }
        }
        return theInstance;
    }

    public void setWindowTransparency(Window window, int transparency) {
        throw new Error("Not Implemented");
    }

    public void setWindowRegion(Window window, Region region, boolean redraw) {
        throw new Error("Not Implemented");
    }

    public void setWindowRegion(int handle, Region region, boolean redraw) {
        throw new Error("Not Implemented");
    }

    public Region createEllipticRegion(int x1, int y1, int x2, int y2) {
        throw new Error("Not Implemented");
    }

    public Region createRectangleRegion(int x1, int y1, int x2, int y2) {
        throw new Error("Not Implemented");
    }

    public Region createRoundRectangleRegion(int x1, int y1, int x2, int y2, int x3, int y3) {
        throw new Error("Not Implemented");
    }

    public Region createPolygonRegion(int[] xpoints, int[] ypoints, int fillMode) {
        throw new Error("Not Implemented");
    }

    public Region combineRegions(Region region1, Region region2, int combineMode) {
        throw new Error("Not Implemented");
    }

    public Region createRegion(Image image) {
        return this.createRegion(image, image.getWidth(null), image.getHeight(null));
    }

    public Region createRegion(Image image, int width, int height) {
        return new ImageRegion(image, width, height);
    }

    public void setAlwaysOnTop(Window window, boolean enable) {
        throw new Error("Not Implemented");
    }
}

