<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:variable name='HeaderStyle'>border-bottom:1 solid black</xsl:variable>

	<xsl:template match="Log">
		<html>
			<head>
				<title>Message log for
					<xsl:value-of select="@LoginName"/>
				</title>
			</head>

			<body>
				<xsl:apply-templates select="Conversation">
					<xsl:sort select='Start/Time/@ID' order='descending'/>
				</xsl:apply-templates>
			</body>
		</html>
	</xsl:template>

	<xsl:template match="Conversation">
		<table border='1' width='100%'>
			<tr>
				<td>
					<table border='0'>
						<tr>
							<td>Conversation started:</td>
							<td>
								<font color='gray'>
									<xsl:apply-templates select="Start/Time"/>
								</font>
							</td>
						</tr>
						<tr>
							<td>Conversation ended:</td>
							<td>
								<font color='gray'>
									<xsl:apply-templates select="End/Time"/>
								</font>
							</td>
						</tr>
						<tr>
							<td>Participants:</td>
							<td>
								<font color='gray'>
									<xsl:apply-templates select="Participants/User"/>
								</font>
							</td>
						</tr>
					</table>

					<br/>

					<table border='0' width='100%'>
						<tbody style='vertical-align:top'>
							<xsl:apply-templates select="Messages/Message|Messages/Info">
								<xsl:sort select='@ID' order='descending'/>
							</xsl:apply-templates>
						</tbody>
					</table>
				</td>
			</tr>
		</table>
		<br/>
	</xsl:template>

	<xsl:template match="Message">
		<tr>
			<td>
					[
				<xsl:apply-templates select="Time/@Time"/>]
				<xsl:apply-templates select="User"/> says:
				<i>
					<font color='blue'>
						<xsl:value-of select="Text"/>
					</font>
				</i>
			</td>
		</tr>
	</xsl:template>

	<xsl:template match="Info">
		<tr>
			<td> [
				<xsl:apply-templates select="Time/@Time"/>]
				<i>
					<font color='gray'>
						<xsl:value-of select="Text"/>
					</font>
				</i>
			</td>
		</tr>
	</xsl:template>


	<xsl:template match="User">
		<xsl:if test="position() != 1">, </xsl:if>

		<xsl:value-of select="@FriendlyName"/>
	</xsl:template>

	<xsl:template match="Time">
		<xsl:value-of select="@Date"/> on
		<xsl:value-of select="@Time"/>
	</xsl:template>

</xsl:stylesheet>
