/*
 * Decompiled with CFR 0.152.
 */
package net.sf.accolorhelper.ui;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import net.sf.accolorhelper.ColorWithText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorListModel
implements ListModel {
    private List<ColorWithText> aColors = new ArrayList<ColorWithText>();
    private Set<ListDataListener> aListeners = new HashSet<ListDataListener>();

    public ColorListModel(ColorWithText[] pColors) {
        this.aColors.addAll(Arrays.asList(pColors));
    }

    @Override
    public int getSize() {
        return this.aColors.size();
    }

    public Object getElementAt(int pIndex) {
        return this.aColors.get(pIndex);
    }

    public List<ColorWithText> getColors() {
        return this.aColors;
    }

    public void add(Color pColor, String pText) {
        this.aColors.add(new ColorWithText(pColor, pText));
        for (ListDataListener lListener : this.aListeners) {
            int lEventIndex = this.aColors.size() - 1;
            lListener.intervalAdded(new ListDataEvent(this, 1, lEventIndex, lEventIndex));
        }
    }

    public void set(int pIndex, Color pColor, String pText) {
        this.aColors.set(pIndex, new ColorWithText(pColor, pText));
        for (ListDataListener lListener : this.aListeners) {
            lListener.intervalRemoved(new ListDataEvent(this, 2, pIndex, pIndex));
            lListener.intervalAdded(new ListDataEvent(this, 1, pIndex, pIndex));
        }
    }

    public void remove(int pIndex) {
        this.aColors.remove(pIndex);
        for (ListDataListener lListener : this.aListeners) {
            lListener.intervalRemoved(new ListDataEvent(this, 2, pIndex, pIndex));
        }
    }

    public void swap(int pFirst, int pSecond) {
        ColorWithText lTemporaryColorForSwapping = this.aColors.get(pFirst);
        this.aColors.set(pFirst, this.aColors.get(pSecond));
        this.aColors.set(pSecond, lTemporaryColorForSwapping);
        for (ListDataListener lListener : this.aListeners) {
            lListener.contentsChanged(new ListDataEvent(this, 0, pFirst, pSecond));
        }
    }

    @Override
    public void addListDataListener(ListDataListener pListener) {
        this.aListeners.add(pListener);
    }

    @Override
    public void removeListDataListener(ListDataListener pListener) {
        this.aListeners.remove(pListener);
    }
}

