/*
 * Decompiled with CFR 0.152.
 */
package com.lemckes.cellarboss;

import com.lemckes.cellarboss.Bottle;
import com.lemckes.cellarboss.CellarBoss;
import com.lemckes.cellarboss.IdName;
import com.lemckes.cellarboss.IdNameList;
import com.lemckes.cellarboss.IdNameSelector;
import com.lemckes.cellarboss.WineList;
import com.lemckes.cellarboss.WineListView;
import com.lemckes.cellarboss.util.DbUtils;
import com.lemckes.cellarboss.util.TextFieldFocusHandlers;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class BottleEditorPanel
extends JPanel
implements IdNameList.UpdateListener {
    WineList wineList;
    Bottle bottle;
    WineListView managerView;
    TextFieldFocusHandlers fh = new TextFieldFocusHandlers();
    FocusAdapter moveToEndFocusListener = this.fh.getMoveToEnd();
    FocusAdapter selectAllFocusListener = this.fh.getSelectAll();
    private ActionListener idNameCheckListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            final Object source = e.getSource();
            if (source instanceof JComboBox) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IdName idName;
                        String selectorName = ((JComboBox)source).getName();
                        if (selectorName.equals(BottleEditorPanel.this.winerySelector.getName())) {
                            IdName idName2 = BottleEditorPanel.this.winerySelector.getSelected();
                            if (idName2 != null) {
                                BottleEditorPanel.this.regionSelector.setSelected(BottleEditorPanel.this.wineList.getDefaultRegion(idName2.getId()));
                            }
                        } else if (selectorName.equals(BottleEditorPanel.this.varietySelector.getName()) && (idName = BottleEditorPanel.this.varietySelector.getSelected()) != null) {
                            BottleEditorPanel.this.styleSelector.setSelected(BottleEditorPanel.this.wineList.getDefaultStyle(idName.getId()));
                        }
                    }
                });
            }
            BottleEditorPanel.this.enableSave();
        }
    };
    private JLabel idLabel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JFormattedTextField keepTilField;
    private JLabel keepTilLabel;
    private JLabel locationLabel;
    private IdNameSelector locationSelector;
    private JTextField nameField;
    private JLabel nameLabel;
    private JTextField notesField;
    private JLabel notesLabel;
    private JFormattedTextField priceField;
    private JLabel priceLabel;
    private JFormattedTextField quantityField;
    private JLabel quantityLabel;
    private JLabel regionLabel;
    private IdNameSelector regionSelector;
    private JButton saveButton;
    private JLabel styleLabel;
    private IdNameSelector styleSelector;
    private JLabel varietyLabel;
    private IdNameSelector varietySelector;
    private JFormattedTextField vintageField;
    private JLabel vintageLabel;
    private JLabel wineryLabel;
    private IdNameSelector winerySelector;

    public BottleEditorPanel(WineListView view, WineList winelist) {
        this.initComponents();
        this.managerView = view;
        this.vintageField.addFocusListener(this.moveToEndFocusListener);
        this.keepTilField.addFocusListener(this.moveToEndFocusListener);
        this.notesField.addFocusListener(this.selectAllFocusListener);
        this.priceField.addFocusListener(this.moveToEndFocusListener);
        this.quantityField.addFocusListener(this.moveToEndFocusListener);
        this.nameField.addFocusListener(this.selectAllFocusListener);
        this.winerySelector.addActionListener(this.idNameCheckListener);
        this.locationSelector.addActionListener(this.idNameCheckListener);
        this.regionSelector.addActionListener(this.idNameCheckListener);
        this.varietySelector.addActionListener(this.idNameCheckListener);
        this.styleSelector.addActionListener(this.idNameCheckListener);
        this.saveButton.setEnabled(false);
        this.wineList = winelist;
        this.setSelectorModels();
        this.clearValues();
        this.setEnabled(false);
        this.wineList.getLocations().addUpdateListener(this);
        this.wineList.getRegions().addUpdateListener(this);
        this.wineList.getStyles().addUpdateListener(this);
        this.wineList.getVarieties().addUpdateListener(this);
        this.wineList.getWineries().addUpdateListener(this);
    }

    @Override
    public void idNameDataUpdated() {
        this.setSelectorModels();
        CellarBoss.repack();
    }

    public void setSelectorModels() {
        IdName sel = this.winerySelector.getSelected();
        this.winerySelector.setIdNames(this.wineList.getWineries());
        this.winerySelector.setSelected(sel);
        sel = this.regionSelector.getSelected();
        this.regionSelector.setIdNames(this.wineList.getRegions());
        this.regionSelector.setSelected(sel);
        sel = this.varietySelector.getSelected();
        this.varietySelector.setIdNames(this.wineList.getVarieties());
        this.varietySelector.setSelected(sel);
        sel = this.styleSelector.getSelected();
        this.styleSelector.setIdNames(this.wineList.getStyles());
        this.styleSelector.setSelected(sel);
        sel = this.locationSelector.getSelected();
        this.locationSelector.setIdNames(this.wineList.getLocations());
        this.locationSelector.setSelected(sel);
    }

    public void setBottle(final Bottle bottle) {
        this.bottle = bottle;
        if (bottle == null) {
            this.clearValues();
            this.setEnabled(false);
        } else {
            this.winerySelector.setSelected(bottle.getWinery());
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BottleEditorPanel.this.regionSelector.setSelected(bottle.getRegion());
                }
            });
            this.varietySelector.setSelected(bottle.getVariety());
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BottleEditorPanel.this.styleSelector.setSelected(bottle.getStyle());
                }
            });
            this.locationSelector.setSelected(bottle.getLocation());
            this.vintageField.setValue(bottle.getVintage());
            this.keepTilField.setValue(bottle.getKeepTil());
            this.notesField.setText(bottle.getNotes());
            this.priceField.setValue(bottle.getPrice());
            this.quantityField.setValue(bottle.getQuantity());
            this.nameField.setText(bottle.getName());
            if (bottle.getId() != null) {
                this.idLabel.setText("(" + bottle.getId().toString() + ")");
            } else {
                this.idLabel.setText("(NEW)");
            }
            this.setEnabled(true);
            this.winerySelector.requestFocusInWindow();
        }
    }

    public void clearValues() {
        this.winerySelector.setSelected((IdName)null);
        this.regionSelector.setSelected((IdName)null);
        this.varietySelector.setSelected((IdName)null);
        this.styleSelector.setSelected((IdName)null);
        this.locationSelector.setSelected((IdName)null);
        this.vintageField.setValue(2000);
        this.keepTilField.setValue(2010);
        this.notesField.setText("");
        this.priceField.setValue(0);
        this.quantityField.setValue(0);
        this.nameField.setText("");
        this.idLabel.setText("()");
    }

    public Bottle getBottle() {
        return this.bottle;
    }

    private void updateBottle() {
        this.bottle.setWinery(this.winerySelector.getSelected());
        this.bottle.setRegion(this.regionSelector.getSelected());
        this.bottle.setVariety(this.varietySelector.getSelected());
        this.bottle.setStyle(this.styleSelector.getSelected());
        this.bottle.setLocation(this.locationSelector.getSelected());
        this.bottle.setVintage(((Number)this.vintageField.getValue()).intValue());
        this.bottle.setKeepTil(((Number)this.keepTilField.getValue()).intValue());
        this.bottle.setNotes(this.notesField.getText());
        this.bottle.setPrice(((Number)this.priceField.getValue()).intValue());
        this.bottle.setQuantity(((Number)this.quantityField.getValue()).intValue());
        this.bottle.setName(this.nameField.getText());
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (Component c : this.getComponents()) {
            if (c instanceof Container) {
                for (Component c2 : ((Container)c).getComponents()) {
                    c2.setEnabled(enabled);
                }
            }
            c.setEnabled(enabled);
        }
        this.enableSave();
    }

    private void enableSave() {
        boolean enabled = this.winerySelector.getSelected() != null && this.regionSelector.getSelected() != null && this.varietySelector.getSelected() != null && this.styleSelector.getSelected() != null && this.locationSelector.getSelected() != null;
        this.saveButton.setEnabled(enabled);
    }

    private void initComponents() {
        this.wineryLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.winerySelector = new IdNameSelector();
        this.regionLabel = new JLabel();
        this.regionSelector = new IdNameSelector();
        this.nameLabel = new JLabel();
        this.jPanel2 = new JPanel();
        this.nameField = new JTextField();
        this.varietyLabel = new JLabel();
        this.varietySelector = new IdNameSelector();
        this.styleLabel = new JLabel();
        this.styleSelector = new IdNameSelector();
        this.notesLabel = new JLabel();
        this.notesField = new JTextField();
        this.vintageLabel = new JLabel();
        this.jPanel4 = new JPanel();
        this.vintageField = new JFormattedTextField();
        this.keepTilLabel = new JLabel();
        this.keepTilField = new JFormattedTextField();
        this.quantityLabel = new JLabel();
        this.quantityField = new JFormattedTextField();
        this.priceLabel = new JLabel();
        this.priceField = new JFormattedTextField();
        this.locationLabel = new JLabel();
        this.locationSelector = new IdNameSelector();
        this.idLabel = new JLabel();
        this.saveButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.wineryLabel.setLabelFor(this.winerySelector);
        ResourceBundle bundle = ResourceBundle.getBundle("com/lemckes/cellarboss/Bundle");
        this.wineryLabel.setText(bundle.getString("BottleEditorPanel.wineryLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 6, 2, 3);
        this.add((Component)this.wineryLabel, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.winerySelector.setName("winerySelector");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 2, 0);
        this.jPanel1.add((Component)this.winerySelector, gridBagConstraints);
        this.regionLabel.setLabelFor(this.regionSelector);
        this.regionLabel.setText(bundle.getString("BottleEditorPanel.regionLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 9, 2, 3);
        this.jPanel1.add((Component)this.regionLabel, gridBagConstraints);
        this.regionSelector.setName("regionSelector");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 2, 0);
        this.jPanel1.add((Component)this.regionSelector, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.nameLabel.setLabelFor(this.nameField);
        this.nameLabel.setText(bundle.getString("BottleEditorPanel.nameLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.add((Component)this.nameLabel, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.nameField.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 1, 0);
        this.jPanel2.add((Component)this.nameField, gridBagConstraints);
        this.varietyLabel.setText(bundle.getString("BottleEditorPanel.varietyLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 9, 2, 3);
        this.jPanel2.add((Component)this.varietyLabel, gridBagConstraints);
        this.varietySelector.setName("varietySelector");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 2, 0);
        this.jPanel2.add((Component)this.varietySelector, gridBagConstraints);
        this.styleLabel.setText(bundle.getString("BottleEditorPanel.styleLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 9, 2, 3);
        this.jPanel2.add((Component)this.styleLabel, gridBagConstraints);
        this.styleSelector.setName("styleSelector");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 2, 0);
        this.jPanel2.add((Component)this.styleSelector, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.notesLabel.setText(bundle.getString("BottleEditorPanel.notesLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 6, 4, 3);
        this.add((Component)this.notesLabel, gridBagConstraints);
        this.notesField.setColumns(32);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.notesField, gridBagConstraints);
        this.vintageLabel.setText(bundle.getString("BottleEditorPanel.vintageLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 6, 4, 3);
        this.add((Component)this.vintageLabel, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.vintageField.setColumns(4);
        this.vintageField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 2, 0);
        this.jPanel4.add((Component)this.vintageField, gridBagConstraints);
        this.keepTilLabel.setText(bundle.getString("BottleEditorPanel.keepTilLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.jPanel4.add((Component)this.keepTilLabel, gridBagConstraints);
        this.keepTilField.setColumns(4);
        this.keepTilField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 2, 0);
        this.jPanel4.add((Component)this.keepTilField, gridBagConstraints);
        this.quantityLabel.setText(bundle.getString("BottleEditorPanel.quantityLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.jPanel4.add((Component)this.quantityLabel, gridBagConstraints);
        this.quantityField.setColumns(4);
        this.quantityField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 2, 0);
        this.jPanel4.add((Component)this.quantityField, gridBagConstraints);
        this.priceLabel.setText(bundle.getString("BottleEditorPanel.priceLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.jPanel4.add((Component)this.priceLabel, gridBagConstraints);
        this.priceField.setColumns(4);
        this.priceField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("\u00a4###0"))));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 2, 0);
        this.jPanel4.add((Component)this.priceField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 1, 0);
        this.add((Component)this.jPanel4, gridBagConstraints);
        this.locationLabel.setText(bundle.getString("BottleEditorPanel.locationLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 6, 2, 3);
        this.add((Component)this.locationLabel, gridBagConstraints);
        this.locationSelector.setName("locationSelector");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 2, 0);
        this.add((Component)this.locationSelector, gridBagConstraints);
        this.idLabel.setText("id");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(3, 9, 2, 6);
        this.add((Component)this.idLabel, gridBagConstraints);
        this.saveButton.setText(bundle.getString("BottleEditorPanel.saveButton.text"));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BottleEditorPanel.this.saveButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 9, 2, 6);
        this.add((Component)this.saveButton, gridBagConstraints);
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        boolean newBottle = true;
        if (this.bottle.getId() != null) {
            newBottle = false;
        }
        this.updateBottle();
        try {
            this.wineList.saveBottle(this.bottle);
            this.managerView.tableChanged();
            this.winerySelector.requestFocusInWindow();
        }
        catch (SQLException ex) {
            DbUtils.logSQLException(this.getClass(), "Save Bottle Failed", ex);
            JOptionPane.showMessageDialog(this, ex, "Save Error", 0);
        }
        if (!newBottle) {
            this.setBottle(null);
        }
    }
}

