/*
 * Decompiled with CFR 0.152.
 */
package com.lemckes.cellarboss.util;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.text.JTextComponent;

public class TextFieldFocusHandlers {
    private FocusAdapter moveToEndFocusListener = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent evt) {
            final Component source = evt.getComponent();
            if (source instanceof JTextComponent) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JTextComponent c = (JTextComponent)source;
                        int len = c.getText().length();
                        c.setCaretPosition(len);
                    }
                });
            }
        }
    };
    private FocusAdapter selectAllFocusListener = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent e) {
            final Component source = e.getComponent();
            if (source instanceof JTextComponent) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JTextComponent c = (JTextComponent)source;
                        c.selectAll();
                    }
                });
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            final Component source = e.getComponent();
            if (source instanceof JTextComponent) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JTextComponent c = (JTextComponent)source;
                        c.select(0, 0);
                    }
                });
            }
        }
    };

    public FocusAdapter getMoveToEnd() {
        return this.moveToEndFocusListener;
    }

    public FocusAdapter getSelectAll() {
        return this.selectAllFocusListener;
    }
}

