/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.olap.xmla;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.olap.result.JROlapCell;
import net.sf.jasperreports.olap.result.JROlapResult;
import net.sf.jasperreports.olap.result.JROlapResultAxis;
import net.sf.jasperreports.olap.xmla.JRXmlaCell;
import net.sf.jasperreports.olap.xmla.JRXmlaResultAxis;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRXmlaResult
implements JROlapResult {
    private static final Log log = LogFactory.getLog(JRXmlaResult.class);
    private List axesList = new ArrayList();
    private JRXmlaResultAxis[] axes;
    private int[] cellOrdinalFactors;
    private final List cells = new ArrayList();

    public JROlapResultAxis[] getAxes() {
        return this.ensureAxisArray();
    }

    public JROlapCell getCell(int[] axisPositions) {
        int cellOrdinal = this.getCellOrdinal(axisPositions);
        if (cellOrdinal < this.cells.size()) {
            return (JROlapCell)this.cells.get(cellOrdinal);
        }
        return null;
    }

    protected int getCellOrdinal(int[] axisPositions) {
        this.ensureCellOrdinalFactors();
        if (axisPositions.length != this.axes.length) {
            throw new JRRuntimeException("Number of axis positions (" + axisPositions.length + ") doesn't match the number of axes (" + this.axes.length + ")");
        }
        int ordinal = 0;
        for (int i = 0; i < axisPositions.length; ++i) {
            ordinal += this.cellOrdinalFactors[i] * axisPositions[i];
        }
        return ordinal;
    }

    public void addAxis(JRXmlaResultAxis axis) {
        this.axesList.add(axis);
        this.resetAxisArray();
    }

    public JRXmlaResultAxis getAxisByName(String name) {
        JRXmlaResultAxis axis = null;
        Iterator iter = this.axesList.iterator();
        while (axis == null && iter.hasNext()) {
            JRXmlaResultAxis ax = (JRXmlaResultAxis)iter.next();
            if (!ax.getAxisName().equals(name)) continue;
            axis = ax;
        }
        return axis;
    }

    protected JRXmlaResultAxis[] ensureAxisArray() {
        if (this.axes == null) {
            this.axes = new JRXmlaResultAxis[this.axesList.size()];
            this.axes = this.axesList.toArray(this.axes);
        }
        return this.axes;
    }

    protected void ensureCellOrdinalFactors() {
        this.ensureAxisArray();
        if (this.cellOrdinalFactors == null) {
            int axisCount = this.axes.length;
            this.cellOrdinalFactors = new int[axisCount];
            this.cellOrdinalFactors[0] = 1;
            for (int i = 1; i < axisCount; ++i) {
                this.cellOrdinalFactors[i] = this.cellOrdinalFactors[i - 1] * this.axes[i - 1].getTupleCount();
            }
        }
    }

    protected void resetAxisArray() {
        this.axes = null;
        this.cellOrdinalFactors = null;
    }

    public void setCell(JRXmlaCell cell, int cellOrdinal) {
        int cellsCount = this.cells.size();
        if (cellOrdinal == -1 || cellOrdinal == cellsCount) {
            this.cells.add(cell);
        } else if (cellOrdinal > cellsCount) {
            for (int i = cellsCount; i < cellOrdinal; ++i) {
                this.cells.add(null);
            }
            this.cells.add(cell);
        } else {
            if (log.isWarnEnabled()) {
                log.warn("Overwriting cell at ordinal " + cellOrdinal);
            }
            this.cells.set(cellOrdinal, cell);
        }
    }
}

