/*
 * Decompiled with CFR 0.152.
 */
package application;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.SoftBevelBorder;

public class Overview
extends JDialog {
    private JButton OK;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;

    public Overview(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setLocation(parent.getLocation().x + 50, parent.getLocation().y + 50);
        this.OK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Overview.this.setVisible(false);
                Overview.this.dispose();
            }
        });
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.OK = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.setTitle("Classroom Scheduler - How to Use");
        this.setLocationRelativeTo(null);
        this.setModal(true);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Overview.this.closeDialog(evt);
            }
        });
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setViewportBorder(new CompoundBorder(new LineBorder(new Color(0, 0, 0)), new SoftBevelBorder(0)));
        this.jScrollPane1.setFocusable(false);
        this.jScrollPane1.setPreferredSize(new Dimension(121, 300));
        this.jScrollPane1.setAutoscrolls(true);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setFont(new Font("Times New Roman", 0, 14));
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setText("What is it?\n\nThe Classroom Scheduler is a program designed to help people who are responsible for scheduling classes, professors and classrooms at colleges and universities.   It is an assistant to the user, meaning that it does not make any decisions about the schedule, but maintains information about the schedule as it is created and modified.  The program maintains information such as conflicts and summary information.\nThe Classroom Scheduler has some features that reflect how we do things at Valencia Community College in Orlando, so users from other colleges may find that some features are difficult to understand.\n\nWhat does it do?\n\nIt allows the user to enter the resources that are going to be scheduled for a given semester.  Resources are Professors, Classrooms, Classes, and Timeslots to be used in a semester.  It then allows the user to assign these resources, creating a schedule.  It will search for conflicts in the schedule, and allow the user to view the schedule in text, or graphical form.  It does not decide anything for the user, but shows the current state of the schedule using various views.  A key part of this program\u2019s design is to allow the user to change the schedule, and observe the impact on the conflicts, summary, the individual professor\u2019s schedule, and the schedule for a particular classroom.\n\nWho needs it?\n\nThose who have the responsibility of setting, and modifying the schedule of classes that will be delivered within a department may need this program.  It is not for a college administrator who collects the schedule for thousands of classes and rooms, etc.; it is for a Department Dean, Program Director, Coordinator or Chair who will schedule from a few dozen to a few hundred classes.  \n\nWhere did it come from?\n\nIt was written by Dr. Colin Archibald at Valencia Community College in Orlando, FL.  Several students contributed to this effort, including a few interns who made significant contributions.   It was motivated by the difficult task of scheduling classes at Valencia Community College.  The need for the assistant became evident when we found that it was almost impossible to schedule 50 classes in 4 classrooms with 6 full-time instructors and a dozen adjuncts.  There would always be conflicts, and changes that caused other changes were very difficult to manage.  We always seemed to get two classes in the same room at the same time, or to leave a good time slot empty.  Sometimes a professors schedule would be quite ugly with 3 classes back to back or a gap of 5 hours in the middle of the day.  These schedules were not designed, they results from not being able to easily see the resources available, and modify the schedule as a living document.  \nThe modification of a schedule that is maintained on paper is almost impossible.  If Professor X would prefer to teach Course Y earlier in the day, but that means that Course Z needs to be rescheduled, bumping Course ZZ,... you get the picture.  Well, if you don't recognize this sort of frustrating scenario, you might not need this program.\n\n\nHow do I use it?\n\n\nThe first time you use the Classroom Scheduler, select Example Schedule from the Help menu.  This will allow you to look at the functionality of the program.  Experiment with looking at each of the tabs,  Modify the schedule, View the schedule as Charts, examine the Conflicts that exist, and the summary information generated in the schedule.  Experiment with modifying the schedule and looking at the results in terms of what is in each room, what does each professor\u2019s schedule look like, can you fix a conflict by moving a course to a different room, etc.  The user interface has tool tips that will pop up as you move the mouse over the buttons, tables, etc.  These tool tips should explain what can be done with each of these buttons, etc.\n\nThe Resources tab is where the user enters the items that may be scheduled.  For example, each professor that is available will be added under the Professors Panel.  Adding resources that can be scheduled does not put them in the schedule, it makes them available to be put in the schedule from the Modify Schedule tab.  You can always go back and add more Resources when necessary.  \n\nBe careful with Example Schedule.  If you have some schedule data entered, and select Example schedule from the Help menu, the example data will be mixed in with your schedule.  We should probably fix this, or warn the user that this will happen in a future release.\n\nSaving a schedule.  Schedules are saved in files that end with .crs (Classroom Scheduler).  These files can be reopened and edited, and changes saved.  A CRS file cannot be opened by any other application.  If you need to email the schedule to others, it can be exported as a csv (comma separated values) file.  A csv file can be opened in any program that knows about this type of file, most commonly Microsoft Excel.  \n\nCurrently there is no way to import a csv file back into the Classroom Scheduler, so users should not edit the csv files without going back into the Classroom Scheduler to make the changes.\n\n\nI\u2019m stuck, what now?\n\n\nThis program is free, open source, and distributed under the Academic Free License.  That means that there isn\u2019t going to be support that commercial software would have.  However, we are interested in helping people use the program, and making improvements so that it will be useful to more people.  \n\n\nWhat can\u2019t you do that would be useful, or necessary to make the program usable?  Tell us about it.\n\nThe project administrator is Colin Archibald, and questions, complaints, suggestions should be sent to him \u2013 he will be pleased to hear from you:  CArchibald@valenciacc.edu\n\nPutting Classroom Scheduler in the subject line would help.\n");
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setFocusable(false);
        this.jTextArea1.setMargin(new Insets(15, 5, 15, 5));
        this.jTextArea1.setMinimumSize(new Dimension(110, 300));
        this.jTextArea1.setPreferredSize(new Dimension(110, 1700));
        this.jTextArea1.setRequestFocusEnabled(false);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 500;
        gridBagConstraints.ipady = 300;
        gridBagConstraints.insets = new Insets(24, 24, 0, 24);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.OK.setText("Close");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.insets = new Insets(26, 0, 16, 0);
        this.getContentPane().add((Component)this.OK, gridBagConstraints);
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new Overview((Frame)new JFrame(), true).setVisible(true);
    }
}

