/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.Summary;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import resources.Classroom;
import resources.Conflict;
import resources.Constants;
import resources.Course;
import resources.Professor;
import resources.SchedCourse;
import resources.Textbook;
import resources.TimeSlot;

public class Schedule
extends Observable
implements Constants,
Serializable,
Printable,
Pageable,
Observer {
    static final long serialVersionUID = 911L;
    public static final String DEFAULT_FILE_NAME = "Untitled.crs";
    private static Schedule schedule = null;
    private static boolean changed = false;
    private Date lastUpdated = new Date();
    private String scheduleName = "Untitled.crs";
    private String directory = ".";
    private ArrayList professors = new ArrayList(20);
    private ArrayList classrooms = new ArrayList(20);
    private ArrayList timeSlots = new ArrayList(20);
    private ArrayList courses = new ArrayList(20);
    private ArrayList schedCourses = new ArrayList(20);
    private ArrayList conflicts = new ArrayList(20);
    private ArrayList books = new ArrayList(20);
    private Summary summary = null;

    private Schedule() {
        this.addTheTBAs();
    }

    public synchronized void update(Observable self, Object obj) {
        changed = true;
        this.lastUpdated = new Date();
    }

    private void setLastUpdated(Date d) {
        this.lastUpdated = d;
    }

    private Date getLastUpdated() {
        return this.lastUpdated;
    }

    public void setChanged(boolean b) {
        changed = b;
    }

    public boolean getChanged() {
        return changed;
    }

    public String updated() {
        DateFormat df = DateFormat.getDateTimeInstance(2, 3);
        return "   Updated: " + df.format(this.lastUpdated);
    }

    public synchronized void resetSchedule(Schedule localSchedule, String name) {
        if (localSchedule != null) {
            schedule.setScheduleName(name);
            schedule.setDirectory(localSchedule.getDirectory());
            schedule.setProfessors(localSchedule.getProfessors());
            schedule.setClassrooms(localSchedule.getClassrooms());
            schedule.setTimeSlots(localSchedule.getTimeSlots());
            schedule.setCourses(localSchedule.getCourses());
            schedule.setBooks(localSchedule.getBooks());
            schedule.setSchedCourses(localSchedule.getSchedCourses());
            schedule.setLastUpdated(localSchedule.getLastUpdated());
            schedule.setChanged(false);
        } else {
            this.scheduleName = DEFAULT_FILE_NAME;
            this.directory = ".";
            this.professors = new ArrayList(20);
            this.classrooms = new ArrayList(20);
            this.timeSlots = new ArrayList(20);
            this.courses = new ArrayList(20);
            this.books = new ArrayList(20);
            this.schedCourses = new ArrayList(20);
            this.conflicts = new ArrayList(20);
            this.summary = new Summary();
            this.addTheTBAs();
            this.setChanged();
            this.notifyObservers();
        }
    }

    private void addTheTBAs() {
        this.professors.add(new Professor(" ", " STAFF", 2));
        this.classrooms.add(new Classroom(" ", "TBA", 0));
        this.timeSlots.add(new TimeSlot().setTba());
        this.timeSlots.add(new TimeSlot().setOnline());
    }

    public static synchronized Schedule getSchedule() {
        if (schedule == null) {
            schedule = new Schedule();
            return schedule;
        }
        return schedule;
    }

    public synchronized String getScheduleName() {
        return this.scheduleName;
    }

    public synchronized void setScheduleName(String scheduleName) {
        this.scheduleName = scheduleName;
    }

    public synchronized String getDirectory() {
        return this.directory;
    }

    public synchronized void setDirectory(String directory) {
        this.directory = directory;
    }

    public ArrayList getProfessors() {
        return this.professors;
    }

    public synchronized void setProfessors(ArrayList professors) {
        this.professors = professors;
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized ArrayList getClassrooms() {
        return this.classrooms;
    }

    public synchronized void setClassrooms(ArrayList classrooms) {
        this.classrooms = classrooms;
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized ArrayList getCourses() {
        return this.courses;
    }

    public synchronized void setCourses(ArrayList courses) {
        this.courses = courses;
        this.setChanged();
        this.notifyObservers();
    }

    public ArrayList getTimeSlots() {
        return this.timeSlots;
    }

    public synchronized void setTimeSlots(ArrayList timeSlots) {
        this.timeSlots = timeSlots;
        this.setChanged();
        this.notifyObservers();
    }

    public ArrayList getBooks() {
        return this.books;
    }

    public void setBooks(ArrayList books) {
        this.books = books;
        this.setChanged();
        this.notifyObservers();
    }

    public ArrayList getSchedCourses() {
        return this.schedCourses;
    }

    public synchronized void setSchedCourses(ArrayList schedCourses) {
        this.schedCourses = schedCourses;
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized ArrayList getConflicts() {
        return this.conflicts;
    }

    public synchronized Summary getSummary() {
        if (this.summary == null) {
            this.summary = new Summary();
        }
        return this.summary;
    }

    public synchronized void addProfessor(Professor prof) {
        if (!this.professors.contains(prof)) {
            this.professors.add(prof);
            Collections.sort(this.professors);
            this.setChanged();
            this.notifyObservers();
        }
    }

    public synchronized void removeProfessor(Professor prof) {
        this.professors.remove(prof);
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized void addClassroom(Classroom classroom) {
        if (!this.classrooms.contains(classroom)) {
            this.classrooms.add(classroom);
            Collections.sort(this.classrooms);
            this.setChanged();
            this.notifyObservers();
        }
    }

    public synchronized void removeClassroom(Classroom classroom) {
        this.classrooms.remove(classroom);
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized void addTimeSlot(TimeSlot timeSlot) {
        if (!this.timeSlots.contains(timeSlot)) {
            this.timeSlots.add(timeSlot);
            Collections.sort(this.timeSlots);
            this.setChanged();
            this.notifyObservers();
        }
    }

    public synchronized void removeTimeSlot(TimeSlot timeSlot) {
        this.timeSlots.remove(timeSlot);
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized void addCourse(Course course) {
        if (!this.courses.contains(course)) {
            this.courses.add(course);
            Collections.sort(this.courses);
            this.setChanged();
            this.notifyObservers();
        }
    }

    public synchronized void removeCourse(Course course) {
        this.courses.remove(course);
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized void addBook(Textbook book) {
        if (!this.books.contains(book)) {
            this.books.add(book);
            this.setChanged();
            this.notifyObservers();
        }
    }

    public synchronized void removeBook(Textbook book) {
        this.books.remove(book);
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized void addSchedCourse(SchedCourse schedCourse) {
        if (!this.schedCourses.contains(schedCourse)) {
            schedCourse.getCourse().setScheduled(true);
            this.schedCourses.add(schedCourse);
            Collections.sort(this.schedCourses);
            this.setChanged();
            this.notifyObservers();
        }
    }

    public synchronized void removeSchedCourse(SchedCourse schedCourse) {
        schedCourse.getCourse().setScheduled(false);
        this.schedCourses.remove(schedCourse);
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized void sort(int key) {
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized void changed() {
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized void findConflicts() {
        this.conflicts.removeAll(this.conflicts);
        Iterator it = this.schedCourses.iterator();
        while (it.hasNext()) {
            ((SchedCourse)it.next()).setConflict(null);
        }
        for (int i = 0; i < this.schedCourses.size(); ++i) {
            for (int j = i + 1; j < this.schedCourses.size(); ++j) {
                SchedCourse sched2;
                SchedCourse sched1 = (SchedCourse)this.schedCourses.get(i);
                if (!sched1.overlap(sched2 = (SchedCourse)this.schedCourses.get(j))) continue;
                Professor i1 = sched1.getProfessor();
                Professor i2 = sched2.getProfessor();
                if (i1.getLastName().equals(i2.getLastName()) && !i1.getLastName().trim().equals("STAFF")) {
                    Conflict c = new Conflict((SchedCourse)this.schedCourses.get(i), (SchedCourse)this.schedCourses.get(j), 2);
                    this.conflicts.add(c);
                    sched1.setConflict(c);
                    sched2.setConflict(c);
                    continue;
                }
                Classroom cr1 = ((SchedCourse)this.schedCourses.get(i)).getClassroom();
                Classroom cr2 = ((SchedCourse)this.schedCourses.get(j)).getClassroom();
                if (!cr1.getRoomName().equals(cr2.getRoomName()) || !cr1.getBuilding().equals(cr2.getBuilding()) || cr1.getRoomName().trim().equals("TBA")) continue;
                Conflict c = new Conflict((SchedCourse)this.schedCourses.get(i), (SchedCourse)this.schedCourses.get(j), 1);
                this.conflicts.add(c);
                sched1.setConflict(c);
                sched2.setConflict(c);
            }
        }
    }

    public synchronized void exportCsv(File outCsv) throws IOException {
        PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(outCsv)));
        pw.println("CRN,Name,Course Title, Course #, Section #,Credit Hrs,Bldg,Room,Time,MTWRFSN,Cap,Note/Conflict");
        for (SchedCourse item : this.schedCourses) {
            pw.print(item.getProfessor().getLastName().toUpperCase() + "," + item.getCrn() + "," + item.getCourse().getCourseName() + "," + item.getCourse().getField() + item.getCourse().getCourseNumber() + "," + item.getCourse().getSectionPrefix() + item.getCourse().getSectionNumber() + "," + "," + item.getClassroom().getBuilding() + "," + item.getClassroom().getRoomName() + "," + item.getTimeSlot().toTimeString() + "," + item.getTimeSlot().toDaysString() + "," + item.getClassroom().getCapacity() + "," + item.getNote() + "  ");
            Conflict conflict = item.getConflict();
            if (conflict != null) {
                String strConflict = "Conflict: ";
                SchedCourse inCon = null;
                inCon = conflict.getSched1().equals(item) ? conflict.getSched2() : conflict.getSched1();
                strConflict = strConflict + inCon.getCourse().getField() + inCon.getCourse().getCourseNumber() + " " + inCon.getCourse().getSectionPrefix() + inCon.getCourse().getSectionNumber();
                pw.print(strConflict);
            }
            pw.println();
        }
        pw.close();
    }

    public synchronized int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        if (pageIndex > this.getNumberOfPages()) {
            return 1;
        }
        this.draw(g, pageFormat, pageIndex, new Rectangle((int)pageFormat.getPaper().getImageableX(), (int)pageFormat.getPaper().getImageableY(), (int)pageFormat.getPaper().getImageableWidth(), (int)pageFormat.getPaper().getImageableHeight()));
        return 0;
    }

    private synchronized void draw(Graphics g, PageFormat pageFormat, int pageIndex, Rectangle r) {
        Graphics g2d = g;
        ((Graphics2D)g).setStroke(new BasicStroke(0.5f));
        Font titleFont = new Font("Monospaced", 1, 10);
        Font regFont = new Font("Monospaced", 0, 8);
        Font regFontBold = new Font("Monospaced", 1, 8);
        FontMetrics fm = g2d.getFontMetrics(titleFont);
        String header = "Class Schedule:  " + this.scheduleName + this.updated();
        String footer = "Total of: " + schedule.getSchedCourses().size() + " classes.";
        int titleWidth = fm.stringWidth(header);
        int titleHeight = fm.getHeight();
        int lineHeight = fm.getHeight();
        int linesPerPage = 40;
        g.setFont(titleFont);
        g.drawString(header, (int)pageFormat.getImageableX(), (int)pageFormat.getImageableY() + titleHeight);
        String pageNumberString = pageIndex + 1 + "/" + this.getNumberOfPages();
        g.drawString(pageNumberString, (int)((double)(r.width - fm.stringWidth(pageNumberString)) + pageFormat.getImageableX()), (int)pageFormat.getImageableY() + titleHeight);
        fm = g.getFontMetrics(regFont);
        int ypos = (int)pageFormat.getImageableY() + titleHeight * 2;
        g.setFont(regFont);
        String prev = "";
        int currentRecord = pageIndex * linesPerPage;
        boolean currentLine = false;
        g.drawLine(r.x, ypos + 5 - lineHeight, r.x + r.width, ypos + 5 - lineHeight);
        for (int i = currentRecord; i < currentRecord + linesPerPage; ++i) {
            SchedCourse sc = (SchedCourse)schedule.getSchedCourses().get(i);
            if (sc.getConflict() != null) {
                g.setFont(regFontBold);
            } else {
                g.setFont(regFont);
            }
            g.drawString(sc.toString(), (int)pageFormat.getImageableX(), ypos);
            if ((i + 1) % 4 == 0) {
                g.drawLine(r.x, ypos + 5, r.x + r.width, ypos + 5);
            }
            if (!sc.getNote().equals("") && sc.getNote() != null) {
                g.drawString("   " + sc.getNote(), (int)pageFormat.getImageableX(), ypos += lineHeight);
                --linesPerPage;
            }
            ypos += lineHeight;
            if (i != schedule.getSchedCourses().size() - 1) continue;
            g.setFont(titleFont);
            g.drawString(footer, (int)pageFormat.getImageableX(), ypos += lineHeight);
            break;
        }
    }

    public synchronized int getNumberOfPages() {
        return this.schedCourses.size() / 41 + 1;
    }

    public synchronized Printable getPrintable(int pageIndex) {
        return this;
    }

    public synchronized PageFormat getPageFormat(int pageIndex) {
        PageFormat pageFormat = PrinterJob.getPrinterJob().defaultPage();
        Paper paper = pageFormat.getPaper();
        pageFormat.setPaper(paper);
        return pageFormat;
    }
}

