/*
 * Decompiled with CFR 0.152.
 */
package panels;

import application.ClassroomScheduler;
import application.Schedule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import panels.ScheduleTableModel;
import panels.TableSorter;
import resources.Classroom;
import resources.Course;
import resources.DialogCellEditor;
import resources.Professor;
import resources.SchedCourse;
import resources.TimeSlot;

public class ModifySchedule
extends JPanel
implements Observer {
    private JButton addButton;
    private JComboBox cbClassroom;
    private JComboBox cbProfessor;
    private JComboBox cbTimeSlot;
    private JList courseList;
    private JButton deleteButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTable jTable1;
    private JButton printButton;
    private JTextField sectionCounter;
    private JLabel sectionCounterLabel;
    private Schedule schedule = Schedule.getSchedule();
    private Component parent;
    private ScheduleTableModel stm;
    private TableSorter sorter;
    private TableColumn courseColumn;
    private TableColumn crnColumn;
    private TableColumn roomColumn;
    private TableColumn timeSlotColumn;
    private TableColumn professorColumn;
    private TableColumn conflictColumn;
    private TableColumn noteColumn;
    private JComboBox professorTableCB;
    private JComboBox timeSlotTableCB;
    private JComboBox classroomTableCB;
    private JTextField crnTableTF;
    private DialogCellEditor myCE;

    public ModifySchedule(Component parent) {
        this.parent = parent;
        this.initComponents();
        this.professorTableCB = new JComboBox();
        this.timeSlotTableCB = new JComboBox();
        this.classroomTableCB = new JComboBox();
        this.crnTableTF = new JTextField();
        this.myCE = new DialogCellEditor();
        this.stm = new ScheduleTableModel();
        this.sorter = new TableSorter(this.stm);
        this.sorter.addMouseListenerToHeaderInTable(this.jTable1);
        this.jTable1.setModel(this.sorter);
        this.addListeners();
        this.setColumnSizes();
        this.roomColumn.setCellEditor(new DefaultCellEditor(this.classroomTableCB));
        this.timeSlotColumn.setCellEditor(new DefaultCellEditor(this.timeSlotTableCB));
        this.professorColumn.setCellEditor(new DefaultCellEditor(this.professorTableCB));
        this.crnColumn.setCellEditor(new DefaultCellEditor(this.crnTableTF));
        this.noteColumn.setCellEditor(this.myCE);
    }

    private void setColumnSizes() {
        TableColumn column = null;
        column = this.jTable1.getColumnModel().getColumn(0);
        column.setPreferredWidth(110);
        column = this.jTable1.getColumnModel().getColumn(1);
        column.setMaxWidth(45);
        column = this.jTable1.getColumnModel().getColumn(2);
        column.setMaxWidth(65);
        column = this.jTable1.getColumnModel().getColumn(3);
        column.setPreferredWidth(75);
        column = this.jTable1.getColumnModel().getColumn(4);
        column.setPreferredWidth(100);
        column = this.jTable1.getColumnModel().getColumn(5);
        column.setMaxWidth(50);
        column = this.jTable1.getColumnModel().getColumn(6);
        column.setMaxWidth(100);
        this.courseColumn = this.jTable1.getColumnModel().getColumn(0);
        this.crnColumn = this.jTable1.getColumnModel().getColumn(1);
        this.roomColumn = this.jTable1.getColumnModel().getColumn(2);
        this.timeSlotColumn = this.jTable1.getColumnModel().getColumn(3);
        this.professorColumn = this.jTable1.getColumnModel().getColumn(4);
        this.conflictColumn = this.jTable1.getColumnModel().getColumn(5);
        this.noteColumn = this.jTable1.getColumnModel().getColumn(6);
    }

    private void addListeners() {
        ModifyPanelListener modifyPanelListener = new ModifyPanelListener();
        this.addButton.addActionListener(modifyPanelListener);
        this.deleteButton.addActionListener(modifyPanelListener);
        this.printButton.addActionListener(modifyPanelListener);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel3 = new JPanel();
        this.deleteButton = new JButton();
        this.printButton = new JButton();
        this.sectionCounter = new JTextField();
        this.sectionCounterLabel = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.courseList = new JList();
        this.jPanel4 = new JPanel();
        this.addButton = new JButton();
        this.cbTimeSlot = new JComboBox();
        this.cbClassroom = new JComboBox();
        this.cbProfessor = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jScrollPane1.setToolTipText("Double click/drop down to edit.  Course and Conflict may not be edited");
        this.jScrollPane1.setPreferredSize(new Dimension(400, 403));
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable1.setToolTipText("Edit by drop down, or double click.  Course and Conflict cannot be edited");
        this.jTable1.setPreferredScrollableViewportSize(new Dimension(300, 400));
        this.jScrollPane1.setViewportView(this.jTable1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.weighty = 0.9;
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.deleteButton.setToolTipText("Remove from schedule.  Return the removed sections to the list of sections available to be scheduled");
        this.deleteButton.setActionCommand("Delete Selected Course(s)");
        this.deleteButton.setLabel("Delete Selected Course(s)");
        this.deleteButton.setMaximumSize(new Dimension(175, 26));
        this.deleteButton.setMinimumSize(new Dimension(250, 26));
        this.deleteButton.setPreferredSize(new Dimension(190, 26));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ModifySchedule.this.deleteButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.deleteButton);
        this.printButton.setText("Print Schedule");
        this.printButton.setToolTipText("Send schedule to printer");
        this.jPanel3.add(this.printButton);
        this.sectionCounter.setBackground(Color.lightGray);
        this.sectionCounter.setText("             ");
        this.sectionCounter.setToolTipText("This many sections are in the schedule");
        this.sectionCounter.setFocusable(false);
        this.sectionCounter.setMargin(new Insets(0, 5, 0, 5));
        this.sectionCounter.setMinimumSize(new Dimension(35, 20));
        this.sectionCounter.setPreferredSize(new Dimension(35, 20));
        this.sectionCounter.setRequestFocusEnabled(false);
        this.jPanel3.add(this.sectionCounter);
        this.sectionCounterLabel.setText("sections.");
        this.jPanel3.add(this.sectionCounterLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(17, 0, 0, 0);
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(17, 17, 17, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(new CompoundBorder(new EtchedBorder(), new BevelBorder(0)));
        this.jPanel2.setPreferredSize(new Dimension(178, 500));
        this.jLabel1.setText("Time Slot:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 11, 10, 11);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("Classroom:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(10, 11, 10, 11);
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("Professor:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(10, 11, 10, 11);
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        this.courseList.setToolTipText("Course sections that may be scheduled");
        this.jScrollPane2.setViewportView(this.courseList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.9;
        gridBagConstraints.insets = new Insets(2, 5, 3, 5);
        this.jPanel2.add((Component)this.jScrollPane2, gridBagConstraints);
        this.addButton.setText("Add Course(s)");
        this.addButton.setToolTipText("Add the course(es) to the schedule");
        this.jPanel4.add(this.addButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jPanel4, gridBagConstraints);
        this.cbTimeSlot.setToolTipText("Select a time slot");
        this.cbTimeSlot.setAlignmentX(0.0f);
        this.cbTimeSlot.setAlignmentY(0.0f);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 30;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel2.add((Component)this.cbTimeSlot, gridBagConstraints);
        this.cbClassroom.setToolTipText("Select a classroom");
        this.cbClassroom.setAlignmentX(0.0f);
        this.cbClassroom.setAlignmentY(0.0f);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 30;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel2.add((Component)this.cbClassroom, gridBagConstraints);
        this.cbProfessor.setToolTipText("Select a professor");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 30;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel2.add((Component)this.cbProfessor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(17, 17, 17, 17);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
    }

    public void update(Observable observable, Object obj) {
        this.stm.fireTableDataChanged();
        ArrayList courses = this.schedule.getCourses();
        Vector unScheduledCourses = new Vector(20, 10);
        for (int i = 0; i < courses.size(); ++i) {
            if (((Course)courses.get(i)).getIsScheduled()) continue;
            unScheduledCourses.addElement(courses.get(i));
        }
        this.courseList.setListData(unScheduledCourses);
        this.cbProfessor.removeAllItems();
        Iterator it = this.schedule.getProfessors().iterator();
        while (it.hasNext()) {
            this.cbProfessor.addItem(it.next());
        }
        this.cbTimeSlot.removeAllItems();
        it = this.schedule.getTimeSlots().iterator();
        while (it.hasNext()) {
            this.cbTimeSlot.addItem(it.next());
        }
        this.cbClassroom.removeAllItems();
        it = this.schedule.getClassrooms().iterator();
        while (it.hasNext()) {
            this.cbClassroom.addItem(it.next());
        }
        this.professorTableCB.removeAllItems();
        it = this.schedule.getProfessors().iterator();
        while (it.hasNext()) {
            this.professorTableCB.addItem(it.next());
        }
        this.timeSlotTableCB.removeAllItems();
        it = this.schedule.getTimeSlots().iterator();
        while (it.hasNext()) {
            this.timeSlotTableCB.addItem(it.next());
        }
        this.classroomTableCB.removeAllItems();
        it = this.schedule.getClassrooms().iterator();
        while (it.hasNext()) {
            this.classroomTableCB.addItem(it.next());
        }
        this.sectionCounter.setText(String.valueOf(this.schedule.getSchedCourses().size()));
    }

    private void printTheView(Pageable toPrint, boolean confirm) {
        System.out.println("I'm going to print a table");
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPageable(toPrint);
        if (confirm && printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (PrinterException pe) {
                System.out.println(pe);
                JOptionPane.showMessageDialog(ClassroomScheduler.getFrame(), "Error printing a schedule.", "Unknown Printer Error", 0);
            }
        }
    }

    class ModifyPanelListener
    implements ActionListener {
        ModifyPanelListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block8: {
                block7: {
                    System.out.println("I hear this:\n" + actionEvent.getSource() + "\n");
                    if (actionEvent.getSource() == ModifySchedule.this.printButton) {
                        ModifySchedule.this.printTheView(ModifySchedule.this.schedule, true);
                    }
                    if (actionEvent.getSource() != ModifySchedule.this.addButton) break block7;
                    Object[] coursesToSchedule = ModifySchedule.this.courseList.getSelectedValues();
                    if (coursesToSchedule.length == 0) {
                        JOptionPane.showMessageDialog(ModifySchedule.this.parent, "Select a course to be scheduled");
                        return;
                    }
                    Professor profToSchedule = (Professor)ModifySchedule.this.cbProfessor.getSelectedItem();
                    if (profToSchedule == null) {
                        JOptionPane.showMessageDialog(ModifySchedule.this.parent, "Select a professor to be scheduled");
                        return;
                    }
                    TimeSlot timeSlotToSchedule = (TimeSlot)ModifySchedule.this.cbTimeSlot.getSelectedItem();
                    if (timeSlotToSchedule == null) {
                        JOptionPane.showMessageDialog(ModifySchedule.this.parent, "Select a time slot to schedule");
                        return;
                    }
                    int selected = ModifySchedule.this.cbClassroom.getSelectedIndex();
                    if (selected < 0) {
                        JOptionPane.showMessageDialog(ModifySchedule.this.parent, "Select a room to schedule");
                        return;
                    }
                    Classroom classroomToSchedule = (Classroom)ModifySchedule.this.schedule.getClassrooms().get(selected);
                    for (int i = 0; i < coursesToSchedule.length; ++i) {
                        SchedCourse theNewScheduledCourse = new SchedCourse(profToSchedule, classroomToSchedule, (Course)coursesToSchedule[i], timeSlotToSchedule);
                        ModifySchedule.this.schedule.addSchedCourse(theNewScheduledCourse);
                    }
                    break block8;
                }
                if (actionEvent.getSource() != ModifySchedule.this.deleteButton) break block8;
                int[] selected = ModifySchedule.this.jTable1.getSelectedRows();
                for (int i = selected.length - 1; i >= 0; --i) {
                    ModifySchedule.this.crnColumn.getCellEditor().cancelCellEditing();
                    ModifySchedule.this.roomColumn.getCellEditor().cancelCellEditing();
                    ModifySchedule.this.timeSlotColumn.getCellEditor().cancelCellEditing();
                    ModifySchedule.this.professorColumn.getCellEditor().cancelCellEditing();
                    ModifySchedule.this.noteColumn.getCellEditor().cancelCellEditing();
                    ModifySchedule.this.schedule.removeSchedCourse((SchedCourse)ModifySchedule.this.schedule.getSchedCourses().get(selected[i]));
                }
            }
        }
    }
}

