/*
 * Decompiled with CFR 0.152.
 */
package panels;

import application.Schedule;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import panels.RoomsTableModel;
import panels.TableSorter;
import resources.Classroom;

public class RoomsPanel
extends JPanel
implements Observer {
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextField3;
    private RoomsPanelListener roomsPanelListener;
    private Schedule schedule = Schedule.getSchedule();
    private RoomsTableModel ptm;
    private TableSorter sorter;
    private TableColumn buildingColumn;
    private TableColumn roomColumn;
    private TableColumn capacityColumn;
    private JTextField editBuilding = new JTextField();
    private JTextField editRoom = new JTextField();
    private JTextField editCapacity = new JTextField();

    public RoomsPanel() {
        this.initComponents();
        this.ptm = new RoomsTableModel();
        this.sorter = new TableSorter(this.ptm);
        this.sorter.addMouseListenerToHeaderInTable(this.jTable1);
        this.jTable1.setModel(this.sorter);
        this.addListeners();
        this.setColumnSizes();
    }

    private void setColumnSizes() {
        TableColumn column = null;
        column = this.jTable1.getColumnModel().getColumn(0);
        column.setPreferredWidth(50);
        column = this.jTable1.getColumnModel().getColumn(1);
        column.setPreferredWidth(50);
        column = this.jTable1.getColumnModel().getColumn(2);
        column.setPreferredWidth(30);
        this.buildingColumn = this.jTable1.getColumnModel().getColumn(0);
        this.roomColumn = this.jTable1.getColumnModel().getColumn(1);
        this.capacityColumn = this.jTable1.getColumnModel().getColumn(2);
        this.buildingColumn.setCellEditor(new DefaultCellEditor(this.editBuilding));
        this.roomColumn.setCellEditor(new DefaultCellEditor(this.editRoom));
        this.capacityColumn.setCellEditor(new DefaultCellEditor(this.editCapacity));
    }

    private void addListeners() {
        RoomsPanelListener roomsPanelListener = new RoomsPanelListener();
        this.jButton1.addActionListener(roomsPanelListener);
        this.jButton2.addActionListener(roomsPanelListener);
        this.editBuilding.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int row = RoomsPanel.this.jTable1.getSelectedRow();
                int theRealIndex = RoomsPanel.this.sorter.map(row);
                if (theRealIndex >= 0) {
                    String buildingStr = RoomsPanel.this.editBuilding.getText();
                    Classroom roomModified = (Classroom)RoomsPanel.this.schedule.getClassrooms().get(theRealIndex);
                    roomModified.setBuilding(buildingStr);
                    RoomsPanel.this.ptm.fireTableDataChanged();
                    RoomsPanel.this.schedule.setChanged(true);
                }
            }
        });
        this.editRoom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int row = RoomsPanel.this.jTable1.getSelectedRow();
                int theRealIndex = RoomsPanel.this.sorter.map(row);
                if (theRealIndex >= 0) {
                    String room = RoomsPanel.this.editRoom.getText();
                    Classroom roomModified = (Classroom)RoomsPanel.this.schedule.getClassrooms().get(theRealIndex);
                    roomModified.setRoomName(room);
                    RoomsPanel.this.ptm.fireTableDataChanged();
                    RoomsPanel.this.schedule.setChanged(true);
                }
            }
        });
        this.editCapacity.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int row = RoomsPanel.this.jTable1.getSelectedRow();
                int theRealIndex = RoomsPanel.this.sorter.map(row);
                if (theRealIndex >= 0) {
                    String capStr = RoomsPanel.this.editCapacity.getText();
                    Classroom roomModified = (Classroom)RoomsPanel.this.schedule.getClassrooms().get(theRealIndex);
                    int capacity = 0;
                    try {
                        capacity = Integer.parseInt(capStr);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    roomModified.setCapacity(capacity);
                    RoomsPanel.this.ptm.fireTableDataChanged();
                    RoomsPanel.this.schedule.setChanged(true);
                }
            }
        });
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel3 = new JPanel();
        this.jButton1 = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jTextField2 = new JTextField();
        this.jTextField3 = new JTextField();
        this.jPanel4 = new JPanel();
        this.jButton2 = new JButton();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jScrollPane1.setToolTipText("Double click on heading to sort");
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable1.setToolTipText("Double click to change room info");
        this.jTable1.setPreferredScrollableViewportSize(new Dimension(300, 400));
        this.jScrollPane1.setViewportView(this.jTable1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.weighty = 0.9;
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jButton1.setText("Delete Selected Room(s)");
        this.jButton1.setToolTipText("Remove one or more rooms from the list");
        this.jButton1.setMaximumSize(new Dimension(175, 26));
        this.jButton1.setMinimumSize(new Dimension(250, 26));
        this.jButton1.setPreferredSize(new Dimension(175, 26));
        this.jPanel3.add(this.jButton1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(17, 0, 17, 0);
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = -53;
        gridBagConstraints.ipady = -25;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(17, 17, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(new CompoundBorder(new EtchedBorder(), new BevelBorder(0)));
        this.jLabel1.setText("Building:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(17, 6, 0, 0);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("Room:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("Capacity:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        this.jTextField1.setToolTipText("Usually a number, e.g., \"7\"");
        this.jTextField1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RoomsPanel.this.jTextField1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 75;
        gridBagConstraints.insets = new Insets(17, 6, 0, 18);
        this.jPanel2.add((Component)this.jTextField1, gridBagConstraints);
        this.jTextField2.setToolTipText("Usually a number, e.g., \"122\"");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.insets = new Insets(6, 6, 0, 18);
        this.jPanel2.add((Component)this.jTextField2, gridBagConstraints);
        this.jTextField3.setToolTipText("Max # of students in this room");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.insets = new Insets(6, 6, 0, 18);
        this.jPanel2.add((Component)this.jTextField3, gridBagConstraints);
        this.jButton2.setText("Add Room");
        this.jButton2.setToolTipText("Add this room to the list");
        this.jPanel4.add(this.jButton2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(17, 0, 17, 0);
        this.jPanel2.add((Component)this.jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(17, 17, 0, 17);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void jTextField1ActionPerformed(ActionEvent evt) {
    }

    public void update(Observable observable, Object obj) {
        this.ptm.fireTableDataChanged();
    }

    class RoomsPanelListener
    implements ActionListener {
        RoomsPanelListener() {
        }

        public void actionPerformed(ActionEvent e) {
            System.out.println("I hear |" + e.getActionCommand() + "|");
            if (e.getActionCommand().equals("Add Room")) {
                String building = RoomsPanel.this.jTextField1.getText().trim();
                String room = RoomsPanel.this.jTextField2.getText().trim();
                String capString = "";
                int capacity = 0;
                if (building.equals("") || room.equals("")) {
                    return;
                }
                capString = RoomsPanel.this.jTextField3.getText().trim();
                if (!capString.equals("")) {
                    try {
                        capacity = Integer.parseInt(capString);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                Classroom classroom = new Classroom(building, room, capacity);
                RoomsPanel.this.schedule.addClassroom(classroom);
                RoomsPanel.this.jTextField1.setText("");
                RoomsPanel.this.jTextField2.setText("");
                RoomsPanel.this.jTextField3.setText("");
            } else if (e.getActionCommand().equals("Delete Selected Room(s)")) {
                System.out.println("I'm deleting a room over here");
                int[] selected = RoomsPanel.this.jTable1.getSelectedRows();
                for (int i = selected.length - 1; i >= 0; --i) {
                    int realIndex = RoomsPanel.this.sorter.map(selected[i]);
                    RoomsPanel.this.schedule.removeClassroom((Classroom)RoomsPanel.this.schedule.getClassrooms().get(realIndex));
                }
            }
        }
    }
}

